<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:akc4="https://puesc.gov.pl/ZEFIR2/xsd/v7_0/AKC_4.xsd" xmlns:akc4a="https://puesc.gov.pl/ZEFIR2/xsd/v5_0/AKC_4A.xsd" xmlns:akc4b="https://puesc.gov.pl/ZEFIR2/xsd/v5_0/AKC_4B.xsd" xmlns:akc4c="https://puesc.gov.pl/ZEFIR2/xsd/v5_0/AKC_4C.xsd" xmlns:akc4d="https://puesc.gov.pl/ZEFIR2/xsd/v5_0/AKC_4D.xsd" xmlns:akc4e="https://puesc.gov.pl/ZEFIR2/xsd/v6_0/AKC_4E.xsd" xmlns:akc4f="https://puesc.gov.pl/ZEFIR2/xsd/v5_0/AKC_4F.xsd" xmlns:akc4h="https://puesc.gov.pl/ZEFIR2/xsd/v6_0/AKC_4H.xsd" xmlns:akc4i="https://puesc.gov.pl/ZEFIR2/xsd/v5_0/AKC_4I.xsd" xmlns:akc4j="https://puesc.gov.pl/ZEFIR2/xsd/v5_0/AKC_4J.xsd" xmlns:akc4k="https://puesc.gov.pl/ZEFIR2/xsd/v6_0/AKC_4K.xsd" xmlns:akc4l="https://puesc.gov.pl/ZEFIR2/xsd/v6_0/AKC_4L.xsd" xmlns:akc4m="https://puesc.gov.pl/ZEFIR2/xsd/v4_0/AKC_4M.xsd" xmlns:akc4n="https://puesc.gov.pl/ZEFIR2/xsd/v3_0/AKC_4N.xsd" xmlns:akc4o="https://puesc.gov.pl/ZEFIR2/xsd/v1_0/AKC_4O.xsd" xmlns:akc4p="https://puesc.gov.pl/ZEFIR2/xsd/v1_0/AKC_4P.xsd" xmlns:akc4r="https://puesc.gov.pl/ZEFIR2/xsd/v1_0/AKC_4R.xsd" xmlns:auth="https://puesc.gov.pl/ZEFIR2/xsd/v3_0/Authentication.xsd" xmlns:ns1="http://www.w3.org/2000/09/xmldsig#" xmlns:tp13="https://puesc.gov.pl/ZEFIR2/xsd/v13_0/Types.xsd" xmlns:tr13="https://puesc.gov.pl/ZEFIR2/xsd/v13_0/Trader.xsd" version="1.0">
	<xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/>
	<xsl:output encoding="iso-8859-1" method="html"/>
	<xsl:template match="/">
		<xsl:apply-templates select="*"/>
	</xsl:template>
	<!-- POCZATEK ALL -->
	<!-- STYL ARKUSZA -->
	<xsl:template match="*" mode="styl1">
		<style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style>
		<style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style>
		<style type="text/css">a{color:#3366FF;font-weight:bold;}</style>
		<style type="text/css">h3{padding:3px;cursor:help;}</style>
		<style type="text/css">h4,h5,.copyr{text-align:center;}</style>
		<style type="text/css">caption{font-weight:bold;}</style>
		<style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style>
		<style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style>
		<style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style>
		<style type="text/css">#cont{display:none}</style>
		<style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style>
		<style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style>
		<style type="text/css">.nag2{font-size: 20px}</style>
		<style type="text/css">.cz10 {font-size: 10px}</style>
		<style type="text/css">.cz12 {	font-size: 12px}</style>
		<style type="text/css">.cz18 {font-size: 18px}</style>
		<style type="text/css">.cz16 {font-size: 16px}</style>
		<style type="text/css">.cz14 {font-size: 14px}</style>
		<style type="text/css">.cz14 {font-size: 14px}</style>
		<style type="text/css">#line{    border-bottom: 1px black solid;    overflow:visible;    height:9px;            margin: 5px 0 10px 0;}</style>
	</xsl:template>
	<!-- SZABLON STOPKI -->
	<xsl:template match="*" mode="stopka">
		<xsl:text>AKC4</xsl:text>
	</xsl:template>
	<!-- Tymczasowe wbudowanie stylu -->
	<xsl:template match="*" mode="styl2">
		<style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style>
		<style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:green;}</style>
		<style type="text/css">a{color:#3366FF;font-weight:bold;}</style>
		<style type="text/css">h3{padding:3px;cursor:help;}</style>
		<style type="text/css">h4,h5,.copyr{text-align:center;}</style>
		<style type="text/css">caption{font-weight:bold;}</style>
		<style type="text/css">table,div,td{font-size:8pt;border-color:green;}</style>
		<style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style>
		<style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style>
		<style type="text/css">#cont{display:none}</style>
		<style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style>
		<style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style>
		<style type="text/css">.nag2{font-size: 20px}</style>
		<style type="text/css">.cz10 {font-size: 10px}</style>
		<style type="text/css">.cz12 {font-size: 12px}</style>
		<style type="text/css">.cz18 {font-size: 18px}</style>
		<style type="text/css">.cz16 {font-size: 16px}</style>
		<style type="text/css">.cz14 {font-size: 14px}</style>
	</xsl:template>
	<xsl:template match="*">
		<xsl:apply-templates mode="styl1" select="*"/>
		<!-- DEKLARACJE AKCYZOWE -->
		<xsl:apply-templates mode="dekl_AKC4" select="."/>
	</xsl:template>
	<!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH -->
	<xsl:template match="*" mode="dekl_AKC4">
		<xsl:for-each select=" akc4:Header">
			<!-- ZASTOSOWANIE STYLU -->
			<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
			<xsl:apply-templates mode="Ident_AKC4" select="."/>
			<!-- SZABLON DLA RODZAJU DEKLARACJI -->
			<xsl:apply-templates mode="rodz_dekl" select="."/>
			<!-- SZABLON DOT.  OKRESU ROK MIESIAC -->
			<xsl:apply-templates mode="rok_mc" select="."/>
			<!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI -->
			<xsl:apply-templates mode="PodstawaPrawna" select="."/>
			<!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI -->
			<xsl:apply-templates mode="MiejsceDekl" select="."/>
			<!-- SZABLON DOT. DANYCH PODATNIKA -->
			<xsl:apply-templates mode="DanePodatnika" select="."/>
			<!-- SZABLON DOT. ADRESU PODATNIKA -->
			<xsl:apply-templates mode="Adres" select="."/>
			<!-- SZABLON DOT. PODATKU OGOLEM -->
			<xsl:apply-templates mode="OgolemPodatek" select="."/>
			<!-- SZABLON DOT. ROZLICZENIA PODATKU -->
			<xsl:apply-templates mode="RozliczeniePodatku" select="."/>
			<!-- SZABLON DOT. PODATKU DO ZAPLATY -->
			<xsl:apply-templates mode="PodatekDoZaplaty" select="."/>
			<!--SZABLON DOT. INFORMACJI O ZALACZNIKACH -->
			<xsl:apply-templates mode="InfZal" select="."/>
			<!--SZABLON DOT. NUMEROW AKCYZOWYCH -->
			<!--<xsl:apply-templates mode="NumeryAkc" select="."/> -->
			<!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ -->
			<xsl:apply-templates mode="OswPodatnika" select="."/>
			<!-- SZABLON DOT. ADNOTACJI-->
			<xsl:apply-templates mode="Adnotacje" select="."/>
			<!--<xsl:apply-templates mode="NowaStrona_Zal" select="."/> -->
			<!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA-->
			<xsl:apply-templates mode="ObjaśnienieAkc" select="."/>
			<!--ZALACZNIKI ACK4A -->
			<xsl:for-each select=".//akc4a:AKC4A">
				<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
				<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
				<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
				<xsl:apply-templates mode="Ident" select="./*"/>
				<!-- SZABLON DLA RODZAJU DEKLARACJI -->
				<xsl:apply-templates mode="rodz_dekl" select="."/>
				<!-- OKRES -->
				<xsl:apply-templates mode="rok_mc_zal" select="."/>
				<!-- LINIJKA -->
				<xsl:apply-templates mode="linika" select="."/>
				<!-- CZESC A - DANE PODATNIKA  -->
				<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
				<!-- CZESC B - DANE O SKLADZIE PODATKOWYM -->
				<xsl:apply-templates mode="DaneSklad_Zal" select="."/>
				<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
				<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
				<!-- CZESC D - ROZLICZENIE  PODATKU AKCYZOWEGO -->
				<xsl:apply-templates mode="RozliczeniePodatku_Zal" select="."/>
				<!-- CZESC E - WPLATY DZIENNE -->
				<xsl:apply-templates mode="WplatyDzienne_Zal" select="."/>
				<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
				<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
				<xsl:apply-templates mode="Wyroby_Zal" select="."/>
			</xsl:for-each>
			<!--ZALACZNIKI ACK4B -->
			<xsl:for-each select=".//akc4b:AKC4B">
				<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
				<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
				<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
				<xsl:apply-templates mode="Ident" select="./*"/>
				<!-- SZABLON DLA RODZAJU DEKLARACJI -->
				<xsl:apply-templates mode="rodz_dekl" select="."/>
				<!-- OKRES -->
				<xsl:apply-templates mode="rok_mc_zal" select="."/>
				<!-- LINIJKA -->
				<xsl:apply-templates mode="linika" select="."/>
				<!-- CZESC A - DANE PODATNIKA  -->
				<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
				<!-- CZESC B - DANE O SKLADZIE PODATKOWYM -->
				<xsl:apply-templates mode="DaneSklad_Zal" select="."/>
				<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
				<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
				<!-- CZESC D - ROZLICZENIE  PODATKU AKCYZOWEGO -->
				<xsl:apply-templates mode="RozliczeniePodatku_Zal" select="."/>
				<!-- CZESC E - WPLATY DZIENNE -->
				<xsl:apply-templates mode="WplatyDzienne_Zal" select="."/>
				<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
				<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
				<xsl:apply-templates mode="Wyroby_Zal" select="."/>
			</xsl:for-each>
			<!--ZALACZNIKI ACK4C -->
			<xsl:for-each select=".//akc4c:AKC4C">
				<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
				<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
				<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
				<xsl:apply-templates mode="Ident" select="./*"/>
				<!-- SZABLON DLA RODZAJU DEKLARACJI -->
				<xsl:apply-templates mode="rodz_dekl" select="."/>
				<!-- OKRES -->
				<xsl:apply-templates mode="rok_mc_zal" select="."/>
				<!-- LINIJKA -->
				<xsl:apply-templates mode="linika" select="."/>
				<!-- CZESC A - DANE PODATNIKA  -->
				<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
				<!-- CZESC B - DANE O SKLADZIE PODATKOWYM -->
				<xsl:apply-templates mode="DaneSklad_Zal" select="."/>
				<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
				<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
				<!-- CZESC D - ROZLICZENIE  PODATKU AKCYZOWEGO -->
				<xsl:apply-templates mode="RozliczeniePodatku_Zal" select="."/>
				<!-- CZESC E - WPLATY DZIENNE -->
				<xsl:apply-templates mode="WplatyDzienne_Zal" select="."/>
				<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
				<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
				<xsl:apply-templates mode="Wyroby_Zal" select="."/>
			</xsl:for-each>
			<!--ZALACZNIKI ACK4D -->
			<xsl:for-each select=".//akc4d:AKC4D">
				<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
				<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
				<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
				<xsl:apply-templates mode="Ident" select="./*"/>
				<!-- SZABLON DLA RODZAJU DEKLARACJI -->
				<xsl:apply-templates mode="rodz_dekl" select="."/>
				<!-- OKRES -->
				<xsl:apply-templates mode="rok_mc_zal" select="."/>
				<!-- LINIJKA -->
				<xsl:apply-templates mode="linika" select="."/>
				<!-- CZESC A - DANE PODATNIKA  -->
				<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
				<!-- CZESC B - DANE O SKLADZIE PODATKOWYM -->
				<xsl:apply-templates mode="DaneSklad_Zal" select="."/>
				<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
				<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
				<!-- CZESC D - ROZLICZENIE  PODATKU AKCYZOWEGO -->
				<xsl:apply-templates mode="RozliczeniePodatku_Zal" select="."/>
				<!-- CZESC E - WPLATY DZIENNE -->
				<xsl:apply-templates mode="WplatyDzienne_Zal" select="."/>
				<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
				<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
				<xsl:apply-templates mode="Wyroby_Zal" select="."/>
			</xsl:for-each>
			<!--ZALACZNIKI ACK4E -->
			<xsl:for-each select=".//akc4e:AKC4E">
				<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
				<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
				<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
				<xsl:apply-templates mode="Ident" select="./*"/>
				<!-- SZABLON DLA RODZAJU DEKLARACJI -->
				<xsl:apply-templates mode="rodz_dekl" select="."/>
				<!-- OKRES -->
				<xsl:apply-templates mode="rok_mc_zal" select="."/>
				<!-- LINIJKA -->
				<xsl:apply-templates mode="linika" select="."/>
				<!-- CZESC A - DANE PODATNIKA  -->
				<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
				<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
				<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
				<!-- objaśnienia -->
				<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
				<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
				<xsl:apply-templates mode="Wyroby_Zal" select="."/>
			</xsl:for-each>
			<!--ZALACZNIKI ACK4F -->
			<xsl:for-each select=".//akc4f:AKC4F">
				<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
				<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
				<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
				<xsl:apply-templates mode="Ident" select="./*"/>
				<!-- SZABLON DLA RODZAJU DEKLARACJI -->
				<xsl:apply-templates mode="rodz_dekl" select="."/>
				<!-- OKRES -->
				<xsl:apply-templates mode="rok_mc_zal" select="."/>
				<!-- LINIJKA -->
				<xsl:apply-templates mode="linika" select="."/>
				<!-- CZESC A - DANE PODATNIKA  -->
				<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
				<!-- CZESC B - DANE O SKLADZIE PODATKOWYM -->
				<xsl:apply-templates mode="DaneSklad_Zal" select="."/>
				<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
				<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
				<!-- CZESC D - ROZLICZENIE  PODATKU AKCYZOWEGO -->
				<xsl:apply-templates mode="RozliczeniePodatku_Zal" select="."/>
				<!-- CZESC E - WPLATY DZIENNE -->
				<xsl:apply-templates mode="WplatyDzienne_Zal" select="."/>
				<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
				<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
				<xsl:apply-templates mode="Wyroby_Zal" select="."/>
			</xsl:for-each>
			<!--ZALACZNIKI ACK4H -->
			<xsl:for-each select=".//akc4h:AKC4H">
				<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
				<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
				<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
				<xsl:apply-templates mode="Ident" select="./*"/>
				<!-- SZABLON DLA RODZAJU DEKLARACJI -->
				<xsl:apply-templates mode="rodz_dekl" select="."/>
				<!-- OKRES -->
				<xsl:apply-templates mode="rok_mc_zal" select="."/>
				<!-- LINIJKA -->
				<xsl:apply-templates mode="linika" select="."/>
				<!-- CZESC A - DANE PODATNIKA  -->
				<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
				<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
				<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
				<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
				<xsl:apply-templates mode="Wyroby_Zal" select="."/>
			</xsl:for-each>
			<!--ZALACZNIKI ACK4I -->
			<xsl:for-each select=".//akc4i:AKC4I">
				<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
				<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
				<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
				<xsl:apply-templates mode="Ident" select="./*"/>
				<!-- SZABLON DLA RODZAJU DEKLARACJI -->
				<xsl:apply-templates mode="rodz_dekl" select="."/>
				<!-- OKRES -->
				<xsl:apply-templates mode="rok_mc_zal" select="."/>
				<!-- LINIJKA -->
				<xsl:apply-templates mode="linika" select="."/>
				<!-- CZESC A - DANE PODATNIKA  -->
				<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
				<!-- CZESC B - DANE O SKLADZIE PODATKOWYM -->
				<xsl:apply-templates mode="DaneSklad_Zal" select="."/>
				<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
				<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
				<!-- CZESC D - ROZLICZENIE  PODATKU AKCYZOWEGO -->
				<xsl:apply-templates mode="RozliczeniePodatku_Zal" select="."/>
				<!-- CZESC E - WPLATY DZIENNE -->
				<xsl:apply-templates mode="WplatyDzienne_Zal" select="."/>
				<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
				<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
				<xsl:apply-templates mode="Wyroby_Zal" select="."/>
			</xsl:for-each>
			<!--ZALACZNIKI ACK4J -->
			<xsl:for-each select=".//akc4j:AKC4J">
				<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
				<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
				<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
				<xsl:apply-templates mode="Ident" select="./*"/>
				<!-- SZABLON DLA RODZAJU DEKLARACJI -->
				<xsl:apply-templates mode="rodz_dekl" select="."/>
				<!-- OKRES -->
				<xsl:apply-templates mode="rok_mc_zal" select="."/>
				<!-- LINIJKA -->
				<xsl:apply-templates mode="linika" select="."/>
				<!-- CZESC A - DANE PODATNIKA  -->
				<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
				<!-- CZESC B - DANE O SKLADZIE PODATKOWYM -->
				<xsl:apply-templates mode="DaneSklad_Zal" select="."/>
				<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
				<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
				<!-- CZESC D - ROZLICZENIE  PODATKU AKCYZOWEGO -->
				<xsl:apply-templates mode="RozliczeniePodatku_Zal" select="."/>
				<!-- CZESC E - WPLATY DZIENNE -->
				<xsl:apply-templates mode="WplatyDzienne_Zal" select="."/>
				<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
				<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
				<xsl:apply-templates mode="Wyroby_Zal" select="."/>
			</xsl:for-each>
			<!--ZALACZNIKI ACK4K -->
			<xsl:for-each select=".//akc4k:AKC4K">
				<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
				<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
				<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
				<xsl:apply-templates mode="Ident" select="./*"/>
				<!-- SZABLON DLA RODZAJU DEKLARACJI -->
				<xsl:apply-templates mode="rodz_dekl" select="."/>
				<!-- OKRES -->
				<xsl:apply-templates mode="rok_mc_zal" select="."/>
				<!-- LINIJKA -->
				<xsl:apply-templates mode="linika" select="."/>
				<!-- CZESC A - DANE PODATNIKA  -->
				<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
				<!-- CZESC B - DANE O SKLADZIE PODATKOWYM -->
				<xsl:apply-templates mode="DaneSklad_Zal" select="."/>
				<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
				<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
				<!-- CZESC D - ROZLICZENIE  PODATKU AKCYZOWEGO -->
				<xsl:apply-templates mode="RozliczeniePodatku_Zal" select="."/>
				<!-- CZESC E - WPLATY DZIENNE -->
				<xsl:apply-templates mode="WplatyDzienne_Zal" select="."/>
				<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
				<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
				<xsl:apply-templates mode="Wyroby_Zal" select="."/>
			</xsl:for-each>
			<!--ZALACZNIKI ACK4L -->
			<xsl:for-each select=".//akc4l:AKC4L">
				<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
				<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
				<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
				<xsl:apply-templates mode="Ident" select="./*"/>
				<!-- SZABLON DLA RODZAJU DEKLARACJI -->
				<xsl:apply-templates mode="rodz_dekl" select="."/>
				<!-- OKRES -->
				<xsl:apply-templates mode="rok_mc_zal" select="."/>
				<!-- LINIJKA -->
				<xsl:apply-templates mode="linika" select="."/>
				<!-- CZESC A - DANE PODATNIKA  -->
				<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
				<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
				<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
				<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
				<xsl:apply-templates mode="Wyroby_Zal" select="."/>
			</xsl:for-each>
		</xsl:for-each>
		<!--ZALACZNIKI ACK4M -->
		<xsl:for-each select=".//akc4m:AKC4M">
			<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
			<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
			<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
			<xsl:apply-templates mode="Ident" select="./*"/>
			<!-- SZABLON DLA RODZAJU DEKLARACJI -->
			<xsl:apply-templates mode="rodz_dekl" select="."/>
			<!-- OKRES -->
			<xsl:apply-templates mode="rok_mc_zal" select="."/>
			<!-- LINIJKA -->
			<xsl:apply-templates mode="linika" select="."/>
			<!-- CZESC A - DANE PODATNIKA  -->
			<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
			<!-- CZESC B - DANE O SKLADZIE PODATKOWYM -->
			<xsl:apply-templates mode="DaneSklad_Zal" select="."/>
			<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
			<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
			<!-- CZESC D - ROZLICZENIE  PODATKU AKCYZOWEGO -->
			<xsl:apply-templates mode="RozliczeniePodatku_Zal" select="."/>
			<!-- CZESC E - WPLATY DZIENNE -->
			<xsl:apply-templates mode="WplatyDzienne_Zal" select="."/>
			<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
			<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
			<xsl:apply-templates mode="Wyroby_Zal" select="."/>
		</xsl:for-each>
		<!--ZALACZNIKI ACK4N -->
		<xsl:for-each select=".//akc4n:AKC4N">
			<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
			<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
			<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
			<xsl:apply-templates mode="Ident" select="./*"/>
			<!-- SZABLON DLA RODZAJU DEKLARACJI -->
			<xsl:apply-templates mode="rodz_dekl" select="."/>
			<!-- OKRES -->
			<xsl:apply-templates mode="rok_mc_zal" select="."/>
			<!-- LINIJKA -->
			<xsl:apply-templates mode="linika" select="."/>
			<!-- CZESC A - DANE PODATNIKA  -->
			<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
			<!-- CZESC B - DANE O SKLADZIE PODATKOWYM -->
			<xsl:apply-templates mode="DaneSklad_Zal" select="."/>
			<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
			<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
			<!-- CZESC D - ROZLICZENIE  PODATKU AKCYZOWEGO -->
			<xsl:apply-templates mode="RozliczeniePodatku_Zal" select="."/>
			<!-- CZESC E - WPLATY DZIENNE -->
			<xsl:apply-templates mode="WplatyDzienne_Zal" select="."/>
			<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
			<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
			<xsl:apply-templates mode="Wyroby_Zal" select="."/>
		</xsl:for-each>
		<!--ZALACZNIKI ACK4O -->
		<xsl:for-each select=".//akc4o:AKC4O">
			<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
			<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
			<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
			<xsl:apply-templates mode="Ident" select="./*"/>
			<!-- SZABLON DLA RODZAJU DEKLARACJI -->
			<xsl:apply-templates mode="rodz_dekl" select="."/>
			<!-- OKRES -->
			<xsl:apply-templates mode="rok_mc_zal" select="."/>
			<!-- LINIJKA -->
			<xsl:apply-templates mode="linika" select="."/>
			<!-- CZESC A - DANE PODATNIKA  -->
			<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
			<!-- CZESC B - DANE O SKLADZIE PODATKOWYM -->
			<xsl:apply-templates mode="DaneSklad_Zal" select="."/>
			<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
			<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
			<!-- CZESC D - ROZLICZENIE  PODATKU AKCYZOWEGO -->
			<xsl:apply-templates mode="RozliczeniePodatku_Zal" select="."/>
			<!-- CZESC E - WPLATY DZIENNE -->
			<xsl:apply-templates mode="WplatyDzienne_Zal" select="."/>
			<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
			<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
			<xsl:apply-templates mode="Wyroby_Zal" select="."/>
		</xsl:for-each>
		<!--ZALACZNIKI ACK4P -->
		<xsl:for-each select=".//akc4p:AKC4P">
			<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
			<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
			<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
			<xsl:apply-templates mode="Ident" select="./*"/>
			<!-- SZABLON DLA RODZAJU DEKLARACJI -->
			<xsl:apply-templates mode="rodz_dekl" select="."/>
			<!-- OKRES -->
			<xsl:apply-templates mode="rok_mc_zal" select="."/>
			<!-- LINIJKA -->
			<xsl:apply-templates mode="linika" select="."/>
			<!-- CZESC A - DANE PODATNIKA  -->
			<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
			<!-- CZESC B - DANE O SKLADZIE PODATKOWYM -->
			<xsl:apply-templates mode="DaneSklad_Zal" select="."/>
			<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
			<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
			<!-- CZESC D - ROZLICZENIE  PODATKU AKCYZOWEGO -->
			<xsl:apply-templates mode="RozliczeniePodatku_Zal" select="."/>
			<!-- CZESC E - WPLATY DZIENNE -->
			<xsl:apply-templates mode="WplatyDzienne_Zal" select="."/>
			<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
			<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
			<xsl:apply-templates mode="Wyroby_Zal" select="."/>
		</xsl:for-each>
		<!--ZALACZNIKI ACK4R -->
		<xsl:for-each select=".//akc4r:AKC4R">
			<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
			<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
			<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
			<xsl:apply-templates mode="Ident" select="./*"/>
			<!-- SZABLON DLA RODZAJU DEKLARACJI -->
			<xsl:apply-templates mode="rodz_dekl" select="."/>
			<!-- OKRES -->
			<xsl:apply-templates mode="rok_mc_zal" select="."/>
			<!-- LINIJKA -->
			<xsl:apply-templates mode="linika" select="."/>
			<!-- CZESC A - DANE PODATNIKA  -->
			<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
			<!-- CZESC B - DANE O SKLADZIE PODATKOWYM -->
			<xsl:apply-templates mode="DaneSklad_Zal" select="."/>
			<!-- CZESC C - OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO-->
			<xsl:apply-templates mode="KwotaPodatku_Zal" select="."/>
			<!-- CZESC D - ROZLICZENIE  PODATKU AKCYZOWEGO -->
			<xsl:apply-templates mode="RozliczeniePodatku_Zal" select="."/>
			<!-- CZESC E - WPLATY DZIENNE -->
			<xsl:apply-templates mode="WplatyDzienne_Zal" select="."/>
			<xsl:apply-templates mode="Objaśnienie_wplaty" select="."/>
			<!-- CZESC F - OBLICZENIE KWOT PODATKU OD WYROBOW -->
			<xsl:apply-templates mode="Wyroby_Zal" select="."/>
		</xsl:for-each>
	</xsl:template>
	<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA AKC4-->
	<xsl:template match="*" mode="Ident_AKC4">
		<table border="1" width="955">
			<tr align="left" valign="top">
				<td align="left" colspan="2" height="45" valign="middle" width="586">
					<span class="cz12">
						<xsl:choose>
							<xsl:when test="string-length(@identifier)='10'">
								<b>1. Identyfikator podatkowy NIP/<s>numer PESEL</s>
								</b>
								<sup>(niepotrzebne skreślić)</sup>
								<b> podatnika</b>
								<sup>1)</sup>
							</xsl:when>
							<xsl:otherwise>
								<b>1. <s>Identyfikator podatkowy NIP</s>/numer PESEL <sup>(niepotrzebne skreślić)</sup> podatnika<sup>1)</sup>
								</b>
							</xsl:otherwise>
						</xsl:choose>
					</span>
				</td>
				<td align="center" colspan="2" valign="middle" width="353">
					<span class="nag2">
						<b>
							<xsl:value-of select="@identifier"/>
						</b>
					</span>
				</td>
			</tr>
			<tr align="left" colspan="1" valign="top">
				<td align="left" height="45" valign="top" width="353"/>
				<td align="left" bgcolor="#CCFFCC" colspan="2" height="45" valign="top">
					<b>2. Nr dokumentu</b>
					<br/>
					<span class="cz16">
						<b>
							<xsl:value-of select="@selfRef"/>
						</b>
					</span>
				</td>
				<td align="left" bgcolor="#CCFFCC" colspan="1" height="45" valign="top">
					<b>3. Status</b>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="*" mode="Ubytki">
		<xsl:choose>
			<xsl:when test=".//@shortages='UB'">
				<span class="cz10">ubytki</span>
			</xsl:when>
			<xsl:when test=".//@shortages='CZ'">
				<span class="cz10">całkowite zniszczenie</span>
			</xsl:when>
			<xsl:otherwise/>
		</xsl:choose>
	</xsl:template>
	<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
	<xsl:template match="*" mode="Ident">
		<table border="1" width="955">
			<tr align="left" valign="top">
				<td align="left" colspan="2" height="45" valign="middle" width="586">
					<span class="cz12">
						<xsl:choose>
							<xsl:when test="string-length(@identifier)='10'">
								<b>1. Identyfikator podatkowy NIP/<s>numer PESEL</s>
								</b>
								<sup>(niepotrzebne skreślić)</sup>
								<b> podatnika</b>
							</xsl:when>
							<xsl:otherwise>
								<b>1. <s>Identyfikator podatkowy NIP</s>/numer PESEL <sup>(niepotrzebne skreślić)</sup> podatnika </b>
							</xsl:otherwise>
						</xsl:choose>
					</span>
				</td>
				<td align="center" colspan="2" valign="middle" width="353">
					<span class="nag2">
						<b>
							<xsl:value-of select="@identifier"/>
						</b>
					</span>
				</td>
			</tr>
			<!--		<tr align="left" colspan="1" valign="top"> <td align="left" height="45" valign="top" width="353"/> <td align="left" bgcolor="#CCCCCC" colspan="2" height="45" valign="top"> <b>2. Nr dokumentu</b> <br/> <span class="cz16"> <b> <xsl:value-of select="@selfRef"/> </b> </span> </td> <td align="left" bgcolor="#CCCCCC" colspan="1" height="45" valign="top"> <b>3. Status</b> </td> </tr> -->
		</table>
		<!--	<table border="1" width="955"> <tr align="left" valign="top"> <td align="left" height="45" valign="middle" width="586"> <span class="cz12"> <b>1. Identyfikator podatkowy NIP/numer PESEL<sup>(niepotrzebne skreślić)</sup> podatnika </b> </span> </td> <td align="center" valign="middle" width="353"> <span class="nag2"> <b> <xsl:value-of select="//@identifier"/> </b> </span> </td> </tr> </table> -->
	</xsl:template>
	<!-- SZABLON DOT.  RODZAJU DEKLARACJI -->
	<xsl:template match="*" mode="rodz_dekl">
		<xsl:if test="akc4a:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/A</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#FF99CC</xsl:attribute>
						<div align="left" class="nag1">PODATEK AKCYZOWY OD ALKOHOLU ETYLOWEGO <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4b:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/B</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#FF33CC</xsl:attribute>
						<div align="left" class="nag1">PODATEK AKCYZOWY OD WINA, NAPOJÓW FERMENTOWANYCH I WYROBÓW POŚREDNICH <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4c:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/C</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#FFFF33</xsl:attribute>
						<div align="left" class="nag1">PODATEK AKCYZOWY OD PIWA <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4d:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/D</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#0099FF</xsl:attribute>
						<div align="left" class="nag1">PODATEK AKCYZOWY OD PALIW SILNIKOWYCH <br/> (z wyłączeniem gazu) <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4e:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/E</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#FFCC66</xsl:attribute>
						<div align="left" class="nag1">PODATEK AKCYZOWY OD SAMOCHODÓW OSOBOWYCH <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4f:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/F</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#996600</xsl:attribute>
						<div align="left" class="nag1">PODATEK AKCYZOWY OD WYROBÓW TYTONIOWYCH <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4h:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/H</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#CCFFCC</xsl:attribute>
						<div align="left" class="nag1">PODATEK AKCYZOWY OD ENERGII ELEKTRYCZNEJ <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4i:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/I</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#9999CC</xsl:attribute>
						<div align="left" class="nag1">PODATEK AKCYZOWY OD PALIW OPAŁOWYCH <br/> (z wyłączeniem wyrobów węglowych i wyrobów gazowych) <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4j:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/J</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#FFFFCC</xsl:attribute>
						<div align="left" class="nag1">PODATEK AKCYZOWY OD GAZU DO NAPĘDU SILNIKÓW SPALINOWYCH <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4k:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/K</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#CCFFFF</xsl:attribute>
						<div align="left" class="nag1">PODATEK AKCYZOWY OD PREPARATÓW SMAROWYCH, OLEJÓW SMAROWYCH I POZOSTAŁYCH OLEJÓW <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4l:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/L</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#CCFFFF</xsl:attribute>
						<div align="left" class="nag1">PODATEK AKCYZOWY OD WYROBÓW GAZOWYCH <br/> (z wyłączeniem gazu do napędu silników spalinowych) <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4m:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/M</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
						<div align="left" class="nag1">PODATEK AKCYZOWY OD PŁYNU DO PAPIEROSÓW ELEKTRONICZNYCH   <br/> za</div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4n:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/N</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#efbdff</xsl:attribute>
						<div align="left" class="nag1">PODATEK AKCYZOWY OD WYROBÓW NOWATORSKICH <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4o:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/O</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#cb7a42</xsl:attribute>
						<div align="left" class="nag1">PODATEK  AKCYZOWY  OD  SASZETEK NIKOTYNOWYCH  <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4p:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/P</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#4273cb</xsl:attribute>
						<div align="left" class="nag1">PODATEK  AKCYZOWY  OD  INNYCH WYROBÓW NIKOTYNOWYCH   <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4r:*">
			<table border="1" width="955">
				<tr>
					<td colspan="2" height="61">
						<p class="nag1">AKC-4/R</p>
					</td>
				</tr>
				<tr>
					<td height="61">
						<xsl:attribute name="bgcolor">#cb7a42</xsl:attribute>
						<div align="left" class="nag1">PODATEK  AKCYZOWY  OD  URZĄDZEŃ DO WAPORYZACJI   <br/> za </div>
					</td>
					<!-- <td width="243"/> -->
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4:*">
			<table border="1" width="956">
				<tr>
					<td colspan="3" height="40">
						<xsl:choose>
							<xsl:when test=".//@formKind='AKC-4'">
								<span class="nag1">
									<b>AKC-4/</b>
									<b>
										<s>AKC-4zo</s>
									</b>
								</span>
								<sup>(niepotrzebne skreślić),<b>2)</b>
								</sup>
							</xsl:when>
							<xsl:when test=".//@formKind='AKC-4zo'">
								<span class="nag1">
									<s>AKC-4/</s>
									<b>
										<b>AKC-4zo</b>
									</b>
								</span>
								<sup>(niepotrzebne skreślić),<b>2)</b>
								</sup>
							</xsl:when>
							<xsl:otherwise>
								<span class="nag1">AKC-4/AKC-4zo </span>
								<sup>(niepotrzebne skreślić),<b>2)</b>
								</sup>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
				<tr>
					<!-- <td height="61" width="154"/> -->
					<td width="537">
						<div align="left">
							<span class="nag1">DEKLARACJA W SPRAWIE PODATKU AKCYZOWEGO</span>
							<br/>
							<span class="nag2">za</span>
						</div>
					</td>
					<!-- <td width="243"/>-->
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT.  OKRESU ROK MIESIAC -->
	<xsl:template match="*" mode="rok_mc">
		<xsl:if test="akc4:*">
			<table>
				<tr>
					<td height="49" width="135">
						<b>4. Miesiąc </b>
						<br/>
						<div align="center" class="cz18">
							<xsl:value-of select="substring(@period,6,7)"/>
						</div>
					</td>
					<td align="left" valign="top" width="135">
						<b>5. Rok </b>
						<br/>
						<div align="center" class="cz18">
							<xsl:value-of select="substring(@period,1,4)"/>
						</div>
					</td>
					<!--<td align="left" valign="top" width="131">  </td> <td width="206"/> -->
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI -->
	<xsl:template match="*" mode="PodstawaPrawna">
		<table border="1" width="955">
			<tr bgcolor="#CCFFCC">
				<td align="left" valign="top" width="115">Podstawa prawna: </td>
				<td align="left" valign="top" width="824">Art. 21 ust. 1 pkt 1, art. 24 ust. 1 pkt 2 i 3, art. 24b ust. 1 pkt 2 i 3 oraz art. 106 ust. 1 pkt 1 ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2025 r. poz. 126, z późn. zm.), zwanej dalej „ustawą”.</td>
			</tr>
			<tr bgcolor="#CCFFCC">
				<td align="left" valign="top">Termin składania:</td>
				<td align="left" valign="top">Do 25. dnia miesiąca następującego po miesiącu, w którym powstał obowiązek podatkowy; w przypadku energii elektrycznej – zgodnie z art. 24   ust. 1 pkt 2 i 3 ustawy; w przypadku wyrobów gazowych – zgodnie z art. 24b ust.1 pkt 2 i 3 ustawy.</td>
			</tr>
			<tr bgcolor="#CCFFCC">
				<td align="left" valign="top">Miejsce składania: </td>
				<td align="left" valign="top">Urząd skarbowy, przy pomocy którego wykonuje swoje zadania naczelnik urzędu skarbowego właściwy ze względu na miejsce wykonywania czynności lub wystąpienia stanów faktycznych, podlegających opodatkowaniu podatkiem akcyzowym; jeżeli czynności podlegające opodatkowaniu są wykonywane lub stany faktyczne podlegające opodatkowaniu występują na obszarze właściwości miejscowej dwóch lub więcej naczelników urzędów skarbowych – zgodnie z art. 14 ust. 4–4f ustawy; jeżeli właściwym organem podatkowym jest Naczelnik Trzeciego Urzędu Skarbowego Warszawa-Śródmieście w Warszawie, to miejscem składania jest Trzeci Urząd Skarbowy Warszawa-Śródmieście w Warszawie. </td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI -->
	<xsl:template match="*" mode="MiejsceDekl">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCFFCC" valign="top">
				<td colspan="4">
					<span class="nag1">A. WŁAŚCIWY ORGAN I CEL SKŁADANIA DEKLARACJI</span>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td bgcolor="#CCFFCCC" rowspan="4" width="46"/>
				<td colspan="4">
					<b>6.Naczelnik urzędu skarbowego</b>
					<br/>
					<span class="cz18">
						<xsl:value-of select="@taxOfficeName"/>
					</span>
				</td>
			</tr>
			<tr>
				<td class="style3">
					<b>7. Cel złożenia formularza</b>(zaznaczyć właściwy kwadrat):  <br/>
					<br/>
					<p>
						<xsl:choose>
							<xsl:when test="//@submissionAim='Deklaracja'"> ☑ 1. złożenie deklaracji ☐  2. korekta deklaracji<sup style="cz9">3)</sup>
							</xsl:when>
							<xsl:otherwise>
								<b/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="//@submissionAim='Korekta'"> ☐ 1. złożenie deklaracji ☑  2. korekta deklaracji<sup style="cz9">3)</sup>
							</xsl:when>
							<xsl:otherwise>
								<b/>
							</xsl:otherwise>
						</xsl:choose>
					</p>
				</td>
				<td class="style3" colspan="3">
					<b>8. Korekta deklaracji – informacje dodatkowe</b>
					<sup>4)</sup>
					<br/>
					<br/>
					<p>
						<xsl:choose>
							<xsl:when test="//@applicationForOverpayment='true'"> ☑ wniosek o stwierdzenie nadpłaty powstałej w wyniku korekty deklaracji </xsl:when>
							<xsl:otherwise> ☐ wniosek o stwierdzenie nadpłaty powstałej w wyniku korekty deklaracji </xsl:otherwise>
						</xsl:choose>
					</p>
				</td>
			</tr>
			<td colspan="4">
				<b>9. Uzasadnienie wniosku o stwierdzenie nadpłaty wraz z podaniem wysokości żądanej nadpłaty</b> (wypełnić w przypadku zaznaczenia kwadratu w poz. 8) <br/>
				<span class="cz18">
					<xsl:value-of select="@justification"/>
					<span class="cz18">
						<br/>
						<xsl:value-of select="@overpaymentAmount"/>
					</span>
				</span>
			</td>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. DANYCH PODATNIKA -->
	<xsl:template match="*" mode="DanePodatnika">
		<table border="1" width="955">
			<tr bgcolor="#CCFFCC">
				<td colspan="4">
					<span class="nag1">B. DANE PODATNIKA</span>
				</td>
			</tr>
			<tr bgcolor="#CCFFCC">
				<td colspan="4">
					<span class="nag2">B.1. DANE IDENTYFIKACYJNE</span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCFFCC" rowspan="3" width="40"/>
				<td align="left" colspan="3" height="27" valign="top">
					<b>10. Rodzaj podatnika</b>(zaznaczyć właściwy kwadrat): </td>
			</tr>
			<tr>
				<xsl:if test=".//akc4:Trader/@typeOfTaxpayer='N'">
					<td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/>
						<span class="cz18"> ☑ </span>
					</td>
					<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
						<span class="cz18"> ☐ </span>
					</td>
				</xsl:if>
				<xsl:if test=".//akc4:Trader/@typeOfTaxpayer='F'">
					<td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/>
						<span class="cz18"> ☐ </span>
					</td>
					<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
						<span class="cz18"> ☑ </span>
						<br/>
					</td>
				</xsl:if>
				<!-- <td align="left" valign="top">1. podatnik niebędący osobą fizyczną <br/> <span class="cz18"> <xsl:choose> <xsl:when test=".//akc4:Trader/@typeOfTaxpayer='N'"> <b>&#9745;</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span> </td> <td align="left" valign="top" width="425">2. osoba fizyczna <br/> <span class="cz18"> <xsl:choose> <xsl:when test=".//akc4:Trader/@typeOfTaxpayer='F'"> <b>&#9745;</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span> </td> -->
			</tr>
			<tr>
				<td align="left" colspan="3" valign="top">
					<b>11. Nazwa pełna<sup>5)</sup>/Nazwisko, pierwsze imię<sup>6)</sup>
					</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select="//@fullName"/>
					</span>
					<span class="cz18">
						<xsl:value-of select=".//tr13:PrivatePerson/tr13:BasicData/@surname"/>
					</span>
					<span class="cz18">
						<xsl:value-of select=".//tr13:PrivatePerson/tr13:BasicData/@firstName"/>
					</span>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. ADRESU PODATNIKA -->
	<xsl:template match="*" mode="Adres">
		<table border="1" width="955">
			<tr bgcolor="#CCFFCC">
				<td colspan="6">
					<span class="nag2">B.2. ADRES SIEDZIBY<sup>5)</sup>/ ADRES ZAMIESZKANIA<sup>6)</sup>
					</span>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td bgcolor="#CCFFCC" rowspan="3" width="40"/>
				<td width="269">
					<b>12. Kraj </b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@countryName"/>
					</span>
				</td>
				<td colspan="2">
					<b>13. Województwo</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@provinceName"/>
					</span>
				</td>
				<td colspan="2">
					<b>14. Powiat</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@districtName"/>
					</span>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td>
					<b>15. Gmina </b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@communeName"/>
					</span>
				</td>
				<td colspan="2">
					<b>16. Ulica</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@street"/>
					</span>
				</td>
				<td width="144">
					<b>17. Nr domu</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@houseNumber"/>
					</span>
				</td>
				<td width="151">
					<b>18. Nr lokalu</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@localNumber"/>
					</span>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td colspan="4">
					<b>19. Miejscowość</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@city"/>
					</span>
				</td>
				<td>
					<b>20. Kod pocztowy</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@postalCode"/>
					</span>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. PODATKU OGOLEM -->
	<xsl:template match="*" mode="OgolemPodatek">
		<table border="1" width="955">
			<tr bgcolor="#CCFFCC">
				<td colspan="4">
					<span class="nag1">C. ZESTAWIENIE PODATKU AKCYZOWEGO WEDŁUG GRUP WYROBÓW</span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCFFCC" rowspan="16" width="37"/>
				<td align="left" bgcolor="#CCFFCC" valign="top" width="565">
					<b>Ogółem podatek akcyzowy od alkoholu etylowego</b>
					<br/> 	Kwota z poz. 14 formularza/formularzy nr 1, 2, 3 ...  AKC-4/A.</td>
				<td align="left" colspan="2" valign="top">
					<b>21.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyEthylAlcohol),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od wina, napojów fermentowanych i wyrobów pośrednich</b>
					<br/>Kwota z poz. 14 formularza/formularzy nr 1, 2, 3 ...   AKC-4/B. </td>
				<td align="left" colspan="2" valign="top">
					<b>22.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyWine),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od piwa </b>
					<br/>Kwota z poz. 14 formularza/formularzy nr 1, 2, 3 ... AKC-4/C.</td>
				<td align="left" colspan="2" valign="top">
					<b>23.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyBeer),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od paliw silnikowych (z wyłączeniem gazu) </b>
					<br/>Kwota z poz. 14 formularza/formularzy nr 1, 2, 3 ... AKC-4/D. </td>
				<td align="left" colspan="2" valign="top">
					<b>24.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyFuel),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od samochodów osobowych</b>
					<br/>Kwota z poz. 13 formularza AKC-4/E. </td>
				<td align="left" colspan="2" valign="top">
					<b>25.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyCar),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od wyrobów tytoniowych</b>
					<br/>Kwota z poz. 14 formularza/formularzy nr 1, 2, 3 ... AKC-4/F. </td>
				<td align="left" colspan="2" valign="top">
					<b>26.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyTobacco),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od energii elektrycznej</b>
					<br/>Kwota z poz. 12 formularza AKC-4/H. </td>
				<td align="left" colspan="2" valign="top">
					<b>27.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyElectricity),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od paliw opałowych (z wyłączeniem wyrobów węglowych i wyrobów gazowych)</b>
					<br/>Kwota z poz. 14 formularza/formularzy nr 1, 2, 3 ... AKC-4/I.</td>
				<td align="left" colspan="2" valign="top">
					<b>28.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyHeatingFuel),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od gazu do napędu silników spalinowych</b>
					<br/>Kwota z poz. 14 formularza/formularzy nr 1, 2, 3 ... AKC-4/J.</td>
				<td align="left" colspan="2" valign="top">
					<b>29.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyGasEngine),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od preparatów smarowych, olejów smarowych i pozostałych olejów</b>
					<br/>Kwota z poz. 13 formularza/formularzy nr 1, 2, 3 ... AKC-4/K. </td>
				<td align="left" colspan="2" valign="top">
					<b>30.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyOil),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od wyrobów gazowych (z wyłączeniem gazu do napędu silników spalinowych)</b>
					<br/>Kwota z poz. 14 formularza AKC-4/L. </td>
				<td align="left" colspan="2" valign="top">
					<b>31.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyGas),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od płynu do papierosów elektronicznych</b>
					<br/>Kwota z poz. 13 formularza/formularzy nr 1, 2, 3 ... AKC-4/M. </td>
				<td align="left" colspan="2" valign="top">
					<b>32.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseLiquidECigarettes),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od wyrobów nowatorskich</b>
					<br/>Kwota z poz. 13 formularza/formularzy nr 1, 2, 3 ... AKC-4/N. </td>
				<td align="left" colspan="2" valign="top">
					<b>33.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseInnovativeProducts),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od saszetek nikotynowych</b>
					<br/>Kwota z poz. 13 formularza/formularzy nr 1, 2, 3 ... AKC-4/O. </td>
				<td align="left" colspan="2" valign="top">
					<b>34.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyOnNicotineSachets),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od innych wyrobów nikotynowych</b>
					<br/>Kwota z poz. 13 formularza/formularzy nr 1, 2, 3 ... AKC-4/P. </td>
				<td align="left" colspan="2" valign="top">
					<b>35.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyOnOtherNicotineProducts),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" valign="top">
					<b>Ogółem podatek akcyzowy od urządzeń do waporyzacji</b>
					<br/>Kwota z poz. 13 formularza/formularzy nr 1, 2, 3 ... AKC-4/R. </td>
				<td align="left" colspan="2" valign="top">
					<b>36.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exciseDutyOnVapingDevice),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCFFCC" colspan="3" valign="top">
					<b>Razem podatek akcyzowy </b>
					<br/>Suma kwot z poz. od 21 do 36.</td>
				<td align="left" valign="top" width="331">
					<b>37.</b>
					<div align="right" class="cz18" valign="top">
						<b>
							<xsl:value-of select="format-number(number(.//@totalExciseDuties),'# ##0')"/>
							<span align="right" class="cz9" valign="bottom">zł</span>
						</b>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON ROZLICZENIE AKC4 -->
	<xsl:template match="*" mode="RozliczeniePodatku">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCFFCC" valign="top">
				<td class="nag1" colspan="3">D. ROZLICZENIE PODATKU AKCYZOWEGO </td>
			</tr>
			<tr align="left" valign="top">
				<td bgcolor="#CCFFCC" rowspan="3" width="40"/>
				<td bgcolor="#CCFFCC" width="562">
					<b>Kwota stanowiąca wartość podatkowych znaków akcyzy</b>
					<br/>Suma kwot z poz. 15 formularza/formularzy AKC-4/A, AKC-4/B, AKC-4/F oraz z poz. 14 formularza/formularzy AKC-4/M, AKC-4/N, AKC-4/O, AKC-4/P i AKC-4/R</td>
				<td width="331">
					<b>38.</b>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select=".//@totalAmountOfExciseStamps"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td bgcolor="#CCFFCC">
					<b>Wpłaty dzienne</b>
					<br/>Suma kwot z poz. 176 formularza AKC-4/A, AKC-4/B, AKC-4/F, z poz. 175 formularza AKC-4/C, AKC-4/D, AKC-4/I, AKC-4/J, AKC-4/M, AKC-4/N, AKC-4/O, AKC-4/P i AKC-4/R oraz z poz. 174 formularza AKC-4/K.</td>
				<td>
					<b>39.</b>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select=".//@totalAmountOfPaymentsDaily"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td bgcolor="#CCFFCC">
					<b>Dokonana przedpłata podatku akcyzowego</b>
					<br/>Suma kwot z poz. 23 deklaracji AKC-PA (A), AKC-PA (B), AKC-PA (C), AKC-PA (D), AKC-PA (F), AKC-PA (I), AKC-PA (J), AKC-PA (K), AKC-PA (M), AKC-PA (N), AKC-PA (O), AKC-PA (P) i AKC-PA (R) złożonej/złożonych za miesiąc, którego niniejsza deklaracja dotyczy. </td>
				<td>
					<b>40.</b>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select=".//@totalAmountOfPrePayment"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLONPODATEK DO ZAPŁATY AKC4-->
	<xsl:template match="*" mode="PodatekDoZaplaty">
		<table border="1" width="955">
			<tr bgcolor="#CCFFCC">
				<td class="nag1" colspan="3"> E. WYSOKOŚĆ PODATKU AKCYZOWEGO PRZYPADAJĄCEGO DO ZAPŁATY </td>
			</tr>
			<tr align="left" valign="top">
				<td bgcolor="#CCFFCC" rowspan="5" width="42"/>
				<td bgcolor="#CCFFCC" width="562">
					<b>Nadwyżka wpłat do rozliczenia z poprzedniej deklaracji </b>
					<br/>
				</td>
				<td width="331">
					<b>41.</b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select=".//@amountOfSurpPrevDecl"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td align="right" bgcolor="#CCFFCC">
					<b>w tym nadwyżka przedpłaty</b>
				</td>
				<td>
					<b>42.</b>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select=".//@surplusOfAdvanPaymExcise"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td bgcolor="#CCFFCC">
					<b>Podatek do zapłaty</b>
					<br/>Od kwoty z poz. 37 należy odjąć sumę kwot z poz. 38, 39, 40 i 41. Jeżeli różnica jest liczbą ujemną, należy wpisać 0.</td>
				<td>
					<b>43.</b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select=".//@toPay"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td bgcolor="#CCFFCC">
					<b>Nadwyżka wpłat do rozliczenia</b>
					<br/>Od sumy kwot z poz. 38, 39, 40 i 41 należy odjąć kwotę z poz. 37. Jeżeli różnica jest liczbą ujemną, należy wpisać 0.</td>
				<td>
					<b>44.</b>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select=".//@excessContributSettlement"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td align="right" bgcolor="#CCFFCC">
					<b> w tym nadwyżka przedpłaty</b>
				</td>
				<td>
					<b>45.</b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select=".//@excessContributSurplusPaymExcise"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--SZABLON DOT. INFORMACJI O ZALACZNIKACH -->
	<xsl:template match="*" mode="InfZal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCFFCC" valign="top">
				<td colspan="15" height="62">
					<span class="nag1">F. INFORMACJA O ZAŁĄCZNIKACH</span>
					<br/> W każdej z poniższych pozycji należy podać liczbę dołączonych formularzy o podanym symbolu. </td>
			</tr>
			<tr align="left" valign="top">
				<td bgcolor="#CCFFCC" height="51" width="38"/>
				<td>
					<b>46.</b>
					<br/>AKC-4/A <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4a:AKC4A)"/>
						</b>
					</div>
				</td>
				<td>
					<b>47.</b>
					<br/>AKC-4/B <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4b:AKC4B)"/>
						</b>
					</div>
				</td>
				<td>
					<b>48.</b>
					<br/>AKC-4/C <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4c:AKC4C)"/>
						</b>
					</div>
				</td>
				<td>
					<b>49.</b>
					<br/>AKC-4/D<br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4d:AKC4D)"/>
						</b>
					</div>
				</td>
				<td>
					<b>50.</b>
					<br/>AKC-4/E <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4e:AKC4E)"/>
						</b>
					</div>
				</td>
				<td>
					<b>51.</b>
					<br/>AKC-4/F <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4f:AKC4F)"/>
						</b>
					</div>
				</td>
				<td>
					<b>52.</b>
					<br/>AKC-4/H <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4h:AKC4H)"/>
						</b>
					</div>
				</td>
				<td>
					<b>53.</b>
					<br/>AKC-4/I <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4i:AKC4I)"/>
						</b>
					</div>
				</td>
				<td bgcolor="#CCFFCC" height="51" width="38"/>
			</tr>
			<tr>
				<td bgcolor="#CCFFCC" height="51" width="38"/>
				<td>
					<b>54.</b>
					<br/>AKC-4/J <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4j:AKC4J)"/>
						</b>
					</div>
				</td>
				<td>
					<b>55.</b>
					<br/>AKC-4/K <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4k:AKC4K)"/>
						</b>
					</div>
				</td>
				<td>
					<b>56.</b>
					<br/>AKC-4/L <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4l:AKC4L)"/>
						</b>
					</div>
				</td>
				<td>
					<b>57.</b>
					<br/>AKC-4/M <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4m:AKC4M)"/>
						</b>
					</div>
				</td>
				<td>
					<b>58.</b>
					<br/>AKC-4/N <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4n:AKC4N)"/>
						</b>
					</div>
				</td>
				<td>
					<b>59.</b>
					<br/>AKC-4/O <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4o:AKC4O)"/>
						</b>
					</div>
				</td>
				<td>
					<b>60.</b>
					<br/>AKC-4/P <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4p:AKC4P)"/>
						</b>
					</div>
				</td>
				<td>
					<b>61.</b>
					<br/>AKC-4/R <br/>
					<div align="center">
						<b>
							<xsl:value-of select="count(.//akc4r:AKC4R)"/>
						</b>
					</div>
				</td>
				<td bgcolor="#CCFFCC" width="34"/>
			</tr>
		</table>
	</xsl:template>
	<!--SZABLON DOT. NUMEROW AKCYZOWYCH -->
	<xsl:template match="*" mode="NumeryAkc">
		<table border="1" width="955">
			<tr bgcolor="#CCFFCC">
				<td colspan="3">
					<span class="nag1">G. NUMERY AKCYZOWE </span>
				</td>
			</tr>
			<tr align="center" bgcolor="#CCFFCC" valign="middle">
				<td width="335">
					<b>Numer akcyzowy składu podatkowego/numer akcyzowy zarejestrowanego odbiorcy (wypełnia podatnik prowadzący skład podatkowy/zarejestrowany odbiorca) </b>
				</td>
				<td width="310">
					<b>Numer akcyzowy składu podatkowego(wypełnia podatnik będący właścicielem wyrobów akcyzowych, korzystający z cudzego składu) </b>
				</td>
				<td width="288">
					<b>Symbol formularza szczegółowego, w którym numer akcyzowy został wykazany (np. AKC-4/A) </b>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCFFCC">
					<div align="center">a </div>
				</td>
				<td bgcolor="#CCFFCC">
					<div align="center">b </div>
				</td>
				<td bgcolor="#CCFFCC">
					<div align="center"/>
				</td>
			</tr>
			<xsl:for-each select=".//akc4a:Warehouse | .//akc4b:Warehouse | .//akc4c:Warehouse | .//akc4c:Warehouse | .//akc4d:Warehouse |.//akc4e:Warehouse | .//akc4f:Warehouse | .//akc4h:Warehouse | .//akc4i:Warehouse | .//akc4j:Warehouse | .//akc4k:Warehouse | .//akc4l:Warehouse">
				<tr>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select=".//@operatorNo"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select=".//@userNo"/>
						</div>
					</td>
					<td>
						<div align="left" class="cz18" valign="top">
							<xsl:value-of select="//akc4:Header/@formKind"/> / <xsl:value-of select="substring-after(name(../..), ':')"/>
						</div>
					</td>
				</tr>
			</xsl:for-each>
			<tr align="left" valign="top">
				<td>
					<b>92. Ilość składów podatkowych/miejsc odbioru wymienionych w kolumnie a</b>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="count(.//@operatorNo)"/>
					</div>
				</td>
				<td>
					<b>138. Ilość składów podatkowych wymienionych w kolumnie b</b>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="count(.//@userNo)"/>
					</div>
				</td>
				<td>-</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ -->
	<xsl:template match="*" mode="OswPodatnika">
		<xsl:if test="akc4:* | tp13:*">
			<table border="1" height="210" width="955">
				<tr align="left" bgcolor="#CCFFCC" valign="top">
					<td colspan="3">
						<b>
							<span class="nag1">G. PODPIS PODATNIKA LUB OSOBY REPREZENTUJĄCEJ PODATNIKA</span>
						</b>
						<!--<br/>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistością.-->
					</td>
				</tr>
				<tr align="left" valign="top">
					<td bgcolor="#CCFFCC" rowspan="4" width="40"/>
					<td height="37" width="402">
						<b>62. Imię </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@repFirstName"/>
						</span>
					</td>
					<td width="491">
						<b>63. Nazwisko </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@repSurname "/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td colspan="2">
						<b>64. Podpis podatnika lub osoby reprezentującej podatnika </b>
						<span class="cz18">
							<br/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td height="39">
						<!--<xsl:choose> <xsl:when test="string-length(//@repIdentifier)='11'"> <b>126. <s>Identyfikator podatkowy NIP</s>/numer PESEL</b> <sup>(niepotrzebne skreślić)</sup> <b> osoby składającej podpis</b> <sup>10)</sup> </xsl:when> <xsl:otherwise> <b>57. Identyfikator podatkowy NIP/<s>numer PESEL</s> </b> <sup>(niepotrzebne skreślić)</sup> <b> osoby składającej podpis</b> <sup>10)</sup> </xsl:otherwise> </xsl:choose> -->
						<xsl:choose>
							<xsl:when test="string-length(//@repIdentifier)=10">
								<b>65. Identyfikator podatkowy NIP/<s>numer PESEL</s>
								</b>
								<sup>(niepotrzebne skreślić)</sup>
								<b> osoby składającej podpis</b>
								<sup>1)</sup>
							</xsl:when>
							<xsl:otherwise>
								<b> 65.<s>Identyfikator podatkowy NIP</s>/numer PESEL </b>
								<sup>(niepotrzebne skreślić)</sup>
								<b> osoby składającej podpis</b>
								<sup>1)</sup>
							</xsl:otherwise>
						</xsl:choose>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@repIdentifier"/>
						</span>
					</td>
					<td>
						<b>66. Data wypełnienia deklaracji</b> (dzień – miesiąc – rok) <br/>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="substring(//@declarationDate,9,2)"/>
							<xsl:value-of select="substring(//@declarationDate,5,4)"/>
							<xsl:value-of select="substring(//@declarationDate,1,4)"/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td colspan="3">
						<b>67. Numer telefonu i adres e-mail podatnika lub osoby reprezentującej podatnika</b> (pozycja nieobowiązkowa) <br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="akc4:Statement/tp13:representative/@phone"/>
						</span>
						<span class="cz18">
							<xsl:value-of select="akc4:Statement/tp13:representative/@email"/>
						</span>
					</td>
				</tr>
			</table>
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/AKC-4zo<sub style="cz9">(10)</sub>
						</span>
						<!--<span class="nag1"/> <span class="nag1">2</span> <b style="nag1">/2</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. ADNOTACJI-->
	<xsl:template match="*" mode="Adnotacje">
		<xsl:if test="akc4:*">
			<!-- ZNAK KONCA STRONY DO WYDRUKU -->
			<div style="page-break-before: always"/>
			<table border="1" height="167" width="955">
				<tr bgcolor="#CCFFCC">
					<td colspan="3" height="36">
						<span class="nag1">H. ADNOTACJE URZĘDU SKARBOWEGO <sup>7)</sup>
						</span>
					</td>
				</tr>
				<tr align="left" bgcolor="#CCFFCC" valign="top">
					<td rowspan="2" width="40"/>
					<td colspan="2" height="72">
						<b>68. Uwagi urzędu skarbowego <br/>
							<br/>
							<br/>
							<br/>
							<br/>
							<br/>
							<br/>
						</b>
					</td>
				</tr>
				<tr align="left" bgcolor="#CCFFCC" valign="top">
					<td height="49" width="472">
						<b>69. Identyfikator przyjmującego formularz <br/>
							<br/>
							<br/>
						</b>
						<p/>
					</td>
					<td width="421">
						<b>70. Podpis przyjmującego formularz </b>
					</td>
				</tr>
			</table>
			<!--<table width="955"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"> AKC-4/AKC-4zo<sub style="cz9">(8)</sub> </span> <span class="nag1"/> <span class="nag1">2</span> <b style="nag1">/2</b> </td> </tr> </table> -->
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA-->
	<xsl:template match="*" mode="ObjaśnienieAkc">
		<xsl:if test="akc4:*">
			<table width="955">
				<tr>
					<td>
						<p align="center">
							<b>Objaśnienia</b>
							<b/>
						</p>
						<p>
							<sup>1)</sup>Numer PESEL należy podać w przypadku osób fizycznych niebędących zarejestrowanymi podatnikami podatku od towarów i usług lub nieprowadzących działalności gospodarczej.<br/>
							<sup>2)</sup>Jeżeli deklaracja jest składana przez zarejestrowanego odbiorcę w związku z nabyciem wewnątrzwspólnotowym wyrobów akcyzowych, należy przekreślić wyrazy AKC-4; w pozostałych przypadkach należy przekreślić wyrazy AKC-4zo.<br/>
							<sup>3)</sup>Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2025 r. poz. 111, z późn. zm.).<br/>
							<sup>4)</sup>Należy zaznaczyć w przypadku gdy podatnik razem z korektą deklaracji wnioskuje o stwierdzenie nadpłaty powstałej w jej wyniku zgodnie z art. 75 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa. Korektę deklaracji zawierającą wniosek o stwierdzenie nadpłaty podpisuje podatnik lub pełnomocnik posiadający pełnomocnictwo ogólne lub szczególne uprawniające do złożenia wniosku o stwierdzenie nadpłaty.  <br/>
							<sup>5)</sup>Dotyczy podatników niebędących osobami fizycznymi.<br/>
							<sup>6)</sup>Dotyczy podatników będących osobami fizycznymi.<br/>
							<sup>7)</sup>Część H nie jest wypełniana w przypadku otrzymania przez urząd skarbowy deklaracji w postaci elektronicznej.<br/>
							<br/>   W deklaracji AKC-4/AKC-4zo oraz w formularzach stanowiących załączniki do deklaracji AKC-4/AKC-4zo podstawy opodatkowania (wyrażone kwotowo) i kwoty podatków zaokrągla się do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych – zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r.– Ordynacja podatkowa. </p>
						<p align="center">
							<b>Pouczenia</b>
						</p>
						<p>W przypadku niewpłacenia w obowiązującym terminie podatku z poz. 43 lub wpłacenia go w niepełnej wysokości niniejsza  deklaracja  stanowi podstawę  do  wystawienia  tytułu   wykonawczego   zgodnie   z  przepisami  ustawy  z  dnia   17   czerwca   1966   r.   o postępowaniu   egzekucyjnym w administracji (Dz. U. z 2024 r. poz. 132, z późn. zm.).</p>
						<p>Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym.</p>
					</td>
				</tr>
			</table>
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1">AKC-4/AKC4-zo<sub style="cz9">(10)</sub>
						</span>
						<!--<span class="nag1">3</span> <b style="nag1">/3</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. OKRESU ROK MIESIAC I NUMERU ZALACZNIKA DLA ZALACZNIKOW-->
	<xsl:template match="*" mode="rok_mc_zal">
		<xsl:if test="akc4a:*|akc4b:*|akc4c:*|akc4d:*|akc4e:*|akc4f:* |akc4h:*|akc4i:*|akc4j:*|akc4k:*|akc4l:*| akc4m:* |akc4n:*">
			<table border="1" width="955">
				<tr>
					<td valign="top" width="135">
						<b>2. Miesiąc </b>
						<br/>
						<div align="center" class="cz18">
							<xsl:value-of select="substring(//@period,6,7)"/>
						</div>
					</td>
					<td align="left" valign="top" width="135">
						<b>3. Rok </b>
						<br/>
						<div align="center" class="cz18">
							<xsl:value-of select="substring(//@period,1,4)"/>
						</div>
					</td>
					<td width="206"/>
					<xsl:if test="akc4a:*|akc4b:*|akc4c:*|akc4d:*|akc4e:*|akc4f:* |akc4h:*|akc4i:*|akc4j:*|akc4k:*|akc4l:*| akc4m:* |akc4n:*">
						<td align="left" valign="top" width="206">
							<b>Numer formularza</b>
							<br/>
							<div align="center" class="cz18">
								<xsl:value-of select=".//@formNo"/>
							</div>
						</td>
					</xsl:if>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLONY  INNE -->
	<xsl:template match="*" mode="linika">
		<table border="1" width="955">
			<tr bgcolor="#CCCCCC">
				<td>
					<b>Załącznik do deklaracji AKC-4 lub AKC-4zo.</b>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="akc4h:* | akc4l:*" mode="linika">
		<table border="1" width="955">
			<tr bgcolor="#CCCCCC">
				<td>
					<b>Załącznik do deklaracji AKC-4.</b>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="akc4k:* | akc4m:* | akc4n:* | akc4e:* | akc4o:* | akc4p:* |  akc4r:*" mode="linika">
		<table border="1" width="955">
			<tr bgcolor="#CCCCCC">
				<td>
					<b>Załącznik do deklaracji AKC-4.</b>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. DANE PODATNIKA DLA ZALACZNIKÓW AKC4 -->
	<xsl:template match="*" mode="DanePodatnika_Zal">
		<table border="1" width="955">
			<tr bgcolor="#CCCCCC">
				<td colspan="4">
					<span class="nag1">A. DANE IDENTYFIKACYJNE PODATNIKA </span>
					<br/>
					<sup>1)</sup>dotyczy podatników niebędących osobami fizycznymi <sup>2)</sup> dotyczy podatników będących osobami fizycznymi </td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="left" colspan="3" height="27" valign="top">
					<b>4. Rodzaj podatnika </b>(zaznaczyć właściwy kwadrat): </td>
			</tr>
			<tr>
				<xsl:if test="//tr13:TaxpayerData">
					<td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/>
						<span class="cz18"> ☑ </span>
					</td>
					<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
						<span class="cz18"> ☐ </span>
					</td>
				</xsl:if>
				<xsl:if test="//tr13:PrivatePerson">
					<td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/>
						<span class="cz18"> ☐ </span>
					</td>
					<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
						<span class="cz18"> ☑ </span>
						<br/>
					</td>
				</xsl:if>
				<!--	<td align="left" valign="top">1. podatnik niebędący osobą fizyczną <xsl:for-each select="//tr13:TaxpayerData"> <br/> <span class="cz18"> <b>&#9745;</b> </span> </xsl:for-each> </td> <td align="left" valign="top" width="425">2. osoba fizyczna <xsl:for-each select="//tr13:PrivatePerson"> <br/> <span class="cz18"> <b>&#9745;</b> </span> </xsl:for-each> </td> -->
			</tr>
			<tr>
				<td align="left" colspan="3" valign="top">
					<b>5. Nazwa pełna <sup>1)</sup>/Nazwisko, pierwsze imię<sup>2)</sup>
					</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select="//@fullName"/>
					</span>
					<span class="cz18">
						<xsl:value-of select=".//tr13:PrivatePerson/tr13:BasicData/@surname"/>
					</span>
					<span class="cz18">
						<xsl:value-of select=".//tr13:PrivatePerson/tr13:BasicData/@firstName"/>
					</span>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. DANE PODATNIKA DLA ZALACZNIKÓW AKC4 -->
	<xsl:template match="akc4h:*" mode="DanePodatnika_Zal">
		<table border="1" width="955">
			<tr bgcolor="#CCCCCC">
				<td colspan="4">
					<span class="nag1">A. DANE IDENTYFIKACYJNE PODATNIKA </span>
					<br/>
					<!-- <sup>1)</sup>dotyczy podatników niebędących osobami fizycznymi <sup>2)</sup> dotyczy podatników będących osobami fizycznymi -->
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="left" colspan="3" height="27" valign="top">
					<b>4. Rodzaj podatnika (zaznaczyć właściwy kwadrat): </b>
				</td>
			</tr>
			<tr>
				<td align="left" valign="top">1. podatnik niebędący osobą fizyczną <xsl:for-each select="//tr13:TaxpayerData">
						<br/>
						<span class="cz18">
							<b>☑</b>
						</span>
					</xsl:for-each>
				</td>
				<td align="left" valign="top" width="425">2. osoba fizyczna <xsl:for-each select="//tr13:PrivatePerson">
						<br/>
						<span class="cz18">
							<b>☑</b>
						</span>
					</xsl:for-each>
				</td>
			</tr>
			<tr>
				<td align="left" colspan="3" valign="top">
					<b>5. Nazwa pełna <sup>1)</sup>/Nazwisko, pierwsze imię<sup>2)</sup>
					</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select="//@fullName"/>
					</span>
					<span class="cz18">
						<xsl:value-of select=".//tr13:PrivatePerson/tr13:BasicData/@surname"/>
					</span>
					<span class="cz18">
						<xsl:value-of select=".//tr13:PrivatePerson/tr13:BasicData/@firstName"/>
					</span>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. DANE O SKLADZIE PODATKOWYM - CZESC B ZALACZNIKA -->
	<xsl:template match="*" mode="DaneSklad_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">
						<b>B. DANE O SKŁADZIE PODATKOWYM I O ZAREJESTROWANYM ODBIORCY</b>
					</span>
				</td>
			</tr>
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="cz18" colspan="3"> B.1. NUMER AKCYZOWY I ADRES SKŁADU PODATKOWEGO </td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="center" valign="top" width="443">
					<b> Numer akcyzowy składu  <br/> (poz. 6 wypełnia podatnik prowadzący skład) </b>
				</td>
				<td align="center" valign="top" width="450">
					<b> Numer akcyzowy składu <br/> (poz. 7 wypełnia podatnik będący właścicielem wyrobów akcyzowych, korzystający z cudzego składu) </b>
				</td>
			</tr>
			<tr>
				<td align="left" valign="top">
					<b>6.</b>
					<br/>
					<br/>
					<div align="center" class="nag2">
						<xsl:value-of select=".//@operatorNo"/>
					</div>
				</td>
				<td align="left" valign="top">
					<b>7.</b>
					<br/>
					<br/>
					<div align="center" class="nag2">
						<xsl:value-of select=".//@userNo"/>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" colspan="2" valign="top">
					<b>8. Adres składu  </b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@address"/>
					</span>
				</td>
			</tr>
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag2" colspan="3"> B.2. NUMER AKCYZOWY ZAREJESTROWANEGO ODBIORCY </td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC"/>
				<td align="left" colspan="2" valign="top">
					<b>9. Numer akcyzowy zarejestrowanego odbiorcy </b> (wypełnić w przypadku, gdy niniejszy formularz stanowi załącznik do formularza głównego AKC-4zo) <br/>
					<br/>
					<div class="nag2">
						<xsl:value-of select=".//@consumerNo"/>
					</div>
					<br/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. DANE O SKLADZIE PODATKOWYM - CZESC B ZALACZNIKA AKC4K-->
	<xsl:template match="akc4k:*" mode="DaneSklad_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">
						<b>B. DANE O SKŁADZIE PODATKOWYM</b>
					</span>
				</td>
			</tr>
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<!--	<td class="cz18" colspan="3"> B.1. NUMER AKCYZOWY I ADRES SKŁADU PODATKOWEGO </td> -->
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="center" valign="top" width="443">
					<b> Numer akcyzowy składu  <br/> (pole 6 wypełnia podatnik prowadzący skład) </b>
				</td>
				<td align="center" valign="top" width="450">
					<b> Numer akcyzowy składu <br/> (pole 7 wypełnia podatnik będący właścicielem wyrobów akcyzowych, korzystający z cudzego składu) </b>
				</td>
			</tr>
			<tr>
				<td align="left" valign="top">
					<b>6.</b>
					<br/>
					<br/>
					<div align="center" class="nag2">
						<xsl:value-of select=".//@operatorNo"/>
					</div>
				</td>
				<td align="left" valign="top">
					<b>7.</b>
					<br/>
					<br/>
					<div align="center" class="nag2">
						<xsl:value-of select=".//@userNo"/>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" colspan="2" valign="top">
					<b>8. Adres składu  </b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@address"/>
					</span>
				</td>
			</tr>
			<!-- <tr align="left" bgcolor="#CCCCCC" valign="top"> <td class="nag2" colspan="3"> B.2. NUMER AKCYZOWY ZAREJESTROWANEGO ODBIORCY </td> </tr> <tr> <td bgcolor="#CCCCCC"/> <td align="left" colspan="2" valign="top"> <b>10. Numer akcyzowy zarejestrowanego odbiorcy </b> (wypełnić w przypadku, gdy niniejszy formularz stanowi załącznik do formularza głównego AKC-4zo) <br/> <br/> <div class="nag2">dudududud <xsl:value-of select=".//@consumerNo"/> </div> <br/> </td> </tr> -->
		</table>
	</xsl:template>
	<!-- SZABLON DOT. DANE O SKLADZIE PODATKOWYM - CZESC B ZALACZNIKA AKC4O-->
	<xsl:template match="akc4o:* | akc4p:* | akc4r:*" mode="DaneSklad_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">
						<b>B. DANE O SKŁADZIE PODATKOWYM</b>
					</span>
				</td>
			</tr>
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<!--	<td class="cz18" colspan="3"> B.1. NUMER AKCYZOWY I ADRES SKŁADU PODATKOWEGO </td> -->
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="center" valign="top" width="443">
					<b> Numer akcyzowy składu  <br/> (pole 6 wypełnia podatnik prowadzący skład) </b>
				</td>
				<td align="center" valign="top" width="450">
					<b> Numer akcyzowy składu <br/> (pole 7 wypełnia podatnik będący właścicielem wyrobów akcyzowych, korzystający z cudzego składu) </b>
				</td>
			</tr>
			<tr>
				<td align="left" valign="top">
					<b>6.</b>
					<br/>
					<br/>
					<div align="center" class="nag2">
						<xsl:value-of select=".//@operatorNo"/>
					</div>
				</td>
				<td align="left" valign="top">
					<b>7.</b>
					<br/>
					<br/>
					<div align="center" class="nag2">
						<xsl:value-of select=".//@userNo"/>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" colspan="2" valign="top">
					<b>8. Adres składu  </b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@address"/>
					</span>
				</td>
			</tr>
			<!-- <tr align="left" bgcolor="#CCCCCC" valign="top"> <td class="nag2" colspan="3"> B.2. NUMER AKCYZOWY ZAREJESTROWANEGO ODBIORCY </td> </tr> <tr> <td bgcolor="#CCCCCC"/> <td align="left" colspan="2" valign="top"> <b>10. Numer akcyzowy zarejestrowanego odbiorcy </b> (wypełnić w przypadku, gdy niniejszy formularz stanowi załącznik do formularza głównego AKC-4zo) <br/> <br/> <div class="nag2">dudududud <xsl:value-of select=".//@consumerNo"/> </div> <br/> </td> </tr> -->
		</table>
	</xsl:template>
	<!-- SZABLON DOT. DANE O SKLADZIE PODATKOWYM - CZESC B ZALACZNIKA AKC4M-->
	<xsl:template match="akc4m:*" mode="DaneSklad_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">
						<b>B. DANE O SKŁADZIE PODATKOWYM</b>
					</span>
				</td>
			</tr>
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<!-- <td class="cz18" colspan="3"> B.1. NUMER AKCYZOWY I ADRES SKŁADU PODATKOWEGO </td> -->
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="center" valign="top" width="443">
					<b> Numer akcyzowy składu  <br/> (pole 6 wypełnia podatnik prowadzący skład) </b>
				</td>
				<td align="center" valign="top" width="450">
					<b> Numer akcyzowy składu <br/>(pole 7 wypełnia podatnik będący właścicielem wyrobów akcyzowych, korzystający z cudzego składu) </b>
				</td>
			</tr>
			<tr>
				<td align="left" valign="top">
					<b>6.</b>
					<br/>
					<br/>
					<div align="center" class="nag2">
						<xsl:value-of select=".//@operatorNo"/>
					</div>
				</td>
				<td align="left" valign="top">
					<b>7.</b>
					<br/>
					<br/>
					<div align="center" class="nag2">
						<xsl:value-of select=".//@userNo"/>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" colspan="2" valign="top">
					<b>8. Adres składu  </b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@address"/>
					</span>
				</td>
			</tr>
			<!-- <tr align="left" bgcolor="#CCCCCC" valign="top"> <td class="nag2" colspan="3"> B.2. NUMER AKCYZOWY ZAREJESTROWANEGO ODBIORCY </td> </tr> <tr> <td bgcolor="#CCCCCC"/> <td align="left" colspan="2" valign="top"> <b>10. Numer akcyzowy zarejestrowanego odbiorcy </b> (wypełnić w przypadku, gdy niniejszy formularz stanowi załącznik do formularza głównego AKC-4zo) <br/> <br/> <div class="nag2">dudududud <xsl:value-of select=".//@consumerNo"/> </div> <br/> </td> </tr> -->
		</table>
	</xsl:template>
	<!-- SZABLON DOT. DANE O SKLADZIE PODATKOWYM - CZESC B ZALACZNIKA AKC4N-->
	<xsl:template match="akc4n:*" mode="DaneSklad_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">
						<b>B. DANE O SKŁADZIE PODATKOWYM</b>
					</span>
				</td>
			</tr>
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<!-- <td class="cz18" colspan="3"> B.1. NUMER AKCYZOWY I ADRES SKŁADU PODATKOWEGO </td> -->
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="center" valign="top" width="443">
					<b> Numer akcyzowy składu  <br/> (pole 6 wypełnia podatnik prowadzący skład) </b>
				</td>
				<td align="center" valign="top" width="450">
					<b> Numer akcyzowy składu <br/> (pole 7 wypełnia podatnik będący właścicielem wyrobów akcyzowych, korzystający z cudzego składu) </b>
				</td>
			</tr>
			<tr>
				<td align="left" valign="top">
					<b>6.</b>
					<br/>
					<br/>
					<div align="center" class="nag2">
						<xsl:value-of select=".//@operatorNo"/>
					</div>
				</td>
				<td align="left" valign="top">
					<b>7.</b>
					<br/>
					<br/>
					<div align="center" class="nag2">
						<xsl:value-of select=".//@userNo"/>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" colspan="2" valign="top">
					<b>8. Adres składu  </b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@address"/>
					</span>
				</td>
			</tr>
			<!-- <tr align="left" bgcolor="#CCCCCC" valign="top"> <td class="nag2" colspan="3"> B.2. NUMER AKCYZOWY ZAREJESTROWANEGO ODBIORCY </td> </tr> <tr> <td bgcolor="#CCCCCC"/> <td align="left" colspan="2" valign="top"> <b>10. Numer akcyzowy zarejestrowanego odbiorcy </b> (wypełnić w przypadku, gdy niniejszy formularz stanowi załącznik do formularza głównego AKC-4zo) <br/> <br/> <div class="nag2">dudududud <xsl:value-of select=".//@consumerNo"/> </div> <br/> </td> </tr> -->
		</table>
	</xsl:template>
	<!-- SZABLON SKLAD AKCYZOWY -->
	<xsl:template match="*" mode="SkladAkcyza_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b>Razem obliczony podatek</b>
					<br/>
				</td>
				<td align="left" valign="top" width="347">
					<b>11. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Zwolnienia i obniżenia</b>
					<br/> Wykazana kwota nie moze przekroczyć kwoty z poz. 11. </td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Ogółem podatek</b>
					<br/> Od kwoty z poz. 11 należy odjąc kwotę z poz. 12. </td>
				<td align="left" valign="top">
					<b>13. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU - CZESC C ZALACZNIKA -->
	<xsl:template match="*" mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b>Razem obliczony podatek</b>
					<br/>
					<xsl:if test="akc4a:*"> Suma kwot z poz . 260 formularzy AKC-4/A. </xsl:if>
					<xsl:if test="akc4b:*"> Suma kwot z poz . 260 formularzy AKC-4/B. </xsl:if>
					<xsl:if test="akc4c:*"> Suma kwot z poz . 259 formularzy AKC-4/C. </xsl:if>
					<xsl:if test="akc4d:*"> Suma kwot z poz . 241 formularzy AKC-4/D. </xsl:if>
					<xsl:if test="akc4f:*"> Suma kwot z poz . 253 formularzy AKC-4/F. </xsl:if>
					<xsl:if test="akc4i:*"> Suma kwot z poz . 295 formularzy AKC-4/I. </xsl:if>
					<xsl:if test="akc4j:*"> Suma kwot z poz . 277 formularzy AKC-4/J. </xsl:if>
					<xsl:if test="akc4k:*"> Suma kwot z poz . 259 formularzy AKC-4/K. </xsl:if>
					<xsl:if test="akc4m:*"> Suma kwot z poz . 259 formularzy AKC-4/M. </xsl:if>
					<xsl:if test="akc4n:*"> Suma kwot z poz . 252 formularzy AKC-4/N. </xsl:if>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU - CZESC A i B ZALACZNIKA -->
	<xsl:template match="akc4a:* | akc4b:* " mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="5" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b>Razem obliczony podatek</b>
					<br/> Suma kwot z poz. 277 formularzy AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>. </td>
				<td align="left" valign="top" width="347">
					<b>10. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Zwolnienia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>11. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Obniżenia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Razem zwolnienia i obniżenia</b>
					<br/> Suma kwot z poz. 11 i 12 nie może przekroczyć kwoty z poz. 10. </td>
				<td align="left" valign="top">
					<b>13. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Ogółem podatek</b>
					<br/> Od kwoty z poz. 10 należy odjąć kwotę z poz. 13. </td>
				<td align="left" valign="top">
					<b>14. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU - CZESC C ZALACZNIKA -->
	<xsl:template match="akc4c:* | akc4d:* " mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="5" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b>Razem obliczony podatek</b>
					<br/> Suma kwot z poz. 276 formularzy AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>. </td>
				<td align="left" valign="top" width="347">
					<b>10. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Zwolnienia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>11. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Obniżenia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Razem zwolnienia i obniżenia</b>
					<br/> Suma kwot z poz. 11 i 12 nie może przekroczyć kwoty z poz. 10. </td>
				<td align="left" valign="top">
					<b>13. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Ogółem podatek</b>
					<br/> Od kwoty z poz. 10 należy odjąć kwotę z poz. 13. </td>
				<td align="left" valign="top">
					<b>14. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU - CZESC I ZALACZNIKA -->
	<xsl:template match="akc4i:*" mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="5" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b> Razem obliczony podatek</b>
					<br/> Suma kwot z poz. 312 formularzy  <xsl:value-of select="substring-after(name(.), ':')"/>. </td>
				<td align="left" valign="top" width="347">
					<b>10. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Zwolnienia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>11. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Obniżenia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Razem zwolnienia i obniżenia</b>
					<br/> Suma kwot z poz. 11 i 12 nie może przekroczyć kwoty z poz. 10. </td>
				<td align="left" valign="top">
					<b>13. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Ogółem podatek</b>
					<br/> Od kwoty z poz. 10 należy odjąć kwotę z poz. 13. </td>
				<td align="left" valign="top">
					<b>14. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU - CZESC J ZALACZNIKA -->
	<xsl:template match="akc4j:*" mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="5" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b> Razem obliczony podatek</b>
					<br/> Suma kwot z poz. 294 formularzy AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>. </td>
				<td align="left" valign="top" width="347">
					<b>10. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Zwolnienia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>11. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Obniżenia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Razem zwolnienia i obniżenia</b>
					<br/> Suma kwot z poz. 11 i 12 nie może przekroczyć kwoty z poz. 10. </td>
				<td align="left" valign="top">
					<b>13. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Ogółem podatek</b>
					<br/> Od kwoty z poz. 10 należy odjąć kwotę z poz. 13. </td>
				<td align="left" valign="top">
					<b>14. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU - CZESC K ZALACZNIKA -->
	<xsl:template match="akc4k:*" mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="5" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b> Razem obliczony podatek</b>
					<br/> Suma kwot z poz. 275 formularzy AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>. </td>
				<td align="left" valign="top" width="347">
					<b>9. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Zwolnienia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>10. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Obniżenia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>11. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Razem zwolnienia i obniżenia</b>
					<br/> Suma kwot z poz. 10 i 11 nie może przekroczyć kwoty z poz. 9. </td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Ogółem podatek</b>
					<br/> Od kwoty z poz. 9 należy odjąć kwotę z poz. 12. </td>
				<td align="left" valign="top">
					<b>13. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU - CZESC F ZALACZNIKA -->
	<xsl:template match="akc4f:*" mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="5" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b>Razem obliczony podatek</b>
					<br/> Suma kwot z poz. 266 formularzy AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>. </td>
				<td align="left" valign="top" width="347">
					<b>10. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Zwolnienia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>11. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Obniżenia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Razem zwolnienia i obniżenia</b>
					<br/> Suma kwot z poz. 11 i 12 nie może przekroczyć kwoty z poz. 10. </td>
				<td align="left" valign="top">
					<b>13. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Ogółem podatek</b>
					<br/> Od kwoty z poz. 10 należy odjąć kwotę z poz. 13. </td>
				<td align="left" valign="top">
					<b>14. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU - CZESC L ZALACZNIKA -->
	<xsl:template match="akc4l:*" mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> B. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="9" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b>Razem obliczony podatek</b>
					<br/> Kwota z poz. 124 formularza AKC-4/L. </td>
				<td align="left" valign="top" width="347">
					<b>6. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Zwolnienia</b>
					<br/> Suma kwot z poz. od 8 do 11. </td>
				<td align="left" valign="top">
					<b>7. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>     zwolnienie od podatku akcyzowego wyrobów gazowych<br/>      na podstawie art. 31b ust. 1 pkt 3 ustawy</b>
					<sup>3)</sup>
				</td>
				<td align="left" valign="top">
					<b>8. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemptionFromExciseDutyOnGas3),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>     zwolnienie od podatku akcyzowego wyrobów gazowych <br/>      na podstawie art. 31b ust. 1 pkt 3a ustawy</b>
					<sup>3)</sup>
				</td>
				<td align="left" valign="top">
					<b>9. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemptionFromExciseDutyOnGas3a),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>     zwolnienie od podatku akcyzowego wyrobów gazowych<br/>      na podstawie art. 31b ust. 1 pkt 3b ustawy</b>
					<sup>3)</sup>
				</td>
				<td align="left" valign="top">
					<b>10. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemptionFromExciseDutyOnGas3b),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>pozostałe zwolnienia od podatku akcyzowego wyrobów gazowych</b>
				</td>
				<td align="left" valign="top">
					<b>11. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemptionOther),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Obniżenia</b>
				</td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Razem zwolnienia i obniżenia</b>
					<br/> Suma kwot z poz. 7 i 12 nie może przekroczyć kwoty z poz. 6. </td>
				<td align="left" valign="top">
					<b>13. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Ogółem podatek</b>
					<br/> Od kwoty z poz. 6 należy odjąć kwotę z poz. 13. </td>
				<td align="left" valign="top">
					<b>14. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td colspan="3">
					<sup>3)</sup>Dla możliwości stosowania zwolnienia mają zastosowanie warunki określone w art. 163c ustawy.					</td>
			</tr>
		</table>
		<table width="955">
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
						<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
					</span>
					<sub style="cz9">(6)</sub>
					<!-- <b style="nag1">1/1</b> -->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU -   DLA ZALACZNIKA H-->
	<xsl:template match="akc4h:*" mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> B. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="7" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="346">
					<b> Razem obliczony podatek</b>
					<br/> Kwota z poz. 46. </td>
				<td align="left" valign="top" width="347">
					<b>6. </b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Zwolnienia</b>
					<br/> Suma kwot z poz. 20, 24, 28, 32, 36, 40 i 44.</td>
				<td align="left" valign="top">
					<b>7. </b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Obniżenia</b>
					<br/> Suma kwot z poz. 9 i 10.</td>
				<td align="left" valign="top">
					<b>8. </b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="right" bgcolor="#CCCCCC" valign="top">
					<b>obniżenie podatku akcyzowego należnego od energii elektrycznej wynikające z otrzymanego dokumentu potwierdzającego umorzenie świadectwa pochodzenia energii</b> (wynikające ze zwolnienia, o którym mowa w art. 30 ust. 1 ustawy) </td>
				<td align="left" valign="top">
					<b>9.</b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@reductionsFromExciseDutyEnergy_art30_ust1),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="right" bgcolor="#CCCCCC" valign="top">
					<b>pozostałe obniżenia</b>
				</td>
				<td align="left" valign="top">
					<b>10. </b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@reductionOther),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Razem zwolnienia i obniżenia</b>
					<br/> Suma kwot z poz. 7 i 8 nie może być wyższa niż kwota z poz. 6.</td>
				<td align="left" valign="top">
					<b>11. </b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Ogółem podatek</b>
					<br/> Od kwoty z poz. 6 należy odjąć kwotę z poz. 11.</td>
				<td align="left" valign="top">
					<b>12. </b>
					<div align="right" class="cz16" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
		<table width="955">
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
						<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
					</span>
					<sub style="cz9">(10)</sub>
					<!-- <b style="nag1">1/2</b> -->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU -   DLA ZALACZNIKA E-->
	<xsl:template match="akc4e:*" mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">B. WYSOKOŚĆ PODATKU AKCYZOWEGO </span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="9" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="547">
					<b> Razem obliczony podatek</b>
					<br/> Kwota z poz. 153. </td>
				<td align="left" valign="top" width="346">
					<b>6. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfCalcTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Zwolnienia </b>
					<br/> Suma kwot z poz. 8, 9 i 10. <br/>
				</td>
				<td align="left" valign="top">
					<b>7. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="right" bgcolor="#CCCCCC" valign="top">
					<b>zwolnienie   od   podatku   akcyzowego   samochodów    osobowych<br/>  na podstawie art. 109a ust. 1 ustawy</b>
					<br/>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>8. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemptionArt109a),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="right" bgcolor="#CCCCCC" valign="top">
					<b>zwolnienie   od   podatku   akcyzowego   samochodów    osobowych<br/>  na podstawie art. 163a ust. 1 ustawy</b>
					<br/>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>9. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemptionArt163a),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="right" bgcolor="#CCCCCC" valign="top">
					<b>pozostałe zwolnienia od podatku akcyzowego samochodów osobowych</b>
					<br/>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>10. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemptionOther),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Obniżenia</b>
					<br/>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>11. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Razem zwolnienia i obniżenia </b>
					<br/> Suma kwot z poz. 7 i 11 nie może przekroczyć kwoty z poz. 6.  <br/>
				</td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Ogółem podatek </b>
					<br/> Od kwoty z poz. 6 należy odjąć kwotę z poz. 12. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>13. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
		<table width="955">
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
						<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
					</span>
					<sub style="cz9">(9)</sub>
					<!-- <b style="nag1">/1</b> -->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU - CZESC M ZALACZNIKA -->
	<xsl:template match="akc4m:*" mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="5" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b>Razem obliczony podatek</b>
					<br/> Suma kwot z poz. 276 formularzy AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>. </td>
				<td align="left" valign="top" width="347">
					<b>9. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Zwolnienia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>10. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Obniżenia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>11. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Razem zwolnienia i obniżenia</b>
					<br/> Suma kwot z poz. 10 i 11 nie może przekroczyć kwoty z poz. 9. </td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Ogółem podatek</b>
					<br/> Od kwoty z poz. 9 należy odjąć kwotę z poz. 12. </td>
				<td align="left" valign="top">
					<b>13. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU - CZESC N ZALACZNIKA -->
	<xsl:template match="akc4n:*" mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="5" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b>Razem obliczony podatek</b>
					<br/> Suma kwot z poz. 265 formularzy AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>. </td>
				<td align="left" valign="top" width="347">
					<b>9. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Zwolnienia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>10. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Obniżenia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>11. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Razem zwolnienia i obniżenia</b>
					<br/> Suma kwot z poz. 10 i 11 nie może przekroczyć kwoty z poz. 9. </td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Ogółem podatek</b>
					<br/> Od kwoty z poz. 9 należy odjąć kwotę z poz. 12. </td>
				<td align="left" valign="top">
					<b>13. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU - CZESC O ZALACZNIKA -->
	<xsl:template match="akc4o:*" mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="5" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b> Razem obliczony podatek</b>
					<br/> Suma kwot z poz. 267 formularzy AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>. </td>
				<td align="left" valign="top" width="347">
					<b>9. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Zwolnienia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>10. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Obniżenia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>11. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Razem zwolnienia i obniżenia</b>
					<br/> Suma kwot z poz. 10 i 11 nie może przekroczyć kwoty z poz. 9. </td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Ogółem podatek</b>
					<br/> Od kwoty z poz. 9 należy odjąć kwotę z poz. 12. </td>
				<td align="left" valign="top">
					<b>13. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU - CZESC P ZALACZNIKA -->
	<xsl:template match="akc4p:*" mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="5" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b> Razem obliczony podatek</b>
					<br/> Suma kwot z poz. 267 formularzy AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>. </td>
				<td align="left" valign="top" width="347">
					<b>9. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Zwolnienia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>10. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Obniżenia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>11. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Razem zwolnienia i obniżenia</b>
					<br/> Suma kwot z poz. 10 i 11 nie może przekroczyć kwoty z poz. 9. </td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Ogółem podatek</b>
					<br/> Od kwoty z poz. 9 należy odjąć kwotę z poz. 12. </td>
				<td align="left" valign="top">
					<b>13. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBLICZENIE KWOTY PODATKU - CZESC R ZALACZNIKA -->
	<xsl:template match="akc4r:*" mode="KwotaPodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="3"> C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="5" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b> Razem obliczony podatek</b>
					<br/> Suma kwot z poz. 267 formularzy AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>. </td>
				<td align="left" valign="top" width="347">
					<b>9. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Zwolnienia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>10. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Obniżenia</b>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>11. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Razem zwolnienia i obniżenia</b>
					<br/> Suma kwot z poz. 10 i 11 nie może przekroczyć kwoty z poz. 9. </td>
				<td align="left" valign="top">
					<b>12. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Ogółem podatek</b>
					<br/> Od kwoty z poz. 9 należy odjąć kwotę z poz. 12. </td>
				<td align="left" valign="top">
					<b>13. </b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@totalOfTax),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
	<xsl:template match="*" mode="NowaStrona_Zal">
		<!-- tymczasowo -->
		<!-- ZNAK KONCA STRONY DO WYDRUKU -->
		<div style="page-break-before: always">
			<!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select="." mode = "stopka"/></b></span> </td> </tr> </table> -->
		</div>
	</xsl:template>
	<!-- SZABLON ROZLICZENIE PODATKU AKCYZOWEGO- CZESC D ZALACZNIKA  ZALA, ZALB, ZALF-->
	<xsl:template match="akc4a:* | akc4b:* | akc4f:*" mode="RozliczeniePodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">D. ROZLICZENIE PODATKU AKCYZOWEGO </span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="4" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="547">
					<b> Kwota stanowiąca wartość podatkowych znaków akcyzy </b>
				</td>
				<td align="left" valign="top" width="346">
					<b>15. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfExciseStamps),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Przedpłata podatku akcyzowego  </b>
					<br/>
					<xsl:if test="akc4a:*"> Suma kwot z poz. 22 i 23 deklaracji AKC-PA (A) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. </xsl:if>
					<xsl:if test="akc4b:*"> Suma kwot z poz. 22 i 23 deklaracji AKC-PA (B) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. </xsl:if>
					<xsl:if test="akc4f:*"> Suma kwot z poz. 22 i 23 deklaracji AKC-PA (F) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. </xsl:if>
					<xsl:if test="akc4m:*"> Suma kwot z poz. 22 i 23 deklaracji AKC-PA (M) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. </xsl:if>
					<br/>
				</td>
				<td align="left" valign="top">
					<b>16. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfPrePayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Podatek należny  </b>
					<br/> Od kwoty z poz. 14 należy odjąć sumę kwot z poz. 15 i 16; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>17. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@taxChargeable),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Nadwyżka (Nadwyżka przedpłaty – w przypadku produkcji poza składem podatkowym)	</b>
					<br/> Od sumy kwot z poz. 15 i 16 należy odjąć kwotę z poz. 14; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>18. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@surplusExcessPayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
		<table width="955">
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
						<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
					</span>
					<sub style="cz9">(8)</sub>
					<!-- <b style="nag1">/1</b> -->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON ROZLICZENIE PODATKU AKCYZOWEGO- CZESC D ZALACZNIKA  M-->
	<xsl:template match="akc4m:*" mode="RozliczeniePodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">D. ROZLICZENIE PODATKU AKCYZOWEGO </span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="4" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="547">
					<b> Kwota stanowiąca wartość podatkowych znaków akcyzy </b>
				</td>
				<td align="left" valign="top" width="346">
					<b>14. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfExciseStamps),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Przedpłata podatku akcyzowego  </b>
					<br/>  Suma kwot z pozycji 22 i 23 deklaracji AKC-PA (M) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. <br/>
				</td>
				<td align="left" valign="top">
					<b>15. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfPrePayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Podatek należny  </b>
					<br/> Od kwoty z poz. 13 należy odjąć sumę kwot z poz. 14 i 15; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>16. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@taxChargeable),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Nadwyżka (Nadwyżka przedpłaty – w przypadku produkcji poza składem podatkowym)	</b>
					<br/> Od sumy kwot z poz. 14 i 15 należy odjąć kwotę z poz. 13; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>17. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@surplusExcessPayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
		<table width="955">
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
						<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
					</span>
					<sub style="cz9">(3)</sub>
					<!-- <b style="nag1">/1</b> -->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON ROZLICZENIE PODATKU AKCYZOWEGO- CZESC D ZALACZNIKA Zal N-->
	<xsl:template match="akc4n:*" mode="RozliczeniePodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">D. ROZLICZENIE PODATKU AKCYZOWEGO </span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="4" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="547">
					<b> Kwota stanowiąca wartość podatkowych znaków akcyzy </b>
				</td>
				<td align="left" valign="top" width="346">
					<b>14. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfExciseStamps),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Przedpłata podatku akcyzowego  </b>
					<br/>  Suma kwot z pozycji 22 i 23 deklaracji AKC-PA (N) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. <br/>
				</td>
				<td align="left" valign="top">
					<b>15. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfPrePayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Podatek należny  </b>
					<br/> Od kwoty z poz. 13 należy odjąć sumę kwot z poz. 14 i 15; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>16. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@taxChargeable),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Nadwyżka (Nadwyżka przedpłaty – w przypadku produkcji poza składem podatkowym)	</b>
					<br/> Od sumy kwot z poz. 14 i 15 należy odjąć kwotę z poz. 13; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>17. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@surplusExcessPayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
		<table width="955">
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
						<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
					</span>
					<sub style="cz9">(2)</sub>
					<!-- <b style="nag1">/1</b> -->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON ROZLICZENIE PODATKU AKCYZOWEGO- CZESC D ZALACZNIKA  ZALA, ZALB, ZALF-->
	<xsl:template match="akc4c:* | akc4d:* | akc4j:* " mode="RozliczeniePodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">D. ROZLICZENIE PODATKU AKCYZOWEGO </span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b> Przedpłata podatku akcyzowego </b>
					<br/>
					<xsl:if test="akc4c:*"> Suma kwot z poz. 22 i 23 deklaracji AKC-PA (C) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. </xsl:if>
					<xsl:if test="akc4d:*"> Suma kwot z poz. 22 i 23 deklaracji AKC-PA (D) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. </xsl:if>
					<xsl:if test="akc4j:*"> Suma kwot z poz. 22 i 23 deklaracji AKC-PA (J) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. </xsl:if>
					<xsl:if test="akc4k:*"> Suma kwot z poz. 22 i 23 deklaracji AKC-PA (K) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. </xsl:if>
					<br/>
				</td>
				<td align="left" valign="top" width="347">
					<b>15. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfPrePayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Podatek należny </b>
					<br/> Od kwoty z poz. 14 należy odjąć sumę kwot z poz. 15; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>16. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@taxChargeable),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Nadwyżka przedpłaty</b>
					<br/> Od kwoty z poz. 15 należy odjąć kwotę z poz. 14; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>17. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@surplusExcessPayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
		<xsl:if test="akc4c:* | akc4i:* | akc4j:*">
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(8)</sub>
						<!-- <b style="nag1">/1</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4d:*">
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(9)</sub>
						<!-- <b style="nag1">/1</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON ROZLICZENIE PODATKU AKCYZOWEGO- CZESC D ZALACZNIKA  zal AKC4I -->
	<xsl:template match="akc4i:*" mode="RozliczeniePodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">D. ROZLICZENIE PODATKU AKCYZOWEGO </span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b> Przedpłata podatku akcyzowego </b>
					<br/>
					<xsl:if test="akc4i:*"> Suma kwot z pozycji 22 i 23 deklaracji AKC-PA (I) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. </xsl:if>
					<br/>
				</td>
				<td align="left" valign="top" width="347">
					<b>15. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfPrePayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Podatek należny </b>
					<br/> Od kwoty z poz. 14 należy odjąć sumę kwot z poz. 15; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>16. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@taxChargeable),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b> Nadwyżka przedpłaty</b>
					<br/> Od sumy kwot z poz. 15 należy odjąć kwotę z poz. 14; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>17. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@surplusExcessPayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
		<table width="955">
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
						<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
					</span>
					<sub style="cz9">(8)</sub>
					<!-- <b style="nag1">/1</b> -->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON ROZLICZENIE PODATKU AKCYZOWEGO- CZESC D ZALACZNIKA  AKC4K -->
	<xsl:template match="akc4k:*" mode="RozliczeniePodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">D. ROZLICZENIE PODATKU AKCYZOWEGO </span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="546">
					<b>Przedpłata podatku akcyzowego </b>
					<br/>  Suma kwot z pozycji 22 i 23 deklaracji AKC-PA (K) złożonej za miesiąc, którego niniejsza deklaracja dotyczy.  <br/>
				</td>
				<td align="left" valign="top" width="347">
					<b>14. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfPrePayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Podatek należny </b>
					<br/> Od kwoty z poz. 13 należy odjąć sumę kwot z poz. 14; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>15. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@taxChargeable),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Nadwyżka przedpłaty</b>
					<br/> Od sumy kwot z poz. 14 należy odjąć kwotę z poz. 13; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>16. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@surplusExcessPayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
		<table width="955">
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
						<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
					</span>
					<sub style="cz9">(9)</sub>
					<!-- <b style="nag1">/1</b> -->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON ROZLICZENIE PODATKU AKCYZOWEGO- CZESC D ZALACZNIKA  O-->
	<xsl:template match="akc4o:*" mode="RozliczeniePodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">D. ROZLICZENIE PODATKU AKCYZOWEGO </span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="4" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="547">
					<b> Kwota stanowiąca wartość podatkowych znaków akcyzy </b>
				</td>
				<td align="left" valign="top" width="346">
					<b>14. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfExciseStamps),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Przedpłata podatku akcyzowego  </b>
					<br/>  Suma kwot z pozycji 22 i 23 deklaracji AKC-PA (O) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. <br/>
				</td>
				<td align="left" valign="top">
					<b>15. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfPrePayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Podatek należny  </b>
					<br/> Od kwoty z poz. 13 należy odjąć sumę kwot z poz. 14 i 15; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>16. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@taxChargeable),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Nadwyżka (Nadwyżka przedpłaty – w przypadku produkcji poza składem podatkowym)	</b>
					<br/> Od sumy kwot z poz. 14 i 15 należy odjąć kwotę z poz. 13; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>17. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@surplusExcessPayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
		<table width="955">
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
						<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
					</span>
					<sub style="cz9">(1)</sub>
					<!-- <b style="nag1">/1</b> -->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON ROZLICZENIE PODATKU AKCYZOWEGO- CZESC D ZALACZNIKA  P-->
	<xsl:template match="akc4p:*" mode="RozliczeniePodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">D. ROZLICZENIE PODATKU AKCYZOWEGO </span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="4" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="547">
					<b> Kwota stanowiąca wartość podatkowych znaków akcyzy </b>
				</td>
				<td align="left" valign="top" width="346">
					<b>14. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfExciseStamps),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Przedpłata podatku akcyzowego  </b>
					<br/>  Suma kwot z pozycji 22 i 23 deklaracji AKC-PA (P) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. <br/>
				</td>
				<td align="left" valign="top">
					<b>15. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfPrePayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Podatek należny  </b>
					<br/> Od kwoty z poz. 13 należy odjąć sumę kwot z poz. 14 i 15; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>16. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@taxChargeable),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Nadwyżka (Nadwyżka przedpłaty – w przypadku produkcji poza składem podatkowym)	</b>
					<br/> Od sumy kwot z poz. 14 i 15 należy odjąć kwotę z poz. 13; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>17. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@surplusExcessPayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
		<table width="955">
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
						<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
					</span>
					<sub style="cz9">(1)</sub>
					<!-- <b style="nag1">/1</b> -->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON ROZLICZENIE PODATKU AKCYZOWEGO- CZESC D ZALACZNIKA  R-->
	<xsl:template match="akc4r:*" mode="RozliczeniePodatku_Zal">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="3">
					<span class="nag1">D. ROZLICZENIE PODATKU AKCYZOWEGO </span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="4" width="40"/>
				<td align="left" bgcolor="#CCCCCC" valign="top" width="547">
					<b> Kwota stanowiąca wartość podatkowych znaków akcyzy </b>
				</td>
				<td align="left" valign="top" width="346">
					<b>14. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfExciseStamps),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Przedpłata podatku akcyzowego  </b>
					<br/>  Suma kwot z pozycji 22 i 23 deklaracji AKC-PA (R) złożonej za miesiąc, którego niniejsza deklaracja dotyczy. <br/>
				</td>
				<td align="left" valign="top">
					<b>15. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@amountOfPrePayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Podatek należny  </b>
					<br/> Od kwoty z poz. 13 należy odjąć sumę kwot z poz. 14 i 15; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>16. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@taxChargeable),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" valign="top">
					<b>Nadwyżka (Nadwyżka przedpłaty – w przypadku produkcji poza składem podatkowym)	</b>
					<br/> Od sumy kwot z poz. 14 i 15 należy odjąć kwotę z poz. 13; jeżeli różnica jest liczbą ujemną, należy wpisać 0. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>17. </b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(.//@surplusExcessPayment),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
		<table width="955">
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
						<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
					</span>
					<sub style="cz9">(1)</sub>
					<!-- <b style="nag1">/1</b> -->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON OBJAŚNIENIA WPŁATY-->
	<xsl:template match="*" mode="Objaśnienie_wplaty">
		<xsl:if test="akc4a:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p>Dla każdego składu podatkowego formularz AKC-4/A należy wypełnić oddzielnie, dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla alkoholu etylowego wykazanego we wszystkich składach łącznie). </p>
						<p>Dla każdego miejsca  odbioru  wyrobów  akcyzowych  przez  zarejestrowanego  odbiorcę  formularz  AKC-4/A  należy  wypełnić  oddzielnie,  dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla alkoholu etylowego wykazanego we wszystkich miejscach odbioru łącznie).</p>
						<p>Części B i E formularza nie wypełnia podatnik, który jest zobowiązany do dokonania przedpłaty podatku akcyzowego zgodnie z art. 22 ust. 1 ustawy   z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2020 r. poz. 722, z późn. zm.).</p>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4b:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p>Dla każdego składu podatkowego formularz AKC-4/B należy wypełnić oddzielnie, dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla wina, napojów fermentowanych i wyrobów  pośrednich  wykazanych  we  wszystkich składach łącznie). </p>
						<p>Dla każdego miejsca  odbioru  wyrobów  akcyzowych  przez  zarejestrowanego  odbiorcę  formularz  AKC-4/B  należy  wypełnić  oddzielnie,  dodając w systemie  kolejne  formularze  (część  E  należy  wypełnić  tylko  w  formularzu  dodanym  jako  pierwszy  –  dla  wina,    napojów    fermentowanych i wyrobów pośrednich wykazanych we wszystkich miejscach odbioru łącznie).</p>
						<p>Części B i E formularza nie wypełnia podatnik, który jest zobowiązany do dokonania przedpłaty podatku akcyzowego zgodnie z art. 22 ust. 1 ustawy   z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2020 r. poz. 722, z późn. zm.).</p>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4c:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p>Dla każdego składu podatkowego formularz AKC-4/C należy wypełnić oddzielnie, dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla piwa wykazanego we wszystkich składach łącznie). </p>
						<p>Dla każdego miejsca  odbioru  wyrobów  akcyzowych  przez  zarejestrowanego  odbiorcę  formularz  AKC-4/C  należy  wypełnić  oddzielnie,  dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla piwa  wykazanego  we  wszystkich  miejscach odbioru łącznie). </p>
						<p>Części B i E formularza nie wypełnia podatnik, który jest zobowiązany do dokonania przedpłaty podatku akcyzowego zgodnie z art. 22 ust. 1 ustawy   z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2020 r. poz. 722, z późn. zm.).</p>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4d:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p>Dla każdego składu podatkowego formularz AKC-4/D należy wypełnić oddzielnie, dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla paliwa wykazanego we wszystkich składach łącznie). </p>
						<p>Dla każdego miejsca odbioru wyrobów akcyzowych przez zarejestrowanego odbiorcę formularz AKC-4/D należy wypełnić oddzielnie, dodając   w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla paliwa wykazanego we wszystkich miejscach odbioru łącznie).  </p>
						<p>Części B i E formularza nie wypełnia podatnik, który jest zobowiązany do dokonania przedpłaty podatku akcyzowego zgodnie z art. 22 ust. 1 ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2020 r. poz. 722, z późn. zm.).</p>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4e:*">
			<!-- STOPKA -->
			<!--<table border="1" width="955"> <tr> <td> <p align="center"> <strong>Objaśnienie:</strong> </p> <p>W przypadku złożenia przez podatnika więcej niż jednego formularza AKC-4/E część B wypełnia się tylko w formularzu nr 1 (dla wszystkich formularzy łącznie).</p> </td> </tr> </table> -->
		</xsl:if>
		<xsl:if test="akc4f:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p>Dla każdego składu podatkowego formularz AKC-4/F należy wypełnić oddzielnie, dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla wyrobów tytoniowych wykazanych we wszystkich składach łącznie).  </p>
						<p>Dla każdego miejsca  odbioru  wyrobów  akcyzowych  przez  zarejestrowanego  odbiorcę  formularz  AKC-4/F  należy  wypełnić  oddzielnie,  dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla wyrobów tytoniowych wykazanych we wszystkich miejscach odbioru łącznie).</p>
						<p>Części B i E formularza nie wypełnia podatnik, który jest zobowiązany do dokonania przedpłaty podatku akcyzowego zgodnie z art. 22 ust. 1 ustawy   z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2020 r. poz. 722, z późn. zm.).</p>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4h:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p/>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4i:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p>Dla każdego składu podatkowego formularz AKC-4/I należy wypełnić oddzielnie, dodając w systemie kolejne formularze (część E należy  wypełnić tylko w formularzu dodanym jako pierwszy – dla paliw opałowych wykazanych we wszystkich składach łącznie).</p>
						<p>Dla każdego  miejsca  odbioru  wyrobów  akcyzowych  przez  zarejestrowanego  odbiorcę  formularz  AKC-4/I  należy  wypełnić  oddzielnie,  dodając  w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla paliw opałowych  wykazanych  we  wszystkich miejscach odbioru łącznie).</p>
						<p>Części B i E formularza nie wypełnia podatnik, który jest zobowiązany do dokonania przedpłaty podatku akcyzowego zgodnie z art. 22 ust. 1 ustawy   z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2020 r. poz. 722, z późn. zm.).</p>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4j:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p>Dla każdego składu podatkowego formularz AKC-4/J należy wypełnić oddzielnie, dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla gazu wykazanego we wszystkich składach łącznie).  </p>
						<p>Dla każdego  miejsca  odbioru  wyrobów  akcyzowych  przez  zarejestrowanego  odbiorcę  formularz  AKC-4/J  należy  wypełnić  oddzielnie,  dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla  gazu  wykazanego  we  wszystkich miejscach odbioru łącznie).  </p>
						<p>Składając deklarację za pomocą środków komunikacji elektronicznej dla wyrobów gazowych przeznaczonych do napędu silników spalinowych, dla których nie stosuje się procedury zawieszenia poboru akcyzy, w systemie wypełnia się oddzielny formularz AKC-4/J. W tym przypadku części B i E formularza nie wypełnia się.</p>
						<p>Części B i E formularza nie wypełnia podatnik, który jest zobowiązany do dokonania przedpłaty podatku akcyzowego zgodnie z art. 22 ust. 1 ustawy   z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2020 r. poz. 722, z późn. zm.).</p>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4k:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p>Dla każdego składu podatkowego formularz AKC-4/K należy wypełnić oddzielnie, dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla preparatów smarowych, olejów smarowych i pozostałych olejów wykazanych we  wszystkich  składach łącznie).  </p>
						<p>Części B i E formularza nie wypełnia podatnik, który jest zobowiązany do dokonania przedpłaty podatku akcyzowego zgodnie z art. 22 ust. 1 ustawy   z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2020 r. poz. 722, z późn. zm.).</p>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4m:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p>Dla każdego składu podatkowego formularz AKC-4/M należy wypełnić oddzielnie, dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla płynu do papierosów elektronicznych wykazanych we wszystkich składach łącznie). </p>
						<p>Części B i E formularza nie wypełnia podatnik, który jest zobowiązany do dokonania przedpłaty podatku akcyzowego zgodnie z art. 22 ust. 1 ustawy   z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2025 r. poz. 126, z późn. zm.).  </p>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4o:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p>Dla każdego składu podatkowego formularz AKC-4/O należy wypełnić oddzielnie, dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla płynu do papierosów elektronicznych wykazanych we wszystkich składach łącznie). </p>
						<p>Części B i E formularza nie wypełnia podatnik, który jest zobowiązany do dokonania przedpłaty podatku akcyzowego zgodnie z art. 22 ust. 1 ustawy   z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2025 r. poz. 126, z późn. zm.).   </p>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4p:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p>Dla każdego składu podatkowego formularz AKC-4/P należy wypełnić oddzielnie, dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla płynu do papierosów elektronicznych wykazanych we wszystkich składach łącznie). </p>
						<p>Części B i E formularza nie wypełnia podatnik, który jest zobowiązany do dokonania przedpłaty podatku akcyzowego zgodnie z art. 22 ust. 1 ustawy   z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2025 r. poz. 126, z późn. zm.).   </p>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4r:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p>Dla każdego składu podatkowego formularz AKC-4/R należy wypełnić oddzielnie, dodając w systemie kolejne formularze (część E należy wypełnić tylko w formularzu dodanym jako pierwszy – dla płynu do papierosów elektronicznych wykazanych we wszystkich składach łącznie). </p>
						<p>Części B i E formularza nie wypełnia podatnik, który jest zobowiązany do dokonania przedpłaty podatku akcyzowego zgodnie z art. 22 ust. 1 ustawy   z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2025 r. poz. 126, z późn. zm.).   </p>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4n:*">
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p align="center">
							<strong>Objaśnienia</strong>
						</p>
						<p>Dla każdego składu podatkowego formularz AKC-4/N należy wypełnić oddzielnie, dodając w systemie kolejne formularze (część E należy wypełnić   tylko w formularzu dodanym jako pierwszy – dla wyrobów nowatorskich wykazanych dla wszystkich składów łącznie). </p>
						<p>Części B i E formularza nie wypełnia podatnik,  który jest  zobowiązany do dokonania przedpłaty podatku  akcyzowego zgodnie z art. 22 ust.  1 ustawy   z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2020 r. poz. 722, z późn. zm.).  </p>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4m:*">
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(3)</sub>
						<!--	<b style="nag1">/2</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4n:*">
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(2)</sub>
						<!--	<b style="nag1">/2</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4a:* | akc4b:*| akc4c:* | akc4f:*| akc4h:* | akc4i:* | akc4j:* | akc4l:*">
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(8)</sub>
						<!-- <b style="nag1">/2</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4k:*">
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(9)</sub>
						<!-- <b style="nag1">/2</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4o:*">
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(1)</sub>
						<!-- <b style="nag1">/2</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4p:*">
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(1)</sub>
						<!-- <b style="nag1">/2</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4r:*">
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(1)</sub>
						<!-- <b style="nag1">/2</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="akc4d:*">
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(9)</sub>
						<!-- <b style="nag1">/2</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!--- SZABLON WYROBY Z ZAŁACZNIKÓW -->
	<xsl:template match="*" mode="Wyroby_Zal">
		<!-- tymczasowo -->
		<!-- ZNAK KONCA STRONY DO WYDRUKU -->
		<div style="page-break-before: always">
			<!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select="../.." mode = "stopka"/></b></span> </td> </tr> </table> -->
		</div>
		<!-- TABELKA DLA ZAL A-->
		<xsl:if test="akc4a:*">
			<!-- TABELKA DLA A -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="7">F. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b> Lp. </b>
					</td>
					<td width="301">
						<b> Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku <sup>3)</sup>
						</b>
					</td>
					<td width="131">
						<p align="center">
							<b>Ośmiocyfrowy kod  CN </b>
						</p>
					</td>
					<td width="183">
						<p align="center">
							<b>Ilość wyrobów w hektolitrach 100% vol. alkoholu etylowego<br/> (z dokładnością do dwóch miejsc po przecinku)</b>
						</p>
					</td>
					<td width="127">
						<b> Stawka podatku </b>
					</td>
					<td width="153">
						<p align="center">
							<b>Podatek akcyzowy</b>
						</p>
					</td>
					<td width="143">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat)</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4a:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select="@groupOfGoodsName"/>
							</div>
							<xsl:apply-templates mode="Ubytki" select="."/>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@numberOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Sprzedaż na eksport </b>
						</td>
						<!-- <td bgcolor="#CCCCCC"/> -->
						<td>
							<b>273.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td>
							<b>274.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportTaxRate"/>
								</b>
							</div>
						</td>
						<td>
							<b>275.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportAmountOfTax"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<td>
							<b>276.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
						<td>
							<b>277.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p>
							<sup>3)</sup>W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia wyrobów, w kolumnie „b”, obok nazwy grupy wyrobów należy wpisać odpowiednio: „ubytki” albo „całkowite zniszczenie”. </p>
					</td>
				</tr>
			</table>
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!--<xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(8)</sub>
						<!-- <b style="nag1">/4</b> -->
					</td>
				</tr>
			</table>
			<!-- KONIEC TABELKI ZAL_A -->
		</xsl:if>
		<!-- TABELKA DLA ZAL B -->
		<xsl:if test="akc4b:*">
			<!-- TABELKA DLA B -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="7">F. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b>Lp.</b>
					</td>
					<td width="301">
						<b>Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku <sup>3)</sup>
						</b>
					</td>
					<td width="131">
						<p align="center">
							<b>Ośmiocyfrowy kod  CN </b>
						</p>
					</td>
					<td width="183">
						<p align="center">
							<b>Ilość wyrobów w hektolitrach<br/> (z dokładnością do dwóch miejsc po przecinku) </b>
						</p>
					</td>
					<td width="127">
						<b> Stawka podatku</b>
					</td>
					<td width="153">
						<p align="center">
							<b>Podatek akcyzowy</b>
						</p>
					</td>
					<td width="143">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat)</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4b:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select="@groupOfGoodsName"/>
							</div>
							<xsl:apply-templates mode="Ubytki" select="."/>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@numberOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Sprzedaż na eksport </b>
						</td>
						<!-- <td bgcolor="#CCCCCC"/> -->
						<td>
							<b>273.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td>
							<b>274.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportTaxRate"/>
								</b>
							</div>
						</td>
						<td>
							<b>275.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportAmountOfTax"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<td>
							<b>276.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
						<td>
							<b>277.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p>
							<sup>3)</sup>W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia wyrobów, w kolumnie „b”, obok nazwy grupy wyrobów należy wpisać odpowiednio: „ubytki” albo „całkowite zniszczenie”. </p>
					</td>
				</tr>
			</table>
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!--<xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(8)</sub>
						<!-- <b style="nag1">/4</b> -->
					</td>
				</tr>
			</table>
			<!-- KONIEC TABELKI ZAL_B -->
		</xsl:if>
		<!-- TABELKA DLA ZAL C -->
		<xsl:if test="akc4c:*">
			<!--TABELKA DLA C -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="7">F. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b> Lp. </b>
					</td>
					<td width="301">
						<b>Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku <sup>3)</sup>
						</b>
					</td>
					<td width="131">
						<p align="center">
							<b>Ośmiocyfrowy kod  CN </b>
						</p>
					</td>
					<td width="183">
						<p align="center">
							<b>Ilość wyrobów w hektolitrach x stopień Plato (% m/m ekstraktu brzeczki podstawowej)<sup>4)</sup>
							</b>
						</p>
					</td>
					<td width="127">
						<b> Stawka podatku </b>
					</td>
					<td width="153">
						<p align="center">
							<b>Podatek akcyzowy</b>
						</p>
					</td>
					<td width="143">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat)</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4c:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select="@groupOfGoodsName"/>
							</div>
							<xsl:apply-templates mode="Ubytki" select="."/>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@numberOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Sprzedaż na eksport </b>
						</td>
						<!-- <td bgcolor="#CCCCCC"/> -->
						<td>
							<b>272.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td>
							<b>273.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportTaxRate"/>
								</b>
							</div>
						</td>
						<td>
							<b>274.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportAmountOfTax"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<td>
							<b>275.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
						<td>
							<b>276.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p>
							<sup>3)</sup>W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia wyrobów, w kolumnie „b”, obok nazwy grupy wyrobów należy wpisać odpowiednio: „ubytki” albo „całkowite zniszczenie”. <br/>
							<sup>4)</sup> Z dokładnością do dwóch miejsc po przecinku.</p>
					</td>
				</tr>
			</table>
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!--<xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(8)</sub>
						<!-- <b style="nag1">/4</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<!-- TABELKA ZAL_D -->
		<xsl:if test="akc4d:*">
			<!-- TABELKA D -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="7">F. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b> Lp.</b>
					</td>
					<td width="301">
						<b> Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku <sup>3)</sup>
						</b>
					</td>
					<td width="131">
						<p align="center">
							<b>Ośmiocyfrowy kod  CN </b>
						</p>
					</td>
					<td width="183">
						<p align="center">
							<b>Ilość wyrobów w tysiącach litrów <br/>(z dokładnością do trzech miejsc po przecinku)</b>
						</p>
					</td>
					<td width="127">
						<b> Stawka podatku</b>
					</td>
					<td width="153">
						<p align="center">
							<b>Podatek akcyzowy</b>
						</p>
					</td>
					<td width="143">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat) </b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4d:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select="@groupOfGoodsName"/>
							</div>
							<xsl:apply-templates mode="Ubytki" select="."/>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@numberOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Sprzedaż na eksport </b>
						</td>
						<!-- <td bgcolor="#CCCCCC"/> -->
						<td>
							<b>272.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td>
							<b>273.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportTaxRate"/>
								</b>
							</div>
						</td>
						<td>
							<b>274.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportAmountOfTax"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<td>
							<b>275.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
						<td>
							<b>276.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p>
							<sup>3)</sup>W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia wyrobów, w kolumnie „b”, obok nazwy grupy wyrobów należy wpisać odpowiednio: „ubytki” albo „całkowite zniszczenie”. </p>
					</td>
				</tr>
			</table>
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!--<xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(9)</sub>
						<!-- <b style="nag1">/4</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<!-- TABELKA DLA ZAL E -->
		<xsl:if test="akc4e:*">
			<!-- TABELKA DLA E -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="8">C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD SAMOCHODÓW OSOBOWYCH</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b> Lp.</b>
					</td>
					<td width="200">
						<b> Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku</b>
					</td>
					<td>
						<p align="center">
							<b>Ośmiocyfrowy kod  CN </b>
						</p>
					</td>
					<td>
						<p align="center">
							<b>Liczba samochodów objętych podatkiem akcyzowym</b>
						</p>
					</td>
					<td>
						<p align="center">
							<b>Podstawa opodatkowania</b>
						</p>
					</td>
					<td>
						<b>Stawka podatku</b>
					</td>
					<td width="100">
						<p align="center">
							<b>Podatek akcyzowy </b>
						</p>
					</td>
					<td width="100">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat)</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>h</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4e:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select=".//@groupOfGoodsName"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@numberOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@valueOfGoods"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@taxRatePercentage"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(.//@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Sprzedaż na eksport </b>
						</td>
						<!-- <td bgcolor="#CCCCCC"/> -->
						<td>
							<b>147.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td>
							<b>148.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportValueOfGoods"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<b>149.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportTaxRatePercentage"/>
								</b>
							</div>
						</td>
						<td>
							<b>150.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportAmountOfTax"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<!-- <td bgcolor="#CCCCCC"></td> -->
						<td>
							<b>151.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td>
							<b>152.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalValueOfGoods"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
						<td>
							<b>153.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<!-- STOPKA -->
			<!-- KONIEC TABELKI ZAL_E -->
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!--  <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(9)</sub>
						<!-- <b style="nag1">/2</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<!-- TABELKA DLA ZAL F-->
		<xsl:if test="akc4f:*">
			<!-- TABELKA DLA F -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="8">F. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b>Lp. </b>
					</td>
					<td width="301">
						<b>Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku<sup>3)</sup>
						</b>
					</td>
					<td width="101">
						<p align="center">
							<b>Ośmiocyfrowy kod  CN  </b>
						</p>
					</td>
					<td width="140">
						<p align="center">
							<b>Wartość wg maksymalnej ceny detalicznej</b>
						</p>
					</td>
					<td width="143">
						<p align="center">
							<b>Ilość wyrobów <br/>w tysiącach sztuk <br/> (z dokładnością do trzech miejsc po przecinku), <br/> w kg (z dokładnością do dwóch miejsc po przecinku)</b>
						</p>
					</td>
					<td width="127">
						<b>Stawki podatku<sup>4)</sup>
						</b>
					</td>
					<td width="133">
						<p align="center">
							<b>Łączny podatek akcyzowy</b>
						</p>
					</td>
					<td width="100">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat)</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>h</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI AKCF -->
				<xsl:for-each select=".//akc4f:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select=".//@groupOfGoodsName"/>
							</div>
							<xsl:apply-templates mode="Ubytki" select="."/>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@valueOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@numberOfGoods"/>
							</div>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@unitOfMeasure"/>
							</div>
						</td>
						<td>
							<!-- <div align="right" class="cz18" valign="top"> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//@taxRatePercentage"/> </div> <div id="line"/>​							<xsl:value-of select=".//@taxRate"/> </div> -->  a. <div align="right" class="cz16" valign="top">
								<xsl:value-of select=".//@taxRatePercentage"/>
							</div>
							<div id="line"/>
							<div align="right" class="cz16" valign="top">
								<xsl:value-of select=".//@taxMin"/>
							</div>
							<div id="line"/>
							<br/>  b. <div align="right" class="cz16" valign="top">
								<xsl:value-of select=".//@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(.//@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Sprzedaż na eksport </b>
						</td>
						<!-- <td bgcolor="#CCCCCC"/> -->
						<td>
							<b>261.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportValueOfGoods"/>
								</b>
							</div>
						</td>
						<td>
							<b>262.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td>  263a. <div align="right" class="cz16" valign="top">
								<xsl:value-of select=".//@exportTaxRatePercentage"/>
							</div>
							<div id="line"/>
							<br/>  263b. <div align="right" class="cz16" valign="top">
								<xsl:value-of select=".//@exportTaxRate"/>
							</div>
							<!-- <div align="right" class="cz18" valign="top"> <b> <xsl:value-of select=".//@exportTaxRatePercentage"/> <div id="line"/> <xsl:value-of select=".//@exportTaxRate"/> </b> </div> -->
						</td>
						<td>
							<b>264.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportTotalAmountOfTax"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<!-- <td bgcolor="#CCCCCC">-</td> -->
						<td>
							<b>265.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalValueofGoods"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC"/>
						<td>
							<b>266.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
				<tr align="left">
					<td colspan="8">
						<p>
							<sup>3)</sup>W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia wyrobów, w kolumnie „b”, obok nazwy grupy wyrobów należy wpisać odpowiednio: „ubytki” lub „całkowite zniszczenie”.<br/>
							<sup>4)</sup>W poz. oznaczonych numerem z literą „a” należy wpisać stawkę procentową, w poz. oznaczonych numerem z literą „b” należy wpisać stawkę kwotową.</p>
					</td>
				</tr>
			</table>
			<!-- KONIEC TABELKI ZAL_F -->
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(8)</sub>
						<!-- <b style="nag1">/4</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<!-- TABELKA DLA  ZAL H -->
		<xsl:if test="akc4h:*">
			<!-- TABELKA DLA H -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="7">C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD ENERGII ELEKTRYCZNEJ</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<b>Lp. </b>
					</td>
					<!--<td width="301"> Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku </td> -->
					<td width="131">
						<p align="center">
							<b>Ośmiocyfrowy kod  CN </b>
						</p>
					</td>
					<td width="183">
						<p align="center">
							<b>Ilość energii elektrycznej w MWh <br/> (z dokładnością do trzech miejsc po przecinku)</b>
						</p>
					</td>
					<td width="127">
						<b> Stawka podatku </b>
					</td>
					<td width="153">
						<p align="center">
							<b>Podatek akcyzowy</b>
						</p>
					</td>
					<td width="143">
						<p align="center">
							<b>Status energii elektrycznej</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<!-- <td> <div align="center"> <b>g.</b> </div> </td> -->
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4h:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@id"/>
							</div>
						</td>
						<!-- <td> <div align="left" class="cz14" valign="top"> <xsl:value-of select="@groupOfGoodsName"/> </div> <xsl:apply-templates mode="Ubytki" select="."/> </td> -->
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@numberOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<!--<xsl:value-of select="@statusOfElectricity"/> <br/> -->
								<xsl:if test="@statusOfElectricity='nieobjetaZwolnieniem'">nieobjęta zwolnieniem od podatku akcyzowego </xsl:if>
								<xsl:if test="@statusOfElectricity='objeteZwolnieniem_art30_ust6'">objęta zwolnieniem od podatku akcyzowego na podstawie art. 30 ust. 6 ustawy</xsl:if>
								<xsl:if test="@statusOfElectricity='objeteZwolnieniem_art30_ust7'">objęta zwolnieniem od podatku akcyzowego na podstawie art. 30 ust. 7 ustawy</xsl:if>
								<xsl:if test="@statusOfElectricity='objeteZwolnieniem_art30_ust7a_pkt1'">objęta zwolnieniem od podatku akcyzowego na podstawie art. 30 ust. 7a pkt 1  ustawy</xsl:if>
								<xsl:if test="@statusOfElectricity='objeteZwolnieniem_art30_ust7a_pkt2'">objęta zwolnieniem od podatku akcyzowego na podstawie art. 30 ust. 7a pkt 2 ustawy</xsl:if>
								<xsl:if test="@statusOfElectricity='objeteZwolnieniem_art30_ust7a_pkt3'">objęta zwolnieniem od podatku akcyzowego na podstawie art. 30 ust. 7a pkt 3 ustawy</xsl:if>
								<xsl:if test="@statusOfElectricity='objeteZwolnieniem_art30_ust7a_pkt4'">objęta zwolnieniem od podatku akcyzowego na podstawie art. 30 ust. 7a pkt 4 ustawy</xsl:if>
								<xsl:if test="@statusOfElectricity='objetePozostałymiZwolnieniami'">objęta pozostałymi zwolnieniami<sup>3)</sup>
								</xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<!-- <td bgcolor="#CCCCCC"/> -->
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<td>
							<b>45.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC">
							<b>Razem </b>
						</td>
						<td>
							<b>46.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<table width="955">
				<tr>
					<td>
						<sup>1)</sup> Dotyczy podatników niebędących osobami fizycznymi.  <br/>
						<sup>2)</sup>Dotyczy podatników będących osobami fizycznymi. <br/>
						<sup>3)</sup>Wpisuje się zwolnienia od podatku akcyzowego inne niż zwolnienia wymienione w poz. 20, 24, 28, 32, 36 i 40 oraz inne niż zwolnienie, o którym mowa w art. 30 ust. 1 ustawy. W przypadku zwolnienia, o którym mowa w art. 30 ust. 1 ustawy, obniżenie podatku akcyzowego należnego od energii elektrycznej wynikające z otrzymanego dokumentu potwierdzającego umorzenie świadectwa pochodzenia energii wykazuje się w poz. 9. </td>
				</tr>
			</table>
			<!-- KONIEC TABELKI ZAL_H -->
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(10)</sub>
						<!-- 2<b style="nag1">/2</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<!-- TABELKA DLA ZAL I-->
		<xsl:if test="akc4i:*">
			<!-- TABELKA DLA I -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="9">F. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b> Lp. </b>
					</td>
					<td width="260">
						<b> Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku<sup>3)</sup>
						</b>
					</td>
					<td width="110">
						<p align="center">
							<b>Ośmiocyfrowy kod  CN </b>
						</p>
					</td>
					<td colspan="3">
						<p align="center">
							<b>Ilość wyrobów<sup>4)</sup> w tysiącach litrów, w tysiącach kilogramów lub w GJ <br/>wynikająca z wartości opałowej<br/> (z dokładnością do trzech miejsc po przecinku)</b>
						</p>
					</td>
					<td width="107">
						<b> Stawka podatku </b>
					</td>
					<td width="133">
						<p align="center">
							<b>Podatek akcyzowy </b>
						</p>
					</td>
					<td width="100">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat)</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>h</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>i</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4i:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select=".//@groupOfGoodsName"/>
							</div>
							<xsl:apply-templates mode="Ubytki" select="."/>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@numberOfGoodsL"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@numberOfGoodsK"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@fuelValue"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(.//@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Sprzedaż na eksport </b>
						</td>
						<!-- <td bgcolor="#CCCCCC"/> -->
						<td>
							<b>304.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportNumberOfGoodsL"/>
								</b>
							</div>
						</td>
						<td>
							<b>305.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportNumberOfGoodsK"/>
								</b>
							</div>
						</td>
						<td>
							<b>306.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportFuelValue"/>
								</b>
							</div>
						</td>
						<td>
							<b>307.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportTaxRate"/>
								</b>
							</div>
						</td>
						<td>
							<b>308.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportAmountOfTax"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<!-- <td bgcolor="#CCCCCC">-</td> -->
						<td>
							<b>309.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoodsL"/>
								</b>
							</div>
						</td>
						<td>
							<b>310.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoodsK"/>
								</b>
							</div>
						</td>
						<td>
							<b>311.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalFuelValue"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC">-</td>
						<td>
							<b>312.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p>
							<sup>3)</sup> W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia wyrobów, w kolumnie „b”, obok nazwy grupy wyrobów należy wpisać odpowiednio: „ubytki” lub „całkowite zniszczenie”. <br/>
							<sup>4)</sup> Jeżeli stawka podatku akcyzowego została określona w zł/1000 litrów, należy wypełnić pola w kolumnie „d”; jeżeli stawka podatku akcyzowego została określona w zł/1000 kilogramów, należy wypełnić pola w kolumnie „e”; jeżeli stawka podatku akcyzowego została określona w zł/GJ, należy wypełnić pola w kolumnie „f”. </p>
					</td>
				</tr>
			</table>
			<!-- KONIEC TABELKI ZAL_I -->
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(8)</sub>
						<!-- <b style="nag1">/4</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<!-- TABELKA DLA ZAL J -->
		<xsl:if test="akc4j:*">
			<!-- TABELKA DLA J -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="8">F. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b>Lp. </b>
					</td>
					<td width="301">
						<b>Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku<sup>3)</sup>
						</b>
					</td>
					<td width="100">
						<p align="center">
							<b>Ośmiocyfrowy kod  CN </b>
						</p>
					</td>
					<td colspan="2">
						<p align="center">
							<b>Ilość wyrobów w tysiącach kilogramów  <br/> lub ilość GJ wynikająca z wartości opałowej<sup>4)</sup>
								<br/> (z dokładnością do trzech miejsc po przecinku) </b>
						</p>
					</td>
					<td width="80">
						<b>Stawka podatku </b>
					</td>
					<td width="153">
						<p align="center">
							<b>Podatek akcyzowy </b>
						</p>
					</td>
					<td width="100">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat) </b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>h</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4j:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select=".//@groupOfGoodsName"/>
							</div>
							<xsl:apply-templates mode="Ubytki" select="."/>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@numberOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@fuelValue"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(.//@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Sprzedaż na eksport </b>
						</td>
						<!-- <td bgcolor="#CCCCCC"/> -->
						<td>
							<b>288.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td>
							<b>289.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportFuelValue"/>
								</b>
							</div>
						</td>
						<td>
							<b>290.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportTaxRate"/>
								</b>
							</div>
						</td>
						<td>
							<b>291.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportAmountOfTax"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<!-- <td bgcolor="#CCCCCC">-</td> -->
						<td>
							<b>292.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td>
							<b>293.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalFuelValue"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
						<td>
							<b>294.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<!-- STOPKA -->
			<table border="1" width="955">
				<tr>
					<td>
						<p>
							<sup>3)</sup> W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia wyrobów, w kolumnie „b”, obok nazwy grupy wyrobów należy wpisać odpowiednio: „ubytki” lub „całkowite zniszczenie”.       <br/>
							<sup>4)</sup> Jeżeli stawka podatku akcyzowego została określona w zł/1000 kilogramów, należy wypełnić pola w kolumnie „d”, natomiast jeżeli stawka podatku akcyzowego została określona w zł/GJ, należy wypełnić pola w kolumnie „e”.  </p>
					</td>
				</tr>
			</table>
			<!-- KONIEC TABELKI ZAL_J -->
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/>  -->
						</span>
						<sub style="cz9">(8)</sub>
						<!-- <b style="nag1">/4</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<!-- TABELKA DLA ZAL K-->
		<xsl:if test="akc4k:*">
			<!-- TABELKA DLA K -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="8">F. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b> Lp. </b>
					</td>
					<td width="301">
						<b> Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku<sup>3)</sup>
						</b>
					</td>
					<td width="131">
						<p align="center">
							<b>Ośmiocyfrowy kod  CN</b>
						</p>
					</td>
					<td width="183">
						<p align="center">
							<b>Ilość wyrobów <br/> w tysiącach litrów  <br/> (z dokładnością do trzech miejsc po przecinku)</b>
						</p>
					</td>
					<td width="127">
						<b> Stawka podatku</b>
					</td>
					<td width="153">
						<p align="center">
							<b>Podatek akcyzowy</b>
						</p>
					</td>
					<td width="100">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat)</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4k:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select=".//@groupOfGoodsName"/>
							</div>
							<xsl:apply-templates mode="Ubytki" select="."/>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@numberOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(.//@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Sprzedaż na eksport</b>
						</td>
						<!-- <td bgcolor="#CCCCCC"/> -->
						<td>
							<b>271.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td>
							<b>272.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportTaxRate"/>
								</b>
							</div>
						</td>
						<td>
							<b>273.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportAmountOfTax"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<!-- <td bgcolor="#CCCCCC">-</td> -->
						<td>
							<b>274.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
						<td>
							<b>275.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<table border="1" width="955">
				<tr>
					<td>
						<p>
							<sup>3)</sup>W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia wyrobów w kolumnie „b” obok nazwy grupy wyrobów należy wpisać odpowiednio: „ubytki” lub „całkowite zniszczenie”. </p>
					</td>
				</tr>
			</table>
			<!-- KONIEC TABELKI ZAL_K -->
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(9)</sub>
						<!-- <b style="nag1">/4</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<!-- TABELKA DLA ZAL L-->
		<xsl:if test="akc4l:*">
			<!-- TABELKA DLA L -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="7">C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<b> Lp. </b>
					</td>
					<td width="301">
						<b> Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku</b>
					</td>
					<td width="131">
						<p align="center">
							<b>Ośmiocyfrowy kod  CN  </b>
						</p>
					</td>
					<td width="183">
						<p align="center">
							<b>Ilość wyrobów w GJ, wynikająca z wartości opałowej <br/> (z dokładnością do trzech miejsc po przecinku)</b>
						</p>
					</td>
					<td width="127">
						<b> Stawka podatku</b>
					</td>
					<td width="153">
						<p align="center">
							<b>Podatek akcyzowy</b>
						</p>
					</td>
					<td width="100">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat)</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4l:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select=".//@groupOfGoodsName"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@numberOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(.//@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<!-- <td bgcolor="#CCCCCC">-</td> -->
						<td>
							<b>123.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC">-</td>
						<td>
							<b>124.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<!-- KONIEC TABELKI ZAL_L-->
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(6)</sub>
						<!-- <b style="nag1">/2</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<!-- TABELKA DLA ZAL M-->
		<xsl:if test="akc4m:*">
			<!-- TABELKA DLA M -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="9">F. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD PŁYNU DO PAPIEROSÓW ELEKTRONICZNYCH</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b> Lp. </b>
					</td>
					<td width="301">
						<b>  Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku<sup>3)</sup>
						</b>
					</td>
					<td width="131">
						<p align="center">
							<b> Ośmiocyfrowy kod  CN </b>
						</p>
					</td>
					<td width="183">
						<p align="center">
							<b> Ilość wyrobów <br/> w mililitrach  <br/> (z dokładnością do jednego miejsca po przecinku)</b>
						</p>
					</td>
					<td>
						<p align="center">
							<b> Płyn do papierosów elektronicznych zawarty w jednorazowym papierosie elektronicznym (zaznaczyć właściwy kwadrat) </b>
						</p>
					</td>
					<td>
						<p align="center">
							<b> Liczba jednorazowych<br/> papierosów elektronicznych zawierających płyn  <br/>do papierosów elektronicznych<sup>4) </sup>
								<br/> w sztukach </b>
						</p>
					</td>
					<td width="127">
						<b> Stawka podatku </b>
					</td>
					<td width="100">
						<p align="center">
							<b>Podatek akcyzowy</b>
						</p>
					</td>
					<td width="153">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego<br/>(zaznaczyć właściwy kwadrat)</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>h</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>i</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4m:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select=".//@groupOfGoodsName"/>
							</div>
							<xsl:apply-templates mode="Ubytki" select="."/>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@numberOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test=".//@cigaretteLiquidContainedInOne='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test=".//@cigaretteLiquidContainedInOne='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@numberOfElectronicCigarettesContainingLiquid"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(.//@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<!-- <td bgcolor="#CCCCCC">-</td> -->
						<td>
							<b>304.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
						<td>
							<b>305.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@sumNumberOfElectronicCigarettesContainingLiquid"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
						<td>
							<b>306.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<table border="1" width="955">
				<tr>
					<td>
						<p>
							<sup>3)</sup>W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia wyrobów, w kolumnie „b”, obok nazwy grupy wyrobów należy wpisać odpowiednio: „ubytki” lub „całkowite zniszczenie”. <br/>
							<sup>4)</sup>  Pole wypełnia się w przypadku zaznaczenia kwadratu „TAK”, w kolumnie „e” „Płyn do papierosów elektronicznych zawarty w jednorazowym papierosie elektronicznym”.<br/>
							<sup>5)</sup>  W przypadku zaznaczenia kwadratu „TAK” w kolumnie „e” „Płyn do papierosów elektronicznych zawarty w jednorazowym papierosie elektronicznym”, podatek akcyzowy od płynu do papierosów elektronicznych zawartego w jednorazowym papierosie elektronicznym, obliczony według stawki wykazanej w kolumnie „g” „Stawka podatku”, powiększa się o kwotę, o której  mowa w art. 99b ust. 4a ustawy. <br/>
						</p>
					</td>
				</tr>
			</table>
			<!-- KONIEC TABELKI ZAL_M -->
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(3)</sub>
						<!-- <b style="nag1">/4</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<!-- TABELKA DLA ZAL N-->
		<xsl:if test="akc4n:*">
			<!-- TABELKA DLA N -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="8">F. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b> Lp. </b>
					</td>
					<td width="301">
						<b>Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku<sup>3)</sup>
						</b>
					</td>
					<td width="101">
						<p align="center">
							<b>Ośmiocyfrowy kod  CN  </b>
						</p>
					</td>
					<td width="140">
						<p align="center">
							<b>Średnia ważona detaliczna cena sprzedaży tytoniu do palenia obowiązująca w danym roku kalendarzowym</b>
						</p>
					</td>
					<td width="143">
						<p align="center">
							<b>Ilość wyrobów <br/>w kg <br/> (z dokładnością do trzech miejsc po przecinku) </b>
						</p>
					</td>
					<td width="127">
						<b> Stawka podatku<sup>4)</sup>
						</b>
					</td>
					<td width="133">
						<p align="center">
							<b>Łączny podatek akcyzowy </b>
						</p>
					</td>
					<td width="100">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat)</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>h</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI AKCM -->
				<xsl:for-each select=".//akc4n:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select=".//@groupOfGoodsName"/>
							</div>
							<xsl:apply-templates mode="Ubytki" select="."/>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@weightedAverageRetailPrice"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@numberOfGoods"/>
							</div>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@unitOfMeasure"/>
							</div>
						</td>
						<td>   a. <div align="right" class="cz16" valign="top">
								<xsl:value-of select="@taxRatePercentage"/>
							</div>
							<div align="right" class="cz16" valign="top">
								<xsl:value-of select="@taxMin"/>
							</div>
							<div align="right" class="cz16" valign="top"> ________ </div>
							<br/>  b. <div align="right" class="cz16" valign="top">
								<xsl:value-of select="@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(.//@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Sprzedaż na eksport </b>
						</td>
						<!-- <td bgcolor="#CCCCCC"/> -->
						<td>
							<b>260.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportValueOfGoods"/>
								</b>
							</div>
						</td>
						<td>
							<b>261.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td>  262a. <div align="right" class="cz16" valign="top">
								<xsl:value-of select=".//@exportTaxRatePercentage"/>
							</div>
							<div align="right" class="cz16" valign="top"> ________</div>
							<br/>  262b. <div align="right" class="cz16" valign="top">
								<xsl:value-of select=".//@exportTaxRate"/>
							</div>
							<!-- <div align="right" class="cz18" valign="top"> <b> <xsl:value-of select=".//@exportTaxRatePercentage"/> <div id="line"/> <xsl:value-of select=".//@exportTaxRate"/> </b> </div> -->
						</td>
						<td>
							<b>263.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@exportTotalAmountOfTax"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<td bgcolor="#CCCCCC">-</td>
						<td>
							<b>264.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
						<!-- <td bgcolor="#CCCCCC">-</td> -->
						<td>
							<b>265.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
				<tr align="left">
					<td colspan="8">
						<p>
							<sup>3)</sup>W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia wyrobów, w kolumnie „b”, obok nazwy grupy wyrobów należy wpisać odpowiednio: „ubytki” lub „całkowite zniszczenie”.<br/>
							<sup>4)</sup>W poz. oznaczonych numerem z literą „a” należy wpisać stawkę procentową, a w poz. oznaczonych numerem z literą „b” należy wpisać stawkę kwotową.</p>
					</td>
				</tr>
			</table>
			<!-- KONIEC TABELKI ZAL_N -->
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(2)</sub>
						<!-- <b style="nag1">/4</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<!-- TABELKA DLA ZAL O-->
		<xsl:if test="akc4o:*">
			<!-- TABELKA DLA M -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="7">F. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b> Lp. </b>
					</td>
					<td width="301">
						<b>  Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku<sup>3)</sup>
						</b>
					</td>
					<td width="131">
						<p align="center">
							<b> Ośmiocyfrowy kod  CN </b>
						</p>
					</td>
					<td width="183">
						<p align="center">
							<b> Ilość wyrobów <br/> w kg  <br/> (z dokładnością do trzech miejsc po przecinku)</b>
						</p>
					</td>
					<td width="127">
						<b> Stawka podatku </b>
					</td>
					<td width="153">
						<p align="center">
							<b>Podatek akcyzowy</b>
						</p>
					</td>
					<td width="100">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat)</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4o:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select=".//@groupOfGoodsName"/>
							</div>
							<xsl:apply-templates mode="Ubytki" select="."/>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@numberOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(.//@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<!-- <td bgcolor="#CCCCCC">-</td> -->
						<td>
							<b>266.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC">-</td>
						<td>
							<b>267.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<table border="1" width="955">
				<tr>
					<td>
						<p>
							<sup>3)</sup>W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia wyrobów, w kolumnie „b”, obok nazwy grupy wyrobów należy wpisać odpowiednio: „ubytki” lub „całkowite zniszczenie”. </p>
					</td>
				</tr>
			</table>
			<!-- KONIEC TABELKI ZAL_O -->
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(1)</sub>
						<!-- <b style="nag1">/4</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<!-- TABELKA DLA ZAL P-->
		<xsl:if test="akc4p:*">
			<!-- TABELKA DLA P -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="7">F. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b> Lp. </b>
					</td>
					<td width="301">
						<b>  Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku<sup>3)</sup>
						</b>
					</td>
					<td width="131">
						<p align="center">
							<b> Ośmiocyfrowy kod  CN </b>
						</p>
					</td>
					<td width="183">
						<p align="center">
							<b> Ilość wyrobów <br/> w kg  <br/> (z dokładnością do trzech miejsc po przecinku)</b>
						</p>
					</td>
					<td width="127">
						<b> Stawka podatku </b>
					</td>
					<td width="153">
						<p align="center">
							<b>Podatek akcyzowy</b>
						</p>
					</td>
					<td width="100">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat)</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4p:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select=".//@groupOfGoodsName"/>
							</div>
							<xsl:apply-templates mode="Ubytki" select="."/>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@numberOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(.//@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<!-- <td bgcolor="#CCCCCC">-</td> -->
						<td>
							<b>266.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC">-</td>
						<td>
							<b>267.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<table border="1" width="955">
				<tr>
					<td>
						<p>
							<sup>3)</sup>W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia wyrobów, w kolumnie „b”, obok nazwy grupy wyrobów należy wpisać odpowiednio: „ubytki” lub „całkowite zniszczenie”. </p>
					</td>
				</tr>
			</table>
			<!-- KONIEC TABELKI ZAL_P -->
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(1)</sub>
						<!-- <b style="nag1">/4</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
		<!-- TABELKA DLA ZAL R-->
		<xsl:if test="akc4r:*">
			<!-- TABELKA DLA R -->
			<table border="1" width="955">
				<!-- NAGLOWEK -->
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td class="nag1" colspan="7">F. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td>
				</tr>
				<!-- I-OPIS -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td width="20">
						<b> Lp. </b>
					</td>
					<td width="301">
						<b>  Rodzaj urządzenia do waporyzacji<sup>3)</sup>,<sup>4)</sup>
						</b>
					</td>
					<td width="131">
						<p align="center">
							<b> Ośmiocyfrowy kod  CN </b>
						</p>
					</td>
					<td width="183">
						<p align="center">
							<b> Liczba wyrobów  <br/> w sztukach</b>
						</p>
					</td>
					<td width="127">
						<b> Stawka podatku </b>
					</td>
					<td width="100">
						<p align="center">
							<b>Podatek akcyzowy</b>
						</p>
					</td>
					<td width="153">
						<p align="center">
							<b>Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat)</b>
						</p>
					</td>
				</tr>
				<!-- II-WIERSZ - OZNACZENIE -->
				<tr align="center" bgcolor="#CCCCCC" valign="middle">
					<td>
						<div align="center">
							<b>a</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>b</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>c</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>d</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>e</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>f</b>
						</div>
					</td>
					<td>
						<div align="center">
							<b>g</b>
						</div>
					</td>
				</tr>
				<!-- III - WARTOSCI -->
				<xsl:for-each select=".//akc4r:Item">
					<tr align="left" valign="top">
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@id"/>
							</div>
						</td>
						<td>
							<div align="left" class="cz14" valign="top">
								<xsl:value-of select=".//@typeOfVapingDevice"/>
							</div>
							<xsl:apply-templates mode="Ubytki" select="."/>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@codeCN"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@numberOfGoods"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select=".//@taxRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="format-number(number(.//@amountOfTax),'# ##0')"/>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td>
							<div align="right" class="cz14" valign="top">
								<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
								<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<!-- PODSUMOWANIE TABELKI -->
				<xsl:for-each select=".">
					<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
					<tr>
						<td bgcolor="#CCCCCC"/>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem </b>
						</td>
						<!-- <td bgcolor="#CCCCCC">-</td> -->
						<td>
							<b>266.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select=".//@totalNumberOfGoods"/>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC">-</td>
						<td>
							<b>267.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/>
								</b>
								<span align="right" class="cz9" valign="bottom">zł</span>
							</div>
						</td>
						<td bgcolor="#CCCCCC"/>
					</tr>
				</xsl:for-each>
			</table>
			<table border="1" width="955">
				<tr>
					<td>
						<p>
							<sup>3)</sup>W przypadku wykazywania ubytków wyrobów akcyzowych (przekraczających normy dopuszczalnych ubytków) lub całkowitego zniszczenia wyrobów, w kolumnie „b”, obok nazwy grupy wyrobów należy wpisać odpowiednio: „ubytki” lub „całkowite zniszczenie”. <br/>
							<sup>4)</sup>Należy wskazać jedną z następujących kategorii  urządzeń do waporyzacji a) wielorazowe papierosy elektroniczne, b) podgrzewacze albo c) urządzenia wielofunkcyjne. </p>
					</td>
				</tr>
			</table>
			<!-- KONIEC TABELKI ZAL_P -->
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1"> AKC-4/<xsl:value-of select="substring(name(.),11,11)"/>
							<!-- <xsl:value-of select="substring-after(name(.), ':')"/> -->
						</span>
						<sub style="cz9">(1)</sub>
						<!-- <b style="nag1">/4</b> -->
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT.  WPLAT DZIENNYCH-->
	<xsl:template match="*" mode="WplatyDzienne_Zal">
		<!-- tymczasowo -->
		<!-- ZNAK KONCA STRONY DO WYDRUKU -->
		<div style="page-break-before: always">
			<!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select="." mode = "stopka"/></b></span> </td> </tr> </table> -->
		</div>
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="7">E. INFORMACJA O WPŁATACH DZIENNYCH</td>
			</tr>
			<tr align="center" bgcolor="#CCCCCC" valign="middle">
				<td width="20">
					<b> Lp. </b>
				</td>
				<td width="120">
					<b>Data powstania obowiązku podatkowego</b>
				</td>
				<td width="182">
					<xsl:if test="akc4a:* |akc4b:* |akc4c:* |akc4d:* | akc4e:* |akc4f:* |akc4h:* |akc4i:* |akc4j:* |akc4k:* |akc4l:* |akc4n:*">
						<b>Podatek akcyzowy z dnia powstania obowiązku podatkowego (pomniejszony o przysługujące zwolnienia i obniżenia)</b>
					</xsl:if>
					<xsl:if test="akc4m:* | akc4o:* | akc4p:* | akc4r:*">
						<b>Podatek akcyzowy z dnia powstania obowiązku podatkowego (pomniejszony o przysługujące obniżenia i zwolnienia)</b>
					</xsl:if>
				</td>
				<td width="125">
					<b>Data dokonania wpłaty dziennej</b>
				</td>
				<td width="182">
					<b>Nadwyżka wpłat z poprzedniej deklaracji zaliczona na poczet wpłat dziennych</b>
				</td>
				<td colspan="2">
					<b>Dokonana wpłata dzienna</b>
				</td>
			</tr>
			<tr bgcolor="#CCCCCC">
				<td>
					<div align="center">
						<b>a</b>
					</div>
				</td>
				<td>
					<div align="center">
						<b>b</b>
					</div>
				</td>
				<td>
					<div align="center">
						<b>c</b>
					</div>
				</td>
				<td>
					<div align="center">
						<b>d</b>
					</div>
				</td>
				<td>
					<div align="center">
						<b>e</b>
					</div>
				</td>
				<td colspan="2">
					<div align="center">
						<b>f</b>
					</div>
				</td>
			</tr>
			<xsl:for-each select=".//akc4a:DailyAmount | .//akc4b:DailyAmount | .//akc4c:DailyAmount | .//akc4c:DailyAmount | .//akc4d:DailyAmount |.//akc4e:DailyAmount | .//akc4f:DailyAmount | .//akc4h:DailyAmount | .//akc4i:DailyAmount | .//akc4j:DailyAmount | .//akc4k:DailyAmount | .//akc4l:DailyAmount | .//akc4m:DailyAmount | .//akc4n:DailyAmount | .//akc4o:DailyAmount | .//akc4p:DailyAmount | .//akc4r:DailyAmount">
				<tr>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select="position()"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz14" valign="top">
							<xsl:value-of select=".//@taxObligationCreationDate"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select="format-number(number(.//@dueAmount),'# ##0')"/>
							<span align="right" class="cz9" valign="bottom">zł</span>
						</div>
					</td>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select=".//@dateOfPaym"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select="format-number(number(.//@amountOfExcessDailyPaymPrevDecl),'# ##0')"/>
							<span align="right" class="cz9" valign="bottom">zł</span>
						</div>
					</td>
					<td colspan="2">
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select="format-number(number(.//@amountOfDailyPaym),'# ##0')"/>
							<span align="right" class="cz9" valign="bottom">zł</span>
						</div>
					</td>
				</tr>
			</xsl:for-each>
			<!-- PODSUMOWANIE RAZEM -->
			<xsl:for-each select="./*">
				<xsl:if test="akc4a:* |akc4b:* |akc4f:*">
					<tr align="left" valign="top">
						<td bgcolor="#CCCCCC" colspan="2">-</td>
						<td>
							<b>174.</b>
							<br/>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(./*/@totalDueAmountOfDailyPaym),'# ##0')"/>
									<span align="right" class="cz9" valign="bottom">zł</span>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC">-</td>
						<td>
							<b>175.</b>
							<br/>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(./*/@totalAmountOfExcessDailyPaymPrevDecl),'# ##0')"/>
									<span align="right" class="cz9" valign="bottom">zł</span>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC" width="125">-</td>
						<td width="155">
							<b>176.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(./*/@totalAmountOfDailyPaym),'# ##0')"/>
									<span align="right" class="cz9" valign="bottom">zł</span>
								</b>
							</div>
						</td>
					</tr>
					<tr align="left" valign="top">
						<td bgcolor="#CCCCCC" colspan="3">
							<b>Razem kwota należnych wpłat dziennych<br/> (suma kwot z kolumny c) </b>
						</td>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem kwota nadwyżki wpłat z poprzedniej deklaracji zaliczona na poczet wpłat dziennych  (suma kwot z kolumny e) </b>
						</td>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem kwota dokonanych wpłat dziennych <br/>(suma kwot z kolumny f)</b>
						</td>
					</tr>
				</xsl:if>
				<!--- Dla akcK -->
				<xsl:if test="akc4k:* ">
					<tr align="left" valign="top">
						<td bgcolor="#CCCCCC" colspan="2">-</td>
						<td>
							<b>172.</b>
							<br/>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(./*/@totalDueAmountOfDailyPaym),'# ##0')"/>
									<span align="right" class="cz9" valign="bottom">zł</span>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC">-</td>
						<td>
							<b>173.</b>
							<br/>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(./*/@totalAmountOfExcessDailyPaymPrevDecl),'# ##0')"/>
									<span align="right" class="cz9" valign="bottom">zł</span>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC" width="125">-</td>
						<td width="155">
							<b>174.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(./*/@totalAmountOfDailyPaym),'# ##0')"/>
									<span align="right" class="cz9" valign="bottom">zł</span>
								</b>
							</div>
						</td>
					</tr>
					<tr align="left" valign="top">
						<td bgcolor="#CCCCCC" colspan="3">
							<b>Razem kwota należnych wpłat dziennych<br/> (suma kwot z kolumny c) </b>
						</td>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem kwota nadwyżki wpłat z poprzedniej deklaracji zaliczona na poczet wpłat dziennych  (suma kwot z kolumny e) </b>
						</td>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem kwota dokonanych wpłat dziennych <br/>(suma kwot z kolumny f)</b>
						</td>
					</tr>
				</xsl:if>
				<!--- Dla akcC -->
				<xsl:if test="akc4c:* | akc4d:* | akc4h:* |akc4i:* |akc4j:* |akc4l:* | akc4m:* | akc4n:* | akc4m:* | akc4o:* | akc4p:* | akc4r:*">
					<tr align="left" valign="top">
						<td bgcolor="#CCCCCC" colspan="2">-</td>
						<td>
							<b>173.</b>
							<br/>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(./*/@totalDueAmountOfDailyPaym),'# ##0')"/>
									<span align="right" class="cz9" valign="bottom">zł</span>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC">-</td>
						<td>
							<b>174.</b>
							<br/>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(./*/@totalAmountOfExcessDailyPaymPrevDecl),'# ##0')"/>
									<span align="right" class="cz9" valign="bottom">zł</span>
								</b>
							</div>
						</td>
						<td bgcolor="#CCCCCC" width="125">-</td>
						<td width="155">
							<b>175.</b>
							<div align="right" class="cz18" valign="top">
								<b>
									<xsl:value-of select="format-number(number(./*/@totalAmountOfDailyPaym),'# ##0')"/>
									<span align="right" class="cz9" valign="bottom">zł</span>
								</b>
							</div>
						</td>
					</tr>
					<tr align="left" valign="top">
						<td bgcolor="#CCCCCC" colspan="3">
							<b>Razem kwota należnych wpłat dziennych<br/> (suma kwot z kolumny c) </b>
						</td>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem kwota nadwyżki wpłat z poprzedniej deklaracji zaliczona na poczet wpłat dziennych  (suma kwot z kolumny e) </b>
						</td>
						<td bgcolor="#CCCCCC" colspan="2">
							<b>Razem kwota dokonanych wpłat dziennych <br/>(suma kwot z kolumny f)</b>
						</td>
					</tr>
				</xsl:if>
			</xsl:for-each>
		</table>
	</xsl:template>
	<!-- KONIEC all AG, support by PK editet 2025-08-08-->
</xsl:stylesheet>