<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:p="http://www.mf.gov.pl/RMPD/2024/03/18/RMPD_500.xsd" xmlns:tp="http://www.mf.gov.pl/RMPD/2024/03/18/PTypes.xsd" version="2.0">
  <xsl:template match="p:RMPD_500">
    <html>
      <head>
        <script>
          //<![CDATA[
					// Module
				var languative;
				(function (languative) {
				    var phraseIdAttr = "data-phrase-id";

				    languative.ignoreTags = {
				        img: "<img />",
				        br: "<br />",
				        hr: "<hr />"
				    };

				    languative.dictonaries = {
				        html: {
				            _id: "en",
				            _name: "English"
				        },

				        pl: {
				            _id: "pl",
				            _name: "Polski - Polish"
				        },

				        en: {
				            _id: "en",
				            _name: "English"
				        }
				    };

				    languative.selectedDictionary = null;

				    function getDictionary(langKey) {
				        langKey = langKey.toLowerCase();
				        if (langKey in languative.dictonaries)
				            return languative.dictonaries[langKey];
				            else
				            return languative.dictonaries["pl"];

				        // Dictionary at key "pl-PL" not found, so keep looking for key "pl"
				        var sep = langKey.indexOf("-");
				        if (sep > 0)
				            langKey = langKey.substring(0, sep);
				        return languative.dictonaries[langKey];
				    }
				    languative.getDictionary = getDictionary;

				    function getPhrase(phraseId) {
				        var res = findPhrase(phraseId);
				        if (res)
				            return res; else
				            return phraseId;
				    }
				    languative.getPhrase = getPhrase;

				    function findPhrase(phraseId) {
				        if ((phraseId == null) || (phraseId == ""))
				            return null;

				        if ((languative.selectedDictionary != null) && (phraseId in languative.selectedDictionary))
				            return languative.selectedDictionary[phraseId];
				        if (phraseId in languative.dictonaries.html)
				            return languative.dictonaries.html[phraseId];

				        return null;
				    }
				    languative.findPhrase = findPhrase;

				    function getYesNo(value) {
				        if (value === undefined)
				            return getPhrase("undefined"); else if (value)
				            return getPhrase("yes"); else
				            return getPhrase("no");
				    }
				    languative.getYesNo = getYesNo;

				    //IE8 Tweak
				    function getAttr(node, attr) {
				        var result = (node.getAttribute && node.getAttribute(attr)) || null;
				        if (!result && node.attributes) {
				            for (var i = 0; i < node.attributes.length; i++) {
				                var attrNode = node.attributes[i];
				                if (attrNode.nodeName === attr)
				                    return attrNode.nodeValue;
				            }
				        }
				        return result;
				    }

				    function changeLanguage(langKey) {
				        function setTagPhrase(tag, phrase) {
				            if (tag.childNodes.length > 1) {
				                for (var ci = 0; ci < tag.childNodes.length; ci++) {
				                    var chNode = tag.childNodes[ci];
				                    var nName = chNode.nodeName.toLowerCase();
				                    if (!(nName in languative.ignoreTags)) {
				                        if ("innerHTML" in chNode) {
				                            chNode["innerHTML"] = " " + phrase[ci] + " ";
				                        } else {
				                            chNode.nodeValue = " " + phrase[ci] + " ";
				                        }
				                    }
				                }
				            } else {
				                tag.innerHTML = " " + phrase + " ";
				            }
				        }

				        //return;
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            console.warn("Cannot identify dictionary by key '" + langKey + "'. Default dictionary (" + languative.dictonaries.html._id + ": " + languative.dictonaries.html._name + ") used instead.");
				            langDict = languative.dictonaries.html;
				        }
				        languative.selectedDictionary = langDict;

				        var tags = getHtmlTags();
				        for (var ti = 0; ti < tags.length; ti++) {
				            var tag = tags[ti];
				            var phraseId = getAttr(tag, phraseIdAttr);
				            if ((phraseId != null)) {
				                var phraseValue = languative.getPhrase(phraseId);
				                if (phraseValue) {
				                    setTagPhrase(tag, phraseValue);
				                } else {
				                    console.warn("Phrase not definied in dictionary: data-phrase-id='" + phraseId + "'");
				                }
				            }
				        }

				        if (langDict["Title"] != null) {
				            document.title = langDict["Title"];
				        }
				    }
				    languative.changeLanguage = changeLanguage;

				    function getHtmlTags() {
				        var res = new Array();
				        var docTags = document.body.getElementsByTagName("*");

				        for (var i = 0; i < docTags.length; i++) {
				            var docTag = docTags[i];
				            var phraseId = getAttr(docTag, phraseIdAttr);
				            if (phraseId)
				                res.push(docTag);
				        }
				        return res;
				    }

				    var initialized = false;

				    function init() {
				        if (!initialized) {
				            initialized = true;
				            var htmlDict = languative.dictonaries.en;

				            for (var dictKey in htmlDict) {
				                if (!(dictKey in languative.dictonaries.html)) {
				                    languative.dictonaries.html[dictKey] = htmlDict[dictKey];
				                }
				            }
				            var nav = window.navigator;
				            languative.changeLanguage(nav.userLanguage || nav.language);
				        }
				    }
				    languative.init = init;

				    function modifyDictionary(langKey, dictModifications) {
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            languative.dictonaries[langKey.toLowerCase()] = dictModifications;
				        } else {
				            for (var dictKey in dictModifications) {
				                langDict[dictKey] = dictModifications[dictKey];
				            }
				        }
				    }
				    languative.modifyDictionary = modifyDictionary;
				})(languative || (languative = {}));

				if (document.addEventListener)
				    document.addEventListener('DOMContentLoaded', languative.init);

				if (window.addEventListener) {
				    window.addEventListener('load', languative.init, false);
				} else {
				    window.attachEvent('onload', languative.init);
				}
				<!-- sourceMappingURL=languative.js.map -->

				languative.modifyDictionary("html", {
            		githubLink: "Fork me on GitHub"
        		});

languative.modifyDictionary("pl", {
rmpd500: "RMPD_500 - INFORMACJA O PRZYCZYNACH ODRZUCENIA ZGŁOSZENIA",
selectLanguage: "Wybierz język:",
english: "English",
polish: "Polski",
rmpdNumber: "NUMER REFERENCYJNY ZGŁOSZENIA:",
rmpdChecksumOfDocument: "Suma kontrolna dokumentu podana w formacie SHA-1:",
rmpdCodeOfMessage: "Kod komunikatu/błędu:",
rmpdCreationDate: "Data rejestracji:",
rmpdCreator: "Użytkownik rejestrujący:",
rmpdIdRmpd: "RMPD ID:",
rmpdIncomingNumber: "Numer wpływu:",
rmpdListOfMessages: "Lista z informacjami o operacji lub błędach w walidacji zgłoszenia",
rmpdMessage: "Treść komunikatu/błędu:",
rmpdTypeOfNotification: "Typ komunikatu:",
rmpdTypeOfNotification0: "Informacja o błędzie",
rmpdTypeOfNotification1: "Informacja o poprawnym wykonaniu operacji",
rmpdTypeOfRegistry: "Rodzaj rejestru źródłowego:",
rmpdNumberInRegistry: "Numer zgłoszenia przewozu:",
rmpdOrganisationName: "Podmiot:",
rmpdSourceDocumentID: "Numer własny zgłoszenia:",
rmpdSourceDocumentInfo: "Dane komunikatu, którego dotyczy niniejsze potwierdzenie lub informacja",
rmpdSystemInfo: "Informacje systemowe",
rmpdSystemName: "System:",
rmpdTypeOfOperation: "Typ operacji na zgłoszeniu:"
});

languative.modifyDictionary("en", {
rmpd500: "RMPD_500 - INFORMATION ABOUT THE REASONS FOR THE REJECTION",
selectLanguage: "Select language:",
english: "English",
polish: "Polski",
rmpdNumber: "CARRIAGE NOTIFICATION NUMBER:",
rmpdChecksumOfDocument: "Checksum of the document provided in the SHA-1 format:",
rmpdCodeOfMessage: "Message/error code:",
rmpdCreationDate: "Creation date:",
rmpdCreator: "User registering:",
rmpdIdRmpd: "RMPD ID:",
rmpdIncomingNumber: "Incoming number:",
rmpdListOfMessages: "List of information on the operation or errors in notification validation",
rmpdMessage: "Message/error text:",
rmpdTypeOfNotification: "Type of notification:",
rmpdTypeOfNotification0: "Information on errors",
rmpdTypeOfNotification1: "Information on valid operation",
rmpdTypeOfRegistry: "Type of source registry:",
rmpdNumberInRegistry: "Carriage notification number:",
rmpdOrganisationName: "Entity:",
rmpdSourceDocumentID: "Own number of the notification:",
rmpdSourceDocumentInfo: "Data of the notification this confirmation or information refers to",
rmpdSystemInfo: "System information",
rmpdSystemName: "System:",
rmpdTypeOfOperation: "Operation type on the notification:"
});

function loadHtmlDictionary() {
document.getElementById("htmlDictionary").innerText = JSON.stringify(languative.dictonaries.html, null, "  ");
}

function loadActiveDictionary() {
document.getElementById("activeDictionary").innerText = JSON.stringify(languative.getDictionaryFromHtml(), null, "  ");
}

//]]>
        </script>
        <style>
          * {
          -webkit-print-color-adjust: exact !important;
          color-adjust: exact !important;
          }

          @media print {
          body {-webkit-print-color-adjust: exact;}
          }

          body {
          font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
          margin: 0 auto;
          padding: 0 auto;
          }

          .rmpd-xslt h1 {
          padding: 6px 4px 4px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#E1E5E7;
          font-weight: bold;
          font-size: 14px;
          margin-bottom: 0;
          border-bottom: 1px solid #dbddde;
          }

          .rmpd-xslt .h2 {
          padding: 15px 4px 15px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#FA8072;
          font-weight: bold;
          font-size: 12px;
          margin-bottom: 0;
          border: 2px solid red;
          }

          .rmpd-xslt .h3 {
          padding: 15px 4px 15px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#98FB98;
          font-weight: bold;
          font-size: 12px;
          margin-bottom: 0;
          border: 2px solid green;
          }

          .rmpd-xslt {
          border-collapse: initial;
          }

          .rmpd-xslt .s1 {
          max-width: 1220px;
          border: 1px solid #c8c9ca;
          }

          .rmpd-xslt .t1 {
          position: relative;
          display: table;
          width: 100%;
          }

          .rmpd-xslt .rmpd {
          font-size: 22px;
          text-transform: uppercase;
          font-weight: bold;
          display:block;
          padding: 5px 3px 5px 10px;
          }

          .rmpd-xslt .header {
          font-size: 12px;
          margin: 0 !important;
          text-transform: uppercase;
          font-weight: normal;
          display:block;
          color: #000000;
          background-color:#EBEDEF;
          padding:6px 5px 5px 10px;
          border-top: 1px solid #dbddde;
          }

          .rmpd-xslt .header2 {
          font-size: 12px;
          margin: 0;
          font-weight: normal;
          display:block;
          background-color:#f6f6f6;
          padding:3px 3px 3px 10px;
          border-top: 1px solid #dbddde;
          }

          .rmpd-xslt .element-1 {
          font-size: 12px;
          font-weight: normal;
          }

          .rmpd-xslt .element-2 {
          font-size: 12px;
          font-weight: normal;
          text-decoration: underline;
          }

          .rmpd-xslt .grupInfo p {
          margin: 3px 0 3px 10px;
          font-weight: bold;
          font-size: 12px;
          }

          .rmpd-xslt .grupInfo {
          border-top: 1px solid #dbddde;
          }

          .rmpd-xslt .info {
          width: 100%;
          float: left;
          display: table-cell;
          padding: 4px 0px;
          }

          .rmpd-xslt .info1 {
          width: 50%;
          float: left;
          display: table-cell;
          padding: 4px 0px;
          }

          .rmpd-xslt .info3 {
          width: 33%;
          float: left;
          display: table-cell;
          }

          .rmpd-xslt .lang ul {
          margin: 0 auto;
          padding: 0;
          }

          .rmpd-xslt .lang ul li {
          display: inline;
          margin-left: 10px;
          }

          .rmpd-xslt .h2 {
          padding: 15px 4px 15px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#FA8072;
          font-weight: bold;
          font-size: 12px;
          margin-bottom: 0;
          border: 2px solid red;
          }

          .rmpd-xslt .h3 {
          padding: 15px 4px 15px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#98FB98;
          font-weight: bold;
          font-size: 12px;
          margin-bottom: 0;
          border: 2px solid green;
          }
        </style>
      </head>
      <body onLoad="languative.changeLanguage('pl');">
        <div class="rmpd-xslt">
          <section class="rmpd-xslt s1">
            <div class="rmpd-xslt lang">
              <ul>
                <li>
                  <span class="rmpd-xslt element-1" data-phrase-id="selectLanguage"/>
                </li>
                <li>
                  <span class="rmpd-xslt element-1">
                    <a href="#" onclick="languative.changeLanguage('en');">
                      <img
                        src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAB6ElEQVQoz2OYNHPfjqtvqqcfS2kGosOJjQdu3n27NrlxTUIdkOGZvc0jbYdtzIaoxp1zAvOr5x5lWLLi1P+Nq/79+3/74ZdFG27PX38HyP4/ped/XyuQMWnh5d65F06eePyvq+bf358TNl1gSGo5uOfku/9Ll/8/uPf///9t064Cyf+pmf8TEoF0Sd+lL4vWfO/uBrLnrbokaTIDpGHhhrt1E68+3Hf/T1P9fwiIifkfHgFi5Gb+f/Hiwp23jp7Li5qOCOpOZAA6FOQGNBAa+t/PD00MqOzMtZcMaxJr/0/u+J+S8j8+/n9k5P+QEJBSH59/rq6/7O1/Wlp+NzH5qqf3VVv7Z7Bbq7wVDhtsbf+YWUDMBeK/f//++fvn958/J6++YLCP29Qz53xU2o4rV9//f/vmZ3I8SJWRyW99Q7CGv0+dHPfP3CohPSskYT2DcDaDedi6xetBIfO5se5DV1dMyTEg+4+27i9NbaCrreyX/Pz//8usuS8SYpqmnmMQTGeYvPnyv39/v7dXHD1wu7DhYF7DYaAL/4Z4/A5y/vf3b3jattC41dsP3/r758frBN/soiUMVfMOTHFJds5cJKgzh0djMofqhPPXXrRKW7SIm5y+8pJBvJhBtIBBOFfEsK53z3VX0zwAPExoqi63l4YAAAAASUVORK5CYII='/>
                    </a>
                  </span>
                </li>
                <li>
                  <span class="rmpd-xslt element-1">
                    <a href="#" onclick="languative.changeLanguage('pl');">
                      <img
                        src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAMAAABBPP0LAAAAhFBMVEXDAADKAADVAQHX19faAADd3d3jDQ3k5eXlExPmGRnnLi7oHx/oMjLoNjbpJCTqKirq6urrLi7sLy/sOzrsRETtNDTtS0vuUFDu7u7vi4vvmZnwVlfwj4/xlJTy8vL0m5v19fX29vb39/f4+Pj5+fn6+vr7+/v8/Pz9/f39/f7+/v7///9BfFeGAAAAXUlEQVQIHQXB0W1CMRRAMecRpI7BZ/dfiRWQqBC5p/Z6wPDhz5t1+xWVqp4bq1FVLRuWqioucKuqNPu8AKNjtb3AdU5nuncB1zmdSTa4vtOZxrT94Hsf+TQstkEQ/8uqTs/uhVeSAAAAAElFTkSuQmCC'/>
                    </a>
                  </span>
                </li>
              </ul>
            </div>
            <xsl:choose>
              <xsl:when test="p:TypeOfNotification = '1'">
                <p data-phrase-id="rmpd500" class="rmpd-xslt h3"/>
              </xsl:when>
              <xsl:otherwise>
                <p data-phrase-id="rmpd500" class="rmpd-xslt h2"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="p:RmpdNumber != ''">
              <div class="rmpd-xslt t1">
                <div class="rmpd-xslt rmpd">
                  <xsl:value-of select="p:RmpdNumber"/>
                </div>
              </div>
            </xsl:if>
            <div class="rmpd-xslt t1">
              <p class="rmpd-xslt header" data-phrase-id="rmpdSystemInfo"/>
              <div class="rmpd-xslt grupInfo">
                <div class="rmpd-xslt info1">
                  <p>
                    <span class="rmpd-xslt element-1" data-phrase-id="rmpdOrganisationName"/>
                    <xsl:value-of select="p:SystemInfo/tp:OrganisationName"/>
                  </p>
                </div>
                <div class="rmpd-xslt info1">
                  <p>
                    <span class="rmpd-xslt element-1" data-phrase-id="rmpdSystemName"/>
                    <xsl:value-of select="p:SystemInfo/tp:SystemName"/>
                  </p>
                </div>
              </div>
            </div>
            <div class="rmpd-xslt t1">
              <p class="rmpd-xslt header" data-phrase-id="rmpdSourceDocumentInfo"/>
              <div class="rmpd-xslt grupInfo">
                <div class="rmpd-xslt info1">
                  <xsl:if test="p:SourceDocumentInfo/tp:CreationDate != ''">
                    <xsl:variable name="creDate" select="substring-before(p:SourceDocumentInfo/tp:CreationDate, 'T')"/>
                    <xsl:variable name="creTime" select="substring(p:SourceDocumentInfo/tp:CreationDate, 12,8)"/>
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdCreationDate"/>
                      <xsl:value-of select="$creDate"/> godz.<xsl:value-of select="$creTime"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="p:SourceDocumentInfo/tp:Creator != ''">
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdCreator"/>
                      <xsl:value-of select="p:SourceDocumentInfo/tp:Creator"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="p:SourceDocumentInfo/tp:RmpdId != ''">
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdIdRmpd"/>
                      <xsl:value-of select="p:SourceDocumentInfo/tp:RmpdId"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="p:SourceDocumentInfo/tp:SourceDocumentId != ''">
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdSourceDocumentID"/>
                      <xsl:value-of select="p:SourceDocumentInfo/tp:SourceDocumentId"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="p:SourceDocumentInfo/tp:ChecksumOfDocument != ''">
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdChecksumOfDocument"/>
                      <xsl:value-of select="p:SourceDocumentInfo/tp:ChecksumOfDocument"/>
                    </p>
                  </xsl:if>
                </div>
                <div class="rmpd-xslt info1">
                  <xsl:if test="p:SourceDocumentInfo/tp:IncomingNumber != ''">
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdIncomingNumber"/>
                      <xsl:value-of select="p:SourceDocumentInfo/tp:IncomingNumber"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="p:TypeOfNotification != ''">
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdTypeOfNotification"/>
                      <xsl:choose>
                        <xsl:when test="p:TypeOfNotification = '0'">
                          <span data-phrase-id="rmpdTypeOfNotification0"/>
                        </xsl:when>
                        <xsl:when test="p:TypeOfNotification = '1'">
                          <span data-phrase-id="rmpdTypeOfNotification1"/>
                        </xsl:when>
                      </xsl:choose>
                    </p>
                  </xsl:if>
                  <xsl:if test="p:TypeOfRegistry != ''">
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdTypeOfRegistry"/>
                      <xsl:value-of select="p:TypeOfRegistry"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="p:NumberInRegistry != ''">
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdNumberInRegistry"/>
                      <xsl:value-of select="p:NumberInRegistry"/>
                    </p>
                  </xsl:if>
                </div>
              </div>
            </div>
            <xsl:if test="p:ListOfMessages != ''">
              <div class="rmpd-xslt t1">
                <p class="rmpd-xslt header" data-phrase-id="rmpdListOfMessages"/>
                <xsl:for-each select="p:ListOfMessages">
                  <div class="rmpd-xslt grupInfo">
                    <xsl:if test="tp:TypeOfOperation != ''">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdTypeOfOperation"/>
                        <xsl:value-of select="tp:TypeOfOperation"/>
                      </p>
                    </xsl:if>
                    <xsl:if test="tp:CodeOfMessage != ''">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdCodeOfMessage"/>
                        <xsl:value-of select="tp:CodeOfMessage"/>
                      </p>
                    </xsl:if>
                    <xsl:if test="tp:Message != ''">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdMessage"/>
                        <xsl:value-of select="tp:Message"/>
                      </p>
                    </xsl:if>
                  </div>
                </xsl:for-each>
              </div>
            </xsl:if>
          </section>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
