<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:p="http://www.mf.gov.pl/RMPD/2024/03/18/RMPD_110.xsd" xmlns:tp="http://www.mf.gov.pl/RMPD/2024/03/18/PTypes.xsd">
  <xsl:template match="p:RMPD_110">
    <html>
      <head>
        <script>
          //<![CDATA[
					// Module
				var languative;
				(function (languative) {
				    var phraseIdAttr = "data-phrase-id";

				    languative.ignoreTags = {
				        img: "<img />",
				        br: "<br />",
				        hr: "<hr />"
				    };

				    languative.dictonaries = {
				        html: {
				            _id: "en",
				            _name: "English"
				        },

				        pl: {
				            _id: "pl",
				            _name: "Polski - Polish"
				        },

				        en: {
				            _id: "en",
				            _name: "English"
				        }
				    };

				    languative.selectedDictionary = null;

				    function getDictionary(langKey) {
				        langKey = langKey.toLowerCase();
				        if (langKey in languative.dictonaries)
				            return languative.dictonaries[langKey];
				            else
				            return languative.dictonaries["pl"];

				        // Dictionary at key "pl-PL" not found, so keep looking for key "pl"
				        var sep = langKey.indexOf("-");
				        if (sep > 0)
				            langKey = langKey.substring(0, sep);
				        return languative.dictonaries[langKey];
				    }
				    languative.getDictionary = getDictionary;

				    function getPhrase(phraseId) {
				        var res = findPhrase(phraseId);
				        if (res)
				            return res; else
				            return phraseId;
				    }
				    languative.getPhrase = getPhrase;

				    function findPhrase(phraseId) {
				        if ((phraseId == null) || (phraseId == ""))
				            return null;

				        if ((languative.selectedDictionary != null) && (phraseId in languative.selectedDictionary))
				            return languative.selectedDictionary[phraseId];
				        if (phraseId in languative.dictonaries.html)
				            return languative.dictonaries.html[phraseId];

				        return null;
				    }
				    languative.findPhrase = findPhrase;

				    function getYesNo(value) {
				        if (value === undefined)
				            return getPhrase("undefined"); else if (value)
				            return getPhrase("yes"); else
				            return getPhrase("no");
				    }
				    languative.getYesNo = getYesNo;

				    //IE8 Tweak
				    function getAttr(node, attr) {
				        var result = (node.getAttribute && node.getAttribute(attr)) || null;
				        if (!result && node.attributes) {
				            for (var i = 0; i < node.attributes.length; i++) {
				                var attrNode = node.attributes[i];
				                if (attrNode.nodeName === attr)
				                    return attrNode.nodeValue;
				            }
				        }
				        return result;
				    }

				    function changeLanguage(langKey) {
				        function setTagPhrase(tag, phrase) {
				            if (tag.childNodes.length > 1) {
				                for (var ci = 0; ci < tag.childNodes.length; ci++) {
				                    var chNode = tag.childNodes[ci];
				                    var nName = chNode.nodeName.toLowerCase();
				                    if (!(nName in languative.ignoreTags)) {
				                        if ("innerHTML" in chNode) {
				                            chNode["innerHTML"] = " " + phrase[ci] + " ";
				                        } else {
				                            chNode.nodeValue = " " + phrase[ci] + " ";
				                        }
				                    }
				                }
				            } else {
				                tag.innerHTML = " " + phrase + " ";
				            }
				        }

				        //return;
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            console.warn("Cannot identify dictionary by key '" + langKey + "'. Default dictionary (" + languative.dictonaries.html._id + ": " + languative.dictonaries.html._name + ") used instead.");
				            langDict = languative.dictonaries.html;
				        }
				        languative.selectedDictionary = langDict;

				        var tags = getHtmlTags();
				        for (var ti = 0; ti < tags.length; ti++) {
				            var tag = tags[ti];
				            var phraseId = getAttr(tag, phraseIdAttr);
				            if ((phraseId != null)) {
				                var phraseValue = languative.getPhrase(phraseId);
				                if (phraseValue) {
				                    setTagPhrase(tag, phraseValue);
				                } else {
				                    console.warn("Phrase not definied in dictionary: data-phrase-id='" + phraseId + "'");
				                }
				            }
				        }

				        if (langDict["Title"] != null) {
				            document.title = langDict["Title"];
				        }
                        if(langKey === "pl" || langKey === "pl-PL"){
                          document.getElementById('pl').style.display = "block";
                          document.getElementById('en').style.display = "none";
				        } else {
				          document.getElementById('pl').style.display = "none";
                          document.getElementById('en').style.display = "block";
				        }
				    }
				    languative.changeLanguage = changeLanguage;

				    function getHtmlTags() {
				        var res = new Array();
				        var docTags = document.body.getElementsByTagName("*");

				        for (var i = 0; i < docTags.length; i++) {
				            var docTag = docTags[i];
				            var phraseId = getAttr(docTag, phraseIdAttr);
				            if (phraseId)
				                res.push(docTag);
				        }
				        return res;
				    }

				    var initialized = false;

				    function init() {
				        if (!initialized) {
				            initialized = true;
				            var htmlDict = languative.dictonaries.en;

				            for (var dictKey in htmlDict) {
				                if (!(dictKey in languative.dictonaries.html)) {
				                    languative.dictonaries.html[dictKey] = htmlDict[dictKey];
				                }
				            }
				            var nav = window.navigator;
				            languative.changeLanguage(nav.userLanguage || nav.language);
				        }
				    }
				    languative.init = init;

				    function modifyDictionary(langKey, dictModifications) {
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            languative.dictonaries[langKey.toLowerCase()] = dictModifications;
				        } else {
				            for (var dictKey in dictModifications) {
				                langDict[dictKey] = dictModifications[dictKey];
				            }
				        }
				    }
				    languative.modifyDictionary = modifyDictionary;
				})(languative || (languative = {}));

				if (document.addEventListener)
				    document.addEventListener('DOMContentLoaded', languative.init);

				if (window.addEventListener) {
				    window.addEventListener('load', languative.init, false);
				} else {
				    window.attachEvent('onload', languative.init);
				}
				<!-- sourceMappingURL=languative.js.map -->

				languative.modifyDictionary("html", {
            		githubLink: "Fork me on GitHub"
        		});
languative.modifyDictionary("pl", {
english: "English",
polish: "Polski",
selectLanguage: "Wybierz język:",
rmpdRegisteredRmpdInfo: "Dane informacyjne o zgłoszeniu",
rmpdCreationDate: "Data rejestracji:",
rmpdCreator: "Użytkownik rejestrujący zgłoszenie:",
rmpdModificationDate: "Data modyfikacji:",
rmpdModifier: "Użytkownik modyfikujący zgłoszenie:",
rmpdSourceDocumentId: "Numer własny zgłoszenia:",
rmpdChecksumOfSourceDocument: "Suma kontrolna dokumentu:",
rmpdRmpdStatus: "Status zgłoszenia:",
rmpd100: "RMPD_100 - REJESTRACJA PRZEWOZU PRZEZ PRZEWOŹNIKA",
rmpd110: "RMPD_110 - POTWIERDZENIE REJESTRACJI ZGŁOSZENIA PRZEWOZU I NADANIE NUMERU",
rmpd111: "RMPD_111 - POTWIERDZENIE REJESTRACJI ZGŁOSZENIA PRZEWOZU I NADANIE NUMERU",
rmpdAdditionalInfo: "Informacje dodatkowe",
rmpdAdress: "Adres:",
rmpdAdresses: "Kanały komunikacji zwrotnej",
rmpdAuthenticationKey: "Odcisk palca certyfikatu:",
rmpdCarrierKey: "Klucz przewoźnika:",
rmpdComments: "Uwagi do zgłoszenia:",
rmpdCountryLoadCode: "Informacje o państwie załadunku towaru:",
rmpdCountryUnloadCode: "Informacje o państwie rozładunku:",
rmpdEmail: "Adresy e-mail:",
rmpdEndInsidePL: "Miejsce zakończenia przejazdu",
rmpdEndTransportDate: "Data zakończenia przewozu towaru:",
rmpdEntranceToPoland: "Miejsce wjazdu na terytorium Polski",
rmpdExitFromPoland: "Miejsce wyjazdu poza terytorium Polski",
rmpdFailoverCarrierEmail: "E-mail przewoźnika:",
rmpdFailoverGeoLocatorNumber: "Numer zapasowego lokalizatora GPS:",
rmpdGoodsCarrierInfo: "Informacje o przewoźniku",
rmpdGoodsRecipientInfo: "Informacje o odbiorcy",
rmpdGoodsSenderInfo: "Informacje o nadawcy",
rmpdIdSisc: "Identyfikator idSISC:",
rmpdLoaded: "Informacja o ładunku:",
rmpdLoadedNo: "Bez ładunku",
rmpdLoadedYes: "Z ładunkiem",
rmpdJourneyDirection: "Kierunek przejazdu:",
rmpdJourneyDirection1: "Pierwszy przejazd zgodnie ze wzorem zezwolenia",
rmpdJourneyDirection2: "Przejazd powrotny zgodnie ze wzorem zezwolenia",
rmpdLatitude: "Szerokość geograficzna:",
rmpdLatitudeLongitude: "Szerokość i długość geograficzna:",
rmpdLocatorNumber: "Numer urządzenia/lokalizatora GPS:",
rmpdLongitude: "Długość geograficzna:",
rmpdNotificationSMSPhone: "Telefon do powiadomień SMS:",
rmpdNotObligedLegalBasePl: "Podstawa prawna zwolnienia z obowiązku posiadania zezwolenia:",
rmpdNotObligedLegalBaseDescriptionPl: "Uzasadnienie zwolnienia z obowiązku posiadania zezwolenia:",
rmpdNotObligedLegalBaseEn: "Podstawa prawna zwolnienia z obowiązku posiadania zezwolenia:",
rmpdNotObligedLegalBaseDescriptionEn: "Uzasadnienie zwolnienia z obowiązku posiadania zezwolenia:",
rmpdNumber: "Numer zgłoszenia:",
rmpdNumberOfTransportDocument: "Numer dokumentu przewozu:",
rmpdOtherPlace: "Inne miejsce:",
rmpdPassword: "Hasło:",
rmpdPermissionCountry: "Kraj zezwolenia:",
rmpdPermissionHeader: "Dane zezwolenia",
rmpdPermissionInfo: "Informacje o transporcie towarów",
rmpdPermissionNumber: "Numer zezwolenia:",
rmpdPreviousRmpdNumber: "Poprzedni RmpdNumber:",
rmpdProvince: "Województwo:",
rmpdRouteNumber: "Numer drogi:",
rmpdRoutePlace: "Miejsce przekroczenia granicy:",
rmpdSimcId: "Identyfikator miejscowości:",
rmpdSourceDocumentID: "Numer własny zgłoszenia:",
rmpdStartEndPlaceJourney: "Miejsce rozpoczęcia i zakończenia przejazdu",
rmpdStartInsidePL: "Miejsce rozpoczęcia przejazdu",
rmpdStartTransportDate: "Data rozpoczęcia przewozu towaru:",
rmpdStatements: "Oświadczenia",
rmpdStatements1: "Oświadczam, że posiadam upoważnienie do złożenia niniejszego zgłoszenia w imieniu i na rzecz podmiotu zobowiązanego",
rmpdStatementsFullName: "Imię i nazwisko:",
rmpdStatus0: "Zarejestrowane",
rmpdStatus1: "Niekompletne",
rmpdStatus2: "Kompletne",
rmpdStatus3: "Zamknięte",
rmpdStatus4: "Anulowane",
rmpdStatus5: "Zamknięte automatycznie",
rmpdStatusNo: "Nie",
rmpdStatusYes: "Tak",
rmpdTercId: "Identyfikator terytorialny:",
rmpdTraderIdentityNumber: "Numer identyfikatora:",
rmpdTraderIdentityType: "Rodzaj identyfikatora:",
rmpdTraderName: "Pełna nazwa:",
rmpdTrailerCountry: "Kraj naczepy/przyczepy:",
rmpdTrailerNumber: "Numer rejestracyjny naczepy:",
rmpdTransportMean: "Informacje o środku transportu",
rmpdTruckCountry: "Kraj pojazdu:",
rmpdTruckNumber: "Numer rejestracyjny ciągnika:",
rmpdTruckNumber: "Numer rejestracyjny pojazdu:",
rmpdTypeOfPermission: "Wybór typu zezwolenia lub zwolnienia z obowiązku posiadania zezwolenia:",
rmpdTypeOfPermission1: "Blankiet jednorazowy",
rmpdTypeOfPermission2: "Zezwolenie EKMT",
rmpdTypeOfPermission3: "Kabotażowe",
rmpdTypeOfPermission4: "Zwolnienie z obowiązku posiadania zezwolenia",
rmpdTypeOfRoadTransport: "Typ realizowanego przejazdu:",
rmpdTypeOfRoadTransport1: "Transport dwustronny",
rmpdTypeOfRoadTransport2: "Transport tranzytowy",
rmpdTypeOfRoadTransport3: "Transport kraje trzecie",
rmpdTypeOfRoadTransport4: "Kabotaż",
rmpdTypeOfTransportDocument: "Typ dokumentu przewozu:",
rmpdUlicId: "Identyfikator ulic:",
rmpdURL: "Adres URL:",
rmpdUserName: "Nazwa użytkownika:",
rmpdValidFrom: "Ważne od:",
rmpdValidTo: "Ważne do:",
rmpdWebservice: "Kanał Web service:",
rmpdWS: "Adres Web service zapisany w usłudze e-Klient:"
});

languative.modifyDictionary("en", {
english: "English",
polish: "Polski",
selectLanguage: "Select language:",
rmpdRegisteredRmpdInfo: "Report information",
rmpdCreationDate: "Date of registration:",
rmpdCreator: "User registering the notification:",
rmpdModificationDate: "Modification date:",
rmpdModifier: "User modifying the notification:",
rmpdSourceDocumentId: "Own notification number:",
rmpdChecksumOfSourceDocument: "Checksum of source document:",
rmpdRmpdStatus: "Notification status:",
rmpd100: "RMPD_100 - REGISTRATION OF THE NOTIFICATION OF THE CARRIAGE",
rmpd110: "RMPD_110 - CONFIRMATION OF THE NOTIFICATION OF THE CARRIAGE AND ASSIGNING THE NUMBER",
rmpd111: "RMPD_111 - CONFIRMATION OF THE NOTIFICATION OF THE CARRIAGE AND ASSIGNING THE NUMBER",
rmpdAdditionalInfo: "Additional information",
rmpdAdress: "Address:",
rmpdAdresses: "Feedback communication channel",
rmpdAuthenticationKey: "Fingerprint of certificate:",
rmpdCarrierKey: "Carrier Key:",
rmpdComments: "Comments to the notification:",
rmpdCountryLoadCode: "Information on the load country:",
rmpdCountryUnloadCode: "Information on the unload country:",
rmpdEmail: "E-mail addresses:",
rmpdEndInsidePL: "Place of end of the journey",
rmpdEndTransportDate: "End date of the carriage of goods:",
rmpdEntranceToPoland: "Place of entrance to Poland",
rmpdExitFromPoland: "Place of exit from Poland",
rmpdFailoverCarrierEmail: "The carrier's e-mail",
rmpdFailoverGeoLocatorNumber: "Backup GPS device number",
rmpdGoodsCarrierInfo: "Information on the carrier",
rmpdGoodsRecipientInfo: "Information on the recipient",
rmpdGoodsSenderInfo: "Information on the sender",
rmpdIdSisc: "idSISC identification number:",
rmpdLoaded: "Information about transported goods:",
rmpdLoadedNo: "Without goods",
rmpdLoadedYes: "With goods",
rmpdJourneyDirection: "Journey direction:",
rmpdJourneyDirection1: "First journey in accordance with the permit template",
rmpdJourneyDirection2: "Return journey in accordance with the permit template",
rmpdLatitude: "Latitude:",
rmpdLatitudeLongitude: "Latitude and Longitude:",
rmpdLocatorNumber: "GPS locator number:",
rmpdLongitude: "Longitude:",
rmpdNotificationSMSPhone: "SMS notification phone number:",
rmpdNotObligedLegalBasePl: "Legal basis for exemption from the obligation to have a permit:",
rmpdNotObligedLegalBaseDescriptionPl: "Justification for exemption from the obligation to have a permit:",
rmpdNotObligedLegalBaseEn: "Legal basis for exemption from the obligation to have a permit:",
rmpdNotObligedLegalBaseDescriptionEn: "Justification for exemption from the obligation to have a permit:",
rmpdNumber: "Notification number:",
rmpdNumberOfTransportDocument: "Transport document number:",
rmpdOtherPlace: "Other place:",
rmpdPassword: "Password:",
rmpdPermissionCountry: "Permission Country:",
rmpdPermissionHeader: "Permission info",
rmpdPermissionInfo: "Information on the transport of goods",
rmpdPermissionNumber: "Permission Number:",
rmpdPreviousRmpdNumber: "Previous RmpdNumber:",
rmpdProvince: "Province:",
rmpdRouteNumber: "Route number:",
rmpdRoutePlace: "Place of border crossing:",
rmpdSimcId: "City identifier of territorial division:",
rmpdSourceDocumentID: "Own number of the notification:",
rmpdStartEndPlaceJourney: "Place of start and end of the journey",
rmpdStartInsidePL: "Place of start of the journey",
rmpdStartTransportDate: "Start date of the carriage of goods:",
rmpdStatements: "Declarations",
rmpdStatements1: "I declare that I am authorized to submit this notification for and on behalf of the obligated entity",
rmpdStatementsFullName: "Full Name:",
rmpdStatus0: "Registered",
rmpdStatus1: "Incomplete",
rmpdStatus2: "Complete",
rmpdStatus3: "Closed",
rmpdStatus4: "Canceled",
rmpdStatus5: "Closed automatically",
rmpdStatusNo: "No",
rmpdStatusYes: "Yes",
rmpdTercId: "Identifier of territorial division:",
rmpdTraderIdentityNumber: "Identification number:",
rmpdTraderIdentityType: "Identification type:",
rmpdTraderName: "Full name:",
rmpdTrailerCountry: "Trailer country:",
rmpdTrailerNumber: "Trailer registration number:",
rmpdTransportMean: "Information on the means of transport",
rmpdTruckCountry: "Vehicle country:",
rmpdTruckNumber: "Vehicle registration number:",
rmpdTruckNumber: "Vehicle registration number:",
rmpdTypeOfPermission: "Selecting the type of permit or exemption from the obligation to have a permit:",
rmpdTypeOfPermission1: "Disposable permit",
rmpdTypeOfPermission2: "EKMT permit",
rmpdTypeOfPermission3: "Cabotage",
rmpdTypeOfPermission4: "Exemption from the obligation to have a permit",
rmpdTypeOfRoadTransport: "Type of transport performed:",
rmpdTypeOfRoadTransport1: "Bilateral transport",
rmpdTypeOfRoadTransport2: "Transit transport",
rmpdTypeOfRoadTransport3: "3rd country transport",
rmpdTypeOfRoadTransport4: "Cabotage",
rmpdTypeOfTransportDocument: "Transport document type:",
rmpdUlicId: "Street identifier of territorial division:",
rmpdURL: "URL address:",
rmpdUserName: "User Name:",
rmpdValidFrom: "Valid from:",
rmpdValidTo: "Valid to:",
rmpdWebservice: "Web service channel:",
rmpdWS: "Web service address which is indicated in the e-Client service:"
});

function loadHtmlDictionary() {
document.getElementById("htmlDictionary").innerText = JSON.stringify(languative.dictonaries.html, null, "  ");
}

function loadActiveDictionary() {
document.getElementById("activeDictionary").innerText = JSON.stringify(languative.getDictionaryFromHtml(), null, "  ");
}

//]]>
        </script>
        <style>
          * {
          -webkit-print-color-adjust: exact !important;
          color-adjust: exact !important;
          }

          @media print {
          body {
          -webkit-print-color-adjust: exact;
          }
          }

          body {
          font-family: "Helvetica Neue ",Helvetica,Arial,sans-serif; margin: 0 auto; padding: 0 auto;}

          .rmpd-xslt h1 { padding: 6px 4px 4px 10px; color:#000000; margin-top: 0; background-color:#E1E5E7; font-weight: bold;
          font-size: 14px;
          margin-bottom: 0;
          border-bottom: 1px solid #dbddde;
          }

          .rmpd-xslt {
          border-collapse: initial;
          }

          .rmpd-xslt .s1 {
          max-width: 1220px;
          border: 1px solid #c8c9ca;
          }

          .rmpd-xslt .t1 {
          position: relative;
          display: table;
          width: 100%;
          }

          .rmpd-xslt .sent {
          font-size: 22px;
          text-transform: uppercase;
          font-weight: bold;
          display: block;
          padding: 5px 3px 5px 10px;
          }

          .rmpd-xslt .rmpdheader0 {
          font-size: 12px;
          margin: 0 !important;
          text-transform: uppercase;
          font-weight: normal;
          display: block;
          color: #000000;
          background-color: #EBEDEF;
          padding: 6px 5px 5px 10px;
          border-top: 1px solid #dbddde;
          }

          .rmpd-xslt .rmpdheader {
          font-size: 12px;
          margin: 0;
          font-weight: normal;
          display: block;
          background-color: #f6f6f6;
          padding: 3px 3px 3px 10px;
          border-top: 1px solid #dbddde;
          }

          .rmpd-xslt .element-1 {
          font-size: 12px;
          font-weight: normal;
          }

          .rmpd-xslt .element-2 {
          font-size: 12px;
          font-weight: normal;
          text-decoration: underline;
          }

          .rmpd-xslt .grupInfo p {
          margin: 3px 0 3px 10px;
          font-weight: bold;
          font-size: 12px;
          }

          .rmpd-xslt .grupInfo {
          border-top: 1px solid #dbddde;
          }

          .rmpd-xslt .info {
          width: 100%;
          float: left;
          display: table-cell;
          padding: 4px 0;
          }

          .rmpd-xslt .info1 {
          width: 50%;
          float: left;
          display: table-cell;
          padding: 4px 0;
          }

          .rmpd-xslt .info3 {
          width: 33%;
          float: left;
          display: table-cell;
          }

          .rmpd-xslt .lang ul {
          margin: 0 auto;
          padding: 0;
          }

          .rmpd-xslt .lang ul li {
          display: inline;
          margin-left: 10px;
          }

          .sent-xslt .green-key {
          background-color: #DAFFCC;
          padding: 7px 0 !important;
          }

        </style>
      </head>
      <body>
        <div class="rmpd-xslt">
          <section class="rmpd-xslt s1">
            <div class="rmpd-xslt lang">
              <ul>
                <li>
                  <span class="rmpd-xslt element-1" data-phrase-id="selectLanguage"/>
                </li>
                <li>
                  <span class="rmpd-xslt element-1">
                    <a href="#" onclick="languative.changeLanguage('en');">
                      <img
                        src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAB6ElEQVQoz2OYNHPfjqtvqqcfS2kGosOJjQdu3n27NrlxTUIdkOGZvc0jbYdtzIaoxp1zAvOr5x5lWLLi1P+Nq/79+3/74ZdFG27PX38HyP4/ped/XyuQMWnh5d65F06eePyvq+bf358TNl1gSGo5uOfku/9Ll/8/uPf///9t064Cyf+pmf8TEoF0Sd+lL4vWfO/uBrLnrbokaTIDpGHhhrt1E68+3Hf/T1P9fwiIifkfHgFi5Gb+f/Hiwp23jp7Li5qOCOpOZAA6FOQGNBAa+t/PD00MqOzMtZcMaxJr/0/u+J+S8j8+/n9k5P+QEJBSH59/rq6/7O1/Wlp+NzH5qqf3VVv7Z7Bbq7wVDhtsbf+YWUDMBeK/f//++fvn958/J6++YLCP29Qz53xU2o4rV9//f/vmZ3I8SJWRyW99Q7CGv0+dHPfP3CohPSskYT2DcDaDedi6xetBIfO5se5DV1dMyTEg+4+27i9NbaCrreyX/Pz//8usuS8SYpqmnmMQTGeYvPnyv39/v7dXHD1wu7DhYF7DYaAL/4Z4/A5y/vf3b3jattC41dsP3/r758frBN/soiUMVfMOTHFJds5cJKgzh0djMofqhPPXXrRKW7SIm5y+8pJBvJhBtIBBOFfEsK53z3VX0zwAPExoqi63l4YAAAAASUVORK5CYII='/>
                    </a>
                  </span>
                </li>
                <li>
                  <span class="rmpd-xslt element-1">
                    <a href="#" onclick="languative.changeLanguage('pl');">
                      <img
                        src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAMAAABBPP0LAAAAhFBMVEXDAADKAADVAQHX19faAADd3d3jDQ3k5eXlExPmGRnnLi7oHx/oMjLoNjbpJCTqKirq6urrLi7sLy/sOzrsRETtNDTtS0vuUFDu7u7vi4vvmZnwVlfwj4/xlJTy8vL0m5v19fX29vb39/f4+Pj5+fn6+vr7+/v8/Pz9/f39/f7+/v7///9BfFeGAAAAXUlEQVQIHQXB0W1CMRRAMecRpI7BZ/dfiRWQqBC5p/Z6wPDhz5t1+xWVqp4bq1FVLRuWqioucKuqNPu8AKNjtb3AdU5nuncB1zmdSTa4vtOZxrT94Hsf+TQstkEQ/8uqTs/uhVeSAAAAAElFTkSuQmCC'/>
                    </a>
                  </span>
                </li>
              </ul>
            </div>
            <h1 data-phrase-id="rmpd110"/>
            <div class="rmpd-xslt t1">
              <div class="rmpd-xslt sent">
                <div class="rmpd-xslt info1">
                  <xsl:value-of select="p:RmpdNumber"/>
                  <xsl:choose>
                    <xsl:when test="p:RegisteredRmpdInfo/tp:RmpdStatus = '0'">-
                      <span data-phrase-id="rmpdStatus0"/>
                    </xsl:when>
                    <xsl:when test="p:RegisteredRmpdInfo/tp:RmpdStatus = '1'">-
                      <span data-phrase-id="rmpdStatus1"/>
                    </xsl:when>
                    <xsl:when test="p:RegisteredRmpdInfo/tp:RmpdStatus = '2'">-
                      <span data-phrase-id="rmpdStatus2"/>
                    </xsl:when>
                    <xsl:when test="p:RegisteredRmpdInfo/tp:RmpdStatus = '3'">-
                      <span data-phrase-id="rmpdStatus3"/>
                    </xsl:when>
                    <xsl:when test="p:RegisteredRmpdInfo/tp:RmpdStatus = '4'">-
                      <span data-phrase-id="rmpdStatus4"/>
                    </xsl:when>
                    <xsl:when test="p:RegisteredRmpdInfo/tp:RmpdStatus = '5'">-
                      <span data-phrase-id="rmpdStatus5"/>
                    </xsl:when>
                    <xsl:otherwise>-
                      <xsl:value-of select="p:RegisteredRmpdInfo/tp:RmpdStatus"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </div>
                <div class="rmpd-xslt info1">
                  <xsl:if test="p:CarrierKey != ''">
                    <span class="rmpd-xslt element-1" data-phrase-id="rmpdCarrierKey"/>
                    <xsl:value-of select="p:CarrierKey"/>
                  </xsl:if>
                </div>
              </div>
            </div>
            <div class="rmpd-xslt t1">
              <p class="rmpd-xslt rmpdheader0" data-phrase-id="rmpdRegisteredRmpdInfo"/>
              <div class="rmpd-xslt grupInfo">
                <div class="rmpd-xslt info1">
                  <xsl:variable name="creDate" select="substring-before(p:RegisteredRmpdInfo/tp:CreationDate, 'T')"/>
                  <xsl:variable name="creTime" select="substring(p:RegisteredRmpdInfo/tp:CreationDate, 12,8)"/>
                  <p>
                    <span class="rmpd-xslt element-1" data-phrase-id="rmpdCreationDate"/>
                    <xsl:value-of select="$creDate"/> godz.<xsl:value-of select="$creTime"/>
                  </p>
                  <p>
                    <span class="rmpd-xslt element-1" data-phrase-id="rmpdCreator"/>
                    <xsl:value-of select="p:RegisteredRmpdInfo/tp:Creator"/>
                  </p>
                  <xsl:variable name="modDate" select="substring-before(p:RegisteredRmpdInfo/tp:ModificationDate, 'T')"/>
                  <xsl:variable name="modTime" select="substring(p:RegisteredRmpdInfo/tp:ModificationDate, 12,8)"/>
                  <p>
                    <span class="rmpd-xslt element-1" data-phrase-id="rmpdModificationDate"/>
                    <xsl:value-of select="$modDate"/> godz.<xsl:value-of select="$modTime"/>
                  </p>
                  <p>
                    <span class="rmpd-xslt element-1" data-phrase-id="rmpdModifier"/>
                    <xsl:value-of select="p:RegisteredRmpdInfo/tp:Modifier"/>
                  </p>
                </div>
                <div class="rmpd-xslt info1">
                  <xsl:if test="p:RegisteredRmpdInfo/tp:SourceDocumentId !=''">
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdSourceDocumentId"/>
                      <xsl:value-of select="p:RegisteredRmpdInfo/tp:SourceDocumentId"/>
                    </p>
                  </xsl:if>
                  <p>
                    <span class="rmpd-xslt element-1" data-phrase-id="rmpdChecksumOfSourceDocument"/>
                    <xsl:value-of select="p:RegisteredRmpdInfo/tp:ChecksumOfSourceDocument"/>
                  </p>
                  <p>
                    <span class="rmpd-xslt element-1" data-phrase-id="rmpdRmpdStatus"/>
                    <xsl:choose>
                      <xsl:when test="p:RegisteredRmpdInfo/tp:RmpdStatus = '0'">
                        <span data-phrase-id="rmpdStatus0"/>
                      </xsl:when>
                      <xsl:when test="p:RegisteredRmpdInfo/tp:RmpdStatus = '1'">
                        <span data-phrase-id="rmpdStatus1"/>
                      </xsl:when>
                      <xsl:when test="p:RegisteredRmpdInfo/tp:RmpdStatus = '2'">
                        <span data-phrase-id="rmpdStatus2"/>
                      </xsl:when>
                      <xsl:when test="p:RegisteredRmpdInfo/tp:RmpdStatus = '3'">
                        <span data-phrase-id="rmpdStatus3"/>
                      </xsl:when>
                      <xsl:when test="p:RegisteredRmpdInfo/tp:RmpdStatus = '4'">
                        <span data-phrase-id="rmpdStatus4"/>
                      </xsl:when>
                      <xsl:when test="p:RegisteredRmpdInfo/tp:RmpdStatus = '5'">
                        <span data-phrase-id="rmpdStatus5"/>
                      </xsl:when>
                    </xsl:choose>
                  </p>
                </div>
              </div>
            </div>
            <xsl:if test="p:Carrier != ''">
              <div class="rmpd-xslt t1">
                <p class="rmpd-xslt rmpdheader0" data-phrase-id="rmpdGoodsCarrierInfo"/>
                <div class="rmpd-xslt grupInfo">
                  <div class="rmpd-xslt info1">
                    <xsl:if test="p:Carrier/tp:TraderInfo/tp:IdSisc !=''">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdIdSisc"/>
                        <xsl:value-of select="p:Carrier/tp:TraderInfo/tp:IdSisc"/>
                      </p>
                    </xsl:if>
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdTraderName"/>
                      <xsl:value-of select="p:Carrier/tp:TraderInfo/tp:TraderName"/>
                    </p>
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdTraderIdentityType"/>
                      <xsl:value-of select="p:Carrier/tp:TraderInfo/tp:TraderIdentityType"/>
                    </p>
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdTraderIdentityNumber"/>
                      <xsl:value-of select="p:Carrier/tp:TraderInfo/tp:TraderIdentityNumber"/>
                    </p>
                  </div>
                  <div class="rmpd-xslt info1">
                    <p>
                      <span class="rmpd-xslt element-2" data-phrase-id="rmpdAdress"/>
                    </p>
                    <xsl:variable name="ulica">
                      <xsl:choose>
                        <xsl:when test="p:Carrier/tp:TraderAddress/tp:FlatNumber != ''">
                          <p>
                            <xsl:value-of select="p:Carrier/tp:TraderAddress/tp:Street"/>
                            <xsl:text>&#160;</xsl:text> <xsl:value-of select="p:Carrier/tp:TraderAddress/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of select="p:Carrier/tp:TraderAddress/tp:FlatNumber"/>
                          </p>
                        </xsl:when>
                        <xsl:otherwise>
                          <p>
                            <xsl:value-of select="p:Carrier/tp:TraderAddress/tp:Street"/>
                            <xsl:text>&#160;</xsl:text>
                            <xsl:value-of select="p:Carrier/tp:TraderAddress/tp:HouseNumber"/>
                          </p>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:variable>
                    <p>
                      <xsl:value-of select="$ulica"/>
                    </p>
                    <p>
                      <xsl:value-of select="p:Carrier/tp:TraderAddress/tp:PostalCode"/>
                      <xsl:text>&#160;</xsl:text>
                      <xsl:value-of select="p:Carrier/tp:TraderAddress/tp:City"/>
                      <xsl:if test="p:Carrier/tp:TraderAddress/tp:City != ''">,</xsl:if>
                      <xsl:text>&#160;</xsl:text>
                      <xsl:value-of select="p:Carrier/tp:TraderAddress/tp:Country"/>
                    </p>
                  </div>
                </div>
              </div>
            </xsl:if>
            <xsl:if test="p:GoodsSender != ''">
              <div class="rmpd-xslt t1">
                <p class="rmpd-xslt rmpdheader0" data-phrase-id="rmpdGoodsSenderInfo"/>
                <div class="rmpd-xslt grupInfo">
                  <div class="rmpd-xslt info1">
                    <xsl:if test="p:GoodsSender/tp:TraderInfo/tp:IdSisc !=''">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdIdSisc"/>
                        <xsl:value-of select="p:GoodsSender/tp:TraderInfo/tp:IdSisc"/>
                      </p>
                    </xsl:if>
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdTraderName"/>
                      <xsl:value-of select="p:GoodsSender/tp:TraderInfo/tp:TraderName"/>
                    </p>
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdTraderIdentityType"/>
                      <xsl:value-of select="p:GoodsSender/tp:TraderInfo/tp:TraderIdentityType"/>
                    </p>
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdTraderIdentityNumber"/>
                      <xsl:value-of select="p:GoodsSender/tp:TraderInfo/tp:TraderIdentityNumber"/>
                    </p>
                  </div>
                  <div class="rmpd-xslt info1">
                    <p>
                      <span class="rmpd-xslt element-2" data-phrase-id="rmpdAdress"/>
                    </p>
                    <xsl:variable name="ulica">
                      <xsl:choose>
                        <xsl:when test="p:GoodsSender/tp:TraderAddress/tp:FlatNumber != ''">
                          <p>
                            <xsl:value-of select="p:GoodsSender/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="p:GoodsSender/tp:TraderAddress/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of
                            select="p:GoodsSender/tp:TraderAddress/tp:FlatNumber"/>
                          </p>
                        </xsl:when>
                        <xsl:otherwise>
                          <p>
                            <xsl:value-of select="p:GoodsSender/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="p:GoodsSender/tp:TraderAddress/tp:HouseNumber"/>
                          </p>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:variable>
                    <p>
                      <xsl:value-of select="$ulica"/>
                    </p>
                    <p>
                      <xsl:value-of select="p:GoodsSender/tp:TraderAddress/tp:PostalCode"/><xsl:text>&#160;</xsl:text>
                      <xsl:value-of select="p:GoodsSender/tp:TraderAddress/tp:City"/>
                      <xsl:if test="p:GoodsSender/tp:TraderAddress/tp:City != ''">,</xsl:if>
                      <xsl:text>&#160;</xsl:text><xsl:value-of select="p:GoodsSender/tp:TraderAddress/tp:Country"/>
                    </p>
                  </div>
                </div>
              </div>
            </xsl:if>
            <xsl:if test="p:GoodsRecipient/tp:TraderInfo != ''">
              <div class="rmpd-xslt t1">
                <p class="rmpd-xslt rmpdheader0" data-phrase-id="rmpdGoodsRecipientInfo"/>
                <div class="rmpd-xslt grupInfo">
                  <div class="rmpd-xslt info1">
                    <xsl:if test="p:GoodsRecipient/tp:TraderInfo/tp:IdSisc !=''">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdIdSisc"/>
                        <xsl:value-of select="p:GoodsRecipient/tp:TraderInfo/tp:IdSisc"/>
                      </p>
                    </xsl:if>
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdTraderName"/>
                      <xsl:value-of select="p:GoodsRecipient/tp:TraderInfo/tp:TraderName"/>
                    </p>
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdTraderIdentityType"/>
                      <xsl:value-of select="p:GoodsRecipient/tp:TraderInfo/tp:TraderIdentityType"/>
                    </p>
                    <p>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdTraderIdentityNumber"/>
                      <xsl:value-of select="p:GoodsRecipient/tp:TraderInfo/tp:TraderIdentityNumber"/>
                    </p>
                  </div>
                  <div class="rmpd-xslt info1">
                    <p>
                      <span class="rmpd-xslt element-2" data-phrase-id="rmpdAdress"/>
                    </p>
                    <xsl:variable name="ulica">
                      <xsl:choose>
                        <xsl:when test="p:GoodsRecipient/tp:TraderAddress/tp:FlatNumber != ''">
                          <p>
                            <xsl:value-of select="p:GoodsRecipient/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="p:GoodsRecipient/tp:TraderAddress/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of
                            select="p:GoodsRecipient/tp:TraderAddress/tp:FlatNumber"/>
                          </p>
                        </xsl:when>
                        <xsl:otherwise>
                          <p>
                            <xsl:value-of select="p:GoodsRecipient/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="p:GoodsRecipient/tp:TraderAddress/tp:HouseNumber"/>
                          </p>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:variable>
                    <p>
                      <xsl:value-of select="$ulica"/>
                    </p>
                    <p>
                      <xsl:value-of select="p:GoodsRecipient/tp:TraderAddress/tp:PostalCode"/><xsl:text>&#160;</xsl:text>
                      <xsl:value-of select="p:GoodsRecipient/tp:TraderAddress/tp:City"/>
                      <xsl:if test="p:GoodsRecipient/tp:TraderAddress/tp:City != ''">,</xsl:if>
                      <xsl:text>&#160;</xsl:text><xsl:value-of select="p:GoodsRecipient/tp:TraderAddress/tp:Country"/>
                    </p>
                  </div>
                </div>
              </div>
            </xsl:if>
            <xsl:if test="p:PermissionInfo != ''">
              <xsl:if test="p:PermissionInfo/tp:StartTransportDate != ''">
                <div class="rmpd-xslt t1">
                  <p class="rmpd-xslt rmpdheader0" data-phrase-id="rmpdPermissionInfo"/>
                  <div class="rmpd-xslt grupInfo">
                    <div class="rmpd-xslt info1">
                      <xsl:if test="p:PermissionInfo/tp:StartTransportDate != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdStartTransportDate"/>
                          <xsl:choose>
                            <xsl:when test="string-length(p:PermissionInfo/tp:StartTransportDate) > 10">
                              <xsl:value-of select="substring(p:PermissionInfo/tp:StartTransportDate,1,10)"/>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="p:PermissionInfo/tp:StartTransportDate"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:EndTransportDate != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdEndTransportDate"/>
                          <xsl:choose>
                            <xsl:when test="string-length(p:PermissionInfo/tp:EndTransportDate) > 10">
                              <xsl:value-of select="substring(p:PermissionInfo/tp:EndTransportDate,1,10)"/>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="p:PermissionInfo/tp:EndTransportDate"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:CountryLoadCode != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdCountryLoadCode"/>
                          <xsl:value-of select="p:PermissionInfo/tp:CountryLoadCode"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:CountryUnloadCode != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdCountryUnloadCode"/>
                          <xsl:value-of select="p:PermissionInfo/tp:CountryUnloadCode"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:Loaded != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdLoaded"/>
                          <span>
                            <xsl:choose>
                              <xsl:when test="p:PermissionInfo/tp:Loaded = 'true'">
                                <span data-phrase-id="rmpdLoadedYes"/>
                              </xsl:when>
                              <xsl:when test="p:PermissionInfo/tp:Loaded = 'false'">
                                <span data-phrase-id="rmpdLoadedNo"/>
                              </xsl:when>
                            </xsl:choose>
                          </span>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:TransportDocuments/tp:TypeOfTransportDocument != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdTypeOfTransportDocument"/>
                          <xsl:value-of select="p:PermissionInfo/tp:TransportDocuments/tp:TypeOfTransportDocument"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:TransportDocuments/tp:NumberOfTransportDocument != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdNumberOfTransportDocument"/>
                          <xsl:value-of select="p:PermissionInfo/tp:TransportDocuments/tp:NumberOfTransportDocument"/>
                        </p>
                      </xsl:if>
                    </div>
                    <div class="rmpd-xslt info1">
                      <xsl:if test="p:PermissionInfo/tp:TypeOfRoadTransport != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdTypeOfRoadTransport"/>
                          <span>
                            <xsl:choose>
                              <xsl:when test="p:PermissionInfo/tp:TypeOfRoadTransport = 'BILATERAL_TRANSPORT'">
                                <span data-phrase-id="rmpdTypeOfRoadTransport1"/>
                              </xsl:when>
                              <xsl:when test="p:PermissionInfo/tp:TypeOfRoadTransport = 'TRANSIT_TRANSPORT'">
                                <span data-phrase-id="rmpdTypeOfRoadTransport2"/>
                              </xsl:when>
                              <xsl:when test="p:PermissionInfo/tp:TypeOfRoadTransport = 'THIRD_COUNTRY_TRANSPORT'">
                                <span data-phrase-id="rmpdTypeOfRoadTransport3"/>
                              </xsl:when>
                              <xsl:when test="p:PermissionInfo/tp:TypeOfRoadTransport = 'CABOTAGE'">
                                <span data-phrase-id="rmpdTypeOfRoadTransport4"/>
                              </xsl:when>
                            </xsl:choose>
                          </span>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:TypeOfPermission != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdTypeOfPermission"/>
                          <span>
                            <xsl:choose>
                              <xsl:when test="p:PermissionInfo/tp:TypeOfPermission = 'ROAD_PERMISSION'">
                                <span data-phrase-id="rmpdTypeOfPermission1"/>
                              </xsl:when>
                              <xsl:when test="p:PermissionInfo/tp:TypeOfPermission = 'EKMT_PERMISSION'">
                                <span data-phrase-id="rmpdTypeOfPermission2"/>
                              </xsl:when>
                              <xsl:when test="p:PermissionInfo/tp:TypeOfPermission = 'CABOTAGE'">
                                <span data-phrase-id="rmpdTypeOfPermission3"/>
                              </xsl:when>
                              <xsl:when test="p:PermissionInfo/tp:TypeOfPermission = 'NOT_OBLIGED'">
                                <span data-phrase-id="rmpdTypeOfPermission4"/>
                              </xsl:when>
                            </xsl:choose>
                          </span>
                        </p>
                      </xsl:if>
                      <div id="pl" style="display:block;">
                        <xsl:if test="p:PermissionInfo/tp:NotObligedLegalBasePl != ''">
                          <p>
                            <span class="rmpd-xslt element-1" data-phrase-id="rmpdNotObligedLegalBasePl"/>
                            <xsl:value-of select="p:PermissionInfo/tp:NotObligedLegalBasePl"/>
                          </p>
                        </xsl:if>
                        <xsl:if test="p:PermissionInfo/tp:NotObligedLegalBaseDescriptionPl != ''">
                          <p>
                            <span class="rmpd-xslt element-1" data-phrase-id="rmpdNotObligedLegalBaseDescriptionPl"/>
                            <xsl:value-of select="p:PermissionInfo/tp:NotObligedLegalBaseDescriptionPl"/>
                          </p>
                        </xsl:if>
                      </div>
                      <div id="en" style="display:none;">
                        <xsl:if test="p:PermissionInfo/tp:NotObligedLegalBaseEn != ''">
                          <p>
                            <span class="rmpd-xslt element-1" data-phrase-id="rmpdNotObligedLegalBaseEn"/>
                            <xsl:value-of select="p:PermissionInfo/tp:NotObligedLegalBaseEn"/>
                          </p>
                        </xsl:if>
                        <xsl:if test="p:PermissionInfo/tp:NotObligedLegalBaseDescriptionEn != ''">
                          <p>
                            <span class="rmpd-xslt element-1" data-phrase-id="rmpdNotObligedLegalBaseDescriptionEn"/>
                            <xsl:value-of select="p:PermissionInfo/tp:NotObligedLegalBaseDescriptionEn"/>
                          </p>
                        </xsl:if>
                      </div>
                      <xsl:if test="p:PermissionInfo/tp:PreviousRmpdNumber != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdPreviousRmpdNumber"/>
                          <xsl:value-of select="p:PermissionInfo/tp:PreviousRmpdNumber"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:JourneyDirection != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdJourneyDirection"/>
                          <span>
                            <xsl:choose>
                              <xsl:when test="p:PermissionInfo/tp:JourneyDirection = '1'">
                                <span data-phrase-id="rmpdJourneyDirection1"/>
                              </xsl:when>
                              <xsl:when test="p:PermissionInfo/tp:JourneyDirection = '2'">
                                <span data-phrase-id="rmpdJourneyDirection2"/>
                              </xsl:when>
                            </xsl:choose>
                          </span>
                        </p>
                      </xsl:if>
                    </div>
                  </div>
                </div>
              </xsl:if>
              <xsl:if test="p:PermissionInfo/tp:PermissionHeader != ''">
                <div class="rmpd-xslt t1">
                  <p class="rmpd-xslt rmpdheader0" data-phrase-id="rmpdPermissionHeader"/>
                  <div class="rmpd-xslt grupInfo">
                    <div class="rmpd-xslt info1">
                      <xsl:if test="p:PermissionInfo/tp:PermissionHeader/tp:PermissionNumber != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdPermissionNumber"/>
                          <xsl:value-of select="p:PermissionInfo/tp:PermissionHeader/tp:PermissionNumber"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:PermissionHeader/tp:PermissionCountry != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdPermissionCountry"/>
                          <xsl:value-of select="p:PermissionInfo/tp:PermissionHeader/tp:PermissionCountry"/>
                        </p>
                      </xsl:if>
                    </div>
                    <div class="rmpd-xslt info1">
                      <xsl:if test="p:PermissionInfo/tp:PermissionHeader/tp:ValidFrom != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdValidFrom"/>
                          <xsl:choose>
                            <xsl:when test="string-length(p:PermissionInfo/tp:PermissionHeader/tp:ValidFrom) > 10">
                              <xsl:value-of select="substring(p:PermissionInfo/tp:PermissionHeader/tp:ValidFrom,1,10)"/>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="p:PermissionInfo/tp:PermissionHeader/tp:ValidFrom"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:PermissionHeader/tp:ValidTo != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdValidTo"/>
                          <xsl:choose>
                            <xsl:when test="string-length(p:PermissionInfo/tp:PermissionHeader/tp:ValidTo) > 10">
                              <xsl:value-of select="substring(p:PermissionInfo/tp:PermissionHeader/tp:ValidTo,1,10)"/>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="p:PermissionInfo/tp:PermissionHeader/tp:ValidTo"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </p>
                      </xsl:if>
                    </div>
                  </div>
                </div>
              </xsl:if>
              <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL != ''">
                <div class="rmpd-xslt t1">
                  <p class="rmpd-xslt rmpdheader0" data-phrase-id="rmpdStartEndPlaceJourney"/>
                  <p class="rmpd-xslt rmpdheader" data-phrase-id="rmpdStartInsidePL"/>
                  <div class="rmpd-xslt grupInfo">
                    <div class="rmpd-xslt info1">
                      <xsl:variable name="ulica">
                        <xsl:choose>
                          <xsl:when test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:FlatNumber != ''">
                            <p>
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:Street"/>
                              <xsl:text>&#160;</xsl:text> <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of
                              select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:FlatNumber"/>
                            </p>
                          </xsl:when>
                          <xsl:otherwise>
                            <p>
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:Street"/>
                              <xsl:text>&#160;</xsl:text>
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:HouseNumber"/>
                            </p>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:variable>
                      <p>
                        <xsl:value-of select="$ulica"/>
                      </p>
                      <p>
                        <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:PostalCode"/>
                        <xsl:text>&#160;</xsl:text> <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:City"/>,<xsl:text>&#160;</xsl:text>
                        <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:Country"/>
                      </p>
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdProvince"/>
                          <xsl:choose>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '02'">dolnośląskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '04'">kujawsko-pomorskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '06'">lubelskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '08'">lubuskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '10'">łódzkie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '12'">małopolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '14'">mazowieckie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '16'">opolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '18'">podkarpackie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '20'">podlaskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '22'">pomorskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '24'">śląskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '26'">świętokrzyskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '28'">warmińsko-mazurskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '30'">wielkopolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC, 1,2) = '32'">zachodniopomorskie</xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </p>
                      </xsl:if>
                    </div>
                    <div class="rmpd-xslt info1">
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdTercId"/>
                          <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeTERC"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeSIMC != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdSimcId"/>
                          <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeSIMC"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeULIC != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdUlicId"/>
                          <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:CodeULIC"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:Latitude != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdLatitudeLongitude"/>
                          <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:Latitude"/>,
                          <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:StartInsidePL/tp:Longitude"/>
                        </p>
                      </xsl:if>
                    </div>
                  </div>
                </div>
              </xsl:if>
              <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL != ''">
                <div class="rmpd-xslt t1">
                  <p class="rmpd-xslt rmpdheader" data-phrase-id="rmpdEndInsidePL"/>
                  <div class="rmpd-xslt grupInfo">
                    <div class="rmpd-xslt info1">
                      <xsl:variable name="ulica">
                        <xsl:choose>
                          <xsl:when test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:FlatNumber != ''">
                            <p>
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:Street"/><xsl:text>&#160;</xsl:text>
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:HouseNumber"/>&#160;/&#160;
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:FlatNumber"/>
                            </p>
                          </xsl:when>
                          <xsl:otherwise>
                            <p>
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:Street"/><xsl:text>&#160;</xsl:text>
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:HouseNumber"/>
                            </p>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:variable>
                      <p>
                        <xsl:value-of select="$ulica"/>
                      </p>
                      <p>
                        <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:PostalCode"/><xsl:text>&#160;</xsl:text> <xsl:value-of
                        select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:City"/>,<xsl:text>&#160;</xsl:text><xsl:value-of
                        select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:Country"/>
                      </p>
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdProvince"/>
                          <xsl:choose>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '02'">dolnośląskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '04'">kujawsko-pomorskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '06'">lubelskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '08'">lubuskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '10'">łódzkie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '12'">małopolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '14'">mazowieckie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '16'">opolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '18'">podkarpackie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '20'">podlaskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '22'">pomorskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '24'">śląskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '26'">świętokrzyskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '28'">warmińsko-mazurskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '30'">wielkopolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC, 1,2) = '32'">zachodniopomorskie</xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </p>
                      </xsl:if>
                    </div>
                    <div class="rmpd-xslt info1">
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdTercId"/>
                          <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeTERC"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeSIMC != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdSimcId"/>
                          <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeSIMC"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeULIC != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdUlicId"/>
                          <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:CodeULIC"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:Latitude != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdLatitudeLongitude"/>
                          <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:Latitude"/>,
                          <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EndInsidePL/tp:Longitude"/>
                        </p>
                      </xsl:if>
                    </div>
                  </div>
                </div>
              </xsl:if>
              <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:RoutePlace != ''">
                <div class="rmpd-xslt t1">
                  <p class="rmpd-xslt rmpdheader" data-phrase-id="rmpdEntranceToPoland"/>
                  <div class="rmpd-xslt grupInfo">
                    <div class="rmpd-xslt info1">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdRoutePlace"/>
                        <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:RoutePlace"/>
                      </p>
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdProvince"/>
                          <xsl:choose>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '02'">dolnośląskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '04'">kujawsko-pomorskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '06'">lubelskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '08'">lubuskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '10'">łódzkie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '12'">małopolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '14'">mazowieckie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '16'">opolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '18'">podkarpackie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '20'">podlaskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '22'">pomorskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '24'">śląskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '26'">świętokrzyskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '28'">warmińsko-mazurskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '30'">wielkopolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '32'">zachodniopomorskie</xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </p>
                      </xsl:if>
                    </div>
                    <div class="rmpd-xslt info1">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdRouteNumber"/>
                        <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:RouteNumber"/>
                      </p>
                    </div>
                  </div>
                </div>
              </xsl:if>
              <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:OtherPlace != ''">
                <div class="rmpd-xslt t1">
                  <p class="rmpd-xslt rmpdheader" data-phrase-id="rmpdEntranceToPoland"/>
                  <div class="rmpd-xslt grupInfo">
                    <div class="rmpd-xslt info1">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdOtherPlace"/>
                        <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:OtherPlace"/>
                      </p>
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdProvince"/>
                          <xsl:choose>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '02'">dolnośląskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '04'">kujawsko-pomorskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '06'">lubelskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '08'">lubuskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '10'">łódzkie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '12'">małopolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '14'">mazowieckie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '16'">opolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '18'">podkarpackie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '20'">podlaskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '22'">pomorskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '24'">śląskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '26'">świętokrzyskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '28'">warmińsko-mazurskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '30'">wielkopolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province, 1,2) = '32'">zachodniopomorskie</xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Province"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </p>
                      </xsl:if>
                    </div>
                    <div class="rmpd-xslt info1">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdLatitude"/>
                        <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Latitude"/>
                      </p>
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdLongitude"/>
                        <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:EntranceToPoland/tp:Longitude"/>
                      </p>
                    </div>
                  </div>
                </div>
              </xsl:if>
              <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:RoutePlace != ''">
                <div class="rmpd-xslt t1">
                  <p class="rmpd-xslt rmpdheader" data-phrase-id="rmpdExitFromPoland"/>
                  <div class="rmpd-xslt grupInfo">
                    <div class="rmpd-xslt info1">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdRoutePlace"/>
                        <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:RoutePlace"/>
                      </p>
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdProvince"/>
                          <xsl:choose>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '02'">dolnośląskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '04'">kujawsko-pomorskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '06'">lubelskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '08'">lubuskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '10'">łódzkie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '12'">małopolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '14'">mazowieckie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '16'">opolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '18'">podkarpackie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '20'">podlaskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '22'">pomorskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '24'">śląskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '26'">świętokrzyskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '28'">warmińsko-mazurskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '30'">wielkopolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '32'">zachodniopomorskie</xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </p>
                      </xsl:if>
                    </div>
                    <div class="rmpd-xslt info1">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdRouteNumber"/>
                        <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:RouteNumber"/>
                      </p>
                    </div>
                  </div>
                </div>
              </xsl:if>
              <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:OtherPlace != ''">
                <div class="rmpd-xslt t1">
                  <p class="rmpd-xslt rmpdheader" data-phrase-id="rmpdExitFromPoland"/>
                  <div class="rmpd-xslt grupInfo">
                    <div class="rmpd-xslt info1">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdOtherPlace"/>
                        <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:OtherPlace"/>
                      </p>
                      <xsl:if test="p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdProvince"/>
                          <xsl:choose>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '02'">dolnośląskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '04'">kujawsko-pomorskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '06'">lubelskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '08'">lubuskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '10'">łódzkie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '12'">małopolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '14'">mazowieckie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '16'">opolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '18'">podkarpackie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '20'">podlaskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '22'">pomorskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '24'">śląskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '26'">świętokrzyskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '28'">warmińsko-mazurskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '30'">wielkopolskie</xsl:when>
                            <xsl:when test="substring(p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province, 1,2) = '32'">zachodniopomorskie</xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Province"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </p>
                      </xsl:if>
                    </div>
                    <div class="rmpd-xslt info1">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdLatitude"/>
                        <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Latitude"/>
                      </p>
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdLongitude"/>
                        <xsl:value-of select="p:PermissionInfo/tp:StartEndPlaceJourney/tp:ExitFromPoland/tp:Longitude"/>
                      </p>
                    </div>
                  </div>
                </div>
              </xsl:if>
            </xsl:if>
            <xsl:if test="p:MeansOfTransport != ''">
              <div class="rmpd-xslt t1">
                <p class="rmpd-xslt rmpdheader0" data-phrase-id="rmpdTransportMean"/>
                <div class="rmpd-xslt t1">
                  <div class="rmpd-xslt grupInfo">
                    <div class="rmpd-xslt info1">
                      <xsl:if test="p:MeansOfTransport/tp:TruckCountry != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdTruckCountry"/>
                          <xsl:value-of select="p:MeansOfTransport/tp:TruckCountry"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:MeansOfTransport/tp:TruckNumber != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdTruckNumber"/>
                          <xsl:value-of select="p:MeansOfTransport/tp:TruckNumber"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:MeansOfTransport/tp:TrailerCountry != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdTrailerCountry"/>
                          <xsl:value-of select="p:MeansOfTransport/tp:TrailerCountry"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:MeansOfTransport/tp:TrailerNumber != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdTrailerNumber"/>
                          <xsl:value-of select="p:MeansOfTransport/tp:TrailerNumber"/>
                        </p>
                      </xsl:if>
                    </div>
                    <div class="rmpd-xslt info1">
                      <xsl:if test="p:MeansOfTransport/tp:GeoLocatorNumber != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdLocatorNumber"/>
                          <xsl:value-of select="p:MeansOfTransport/tp:GeoLocatorNumber"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:MeansOfTransport/tp:FailoverGeoLocatorNumber != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdFailoverGeoLocatorNumber"/>
                          <xsl:value-of select="p:MeansOfTransport/tp:FailoverGeoLocatorNumber"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:MeansOfTransport/tp:FailoverCarrierEmail != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdFailoverCarrierEmail"/>
                          <xsl:value-of select="p:MeansOfTransport/tp:FailoverCarrierEmail"/>
                        </p>
                      </xsl:if>
                      <xsl:if test="p:MeansOfTransport/tp:NotificationSMSPhone != ''">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdNotificationSMSPhone"/>
                          <xsl:value-of select="p:MeansOfTransport/tp:NotificationSMSPhone"/>
                        </p>
                      </xsl:if>
                    </div>
                  </div>
                </div>
              </div>
            </xsl:if>
            <xsl:if test="((p:Comments != '') or (p:DocumentId != ''))">
              <div class="rmpd-xslt t1">
                <p class="rmpd-xslt rmpdheader0" data-phrase-id="rmpdAdditionalInfo"/>
                <xsl:if test="p:Comments != ''">
                  <div class="rmpd-xslt t1">
                    <div class="rmpd-xslt grupInfo">
                      <div class="rmpd-xslt info">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdComments"/>
                          <xsl:value-of select="p:Comments"/>
                        </p>
                      </div>
                    </div>
                  </div>
                </xsl:if>
                <xsl:if test="p:DocumentId != ''">
                  <div class="rmpd-xslt t1">
                    <div class="rmpd-xslt grupInfo">
                      <div class="rmpd-xslt info">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdSourceDocumentID"/>
                          <xsl:value-of select="p:DocumentId"/>
                        </p>
                      </div>
                    </div>
                  </div>
                </xsl:if>
              </div>
            </xsl:if>
          </section>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
