<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:p="http://www.mf.gov.pl/RMPD/2024/03/18/RMPD_104.xsd" xmlns:tp="http://www.mf.gov.pl/RMPD/2024/03/18/PTypes.xsd" version="2.0">
  <xsl:template match="p:RMPD_104">
    <html>
      <head>
        <script>
          //<![CDATA[
					// Module
				var languative;
				(function (languative) {
				    var phraseIdAttr = "data-phrase-id";

				    languative.ignoreTags = {
				        img: "<img />",
				        br: "<br />",
				        hr: "<hr />"
				    };

				    languative.dictonaries = {
				        html: {
				            _id: "en",
				            _name: "English"
				        },

				        pl: {
				            _id: "pl",
				            _name: "Polski - Polish"
				        },

				        en: {
				            _id: "en",
				            _name: "English"
				        }
				    };

				    languative.selectedDictionary = null;

				    function getDictionary(langKey) {
				        langKey = langKey.toLowerCase();
				        if (langKey in languative.dictonaries)
				            return languative.dictonaries[langKey];
				            else
				            return languative.dictonaries["pl"];

				        // Dictionary at key "pl-PL" not found, so keep looking for key "pl"
				        var sep = langKey.indexOf("-");
				        if (sep > 0)
				            langKey = langKey.substring(0, sep);
				        return languative.dictonaries[langKey];
				    }
				    languative.getDictionary = getDictionary;

				    function getPhrase(phraseId) {
				        var res = findPhrase(phraseId);
				        if (res)
				            return res; else
				            return phraseId;
				    }
				    languative.getPhrase = getPhrase;

				    function findPhrase(phraseId) {
				        if ((phraseId == null) || (phraseId == ""))
				            return null;

				        if ((languative.selectedDictionary != null) && (phraseId in languative.selectedDictionary))
				            return languative.selectedDictionary[phraseId];
				        if (phraseId in languative.dictonaries.html)
				            return languative.dictonaries.html[phraseId];

				        return null;
				    }
				    languative.findPhrase = findPhrase;

				    function getYesNo(value) {
				        if (value === undefined)
				            return getPhrase("undefined"); else if (value)
				            return getPhrase("yes"); else
				            return getPhrase("no");
				    }
				    languative.getYesNo = getYesNo;

				    //IE8 Tweak
				    function getAttr(node, attr) {
				        var result = (node.getAttribute && node.getAttribute(attr)) || null;
				        if (!result && node.attributes) {
				            for (var i = 0; i < node.attributes.length; i++) {
				                var attrNode = node.attributes[i];
				                if (attrNode.nodeName === attr)
				                    return attrNode.nodeValue;
				            }
				        }
				        return result;
				    }

				    function changeLanguage(langKey) {
				        function setTagPhrase(tag, phrase) {
				            if (tag.childNodes.length > 1) {
				                for (var ci = 0; ci < tag.childNodes.length; ci++) {
				                    var chNode = tag.childNodes[ci];
				                    var nName = chNode.nodeName.toLowerCase();
				                    if (!(nName in languative.ignoreTags)) {
				                        if ("innerHTML" in chNode) {
				                            chNode["innerHTML"] = " " + phrase[ci] + " ";
				                        } else {
				                            chNode.nodeValue = " " + phrase[ci] + " ";
				                        }
				                    }
				                }
				            } else {
				                tag.innerHTML = " " + phrase + " ";
				            }
				        }

				        //return;
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            console.warn("Cannot identify dictionary by key '" + langKey + "'. Default dictionary (" + languative.dictonaries.html._id + ": " + languative.dictonaries.html._name + ") used instead.");
				            langDict = languative.dictonaries.html;
				        }
				        languative.selectedDictionary = langDict;

				        var tags = getHtmlTags();
				        for (var ti = 0; ti < tags.length; ti++) {
				            var tag = tags[ti];
				            var phraseId = getAttr(tag, phraseIdAttr);
				            if ((phraseId != null)) {
				                var phraseValue = languative.getPhrase(phraseId);
				                if (phraseValue) {
				                    setTagPhrase(tag, phraseValue);
				                } else {
				                    console.warn("Phrase not definied in dictionary: data-phrase-id='" + phraseId + "'");
				                }
				            }
				        }

				        if (langDict["Title"] != null) {
				            document.title = langDict["Title"];
				        }
				    }
				    languative.changeLanguage = changeLanguage;

				    function getHtmlTags() {
				        var res = new Array();
				        var docTags = document.body.getElementsByTagName("*");

				        for (var i = 0; i < docTags.length; i++) {
				            var docTag = docTags[i];
				            var phraseId = getAttr(docTag, phraseIdAttr);
				            if (phraseId)
				                res.push(docTag);
				        }
				        return res;
				    }

				    var initialized = false;

				    function init() {
				        if (!initialized) {
				            initialized = true;
				            var htmlDict = languative.dictonaries.en;

				            for (var dictKey in htmlDict) {
				                if (!(dictKey in languative.dictonaries.html)) {
				                    languative.dictonaries.html[dictKey] = htmlDict[dictKey];
				                }
				            }
				            var nav = window.navigator;
				            languative.changeLanguage(nav.userLanguage || nav.language);
				        }
				    }
				    languative.init = init;

				    function modifyDictionary(langKey, dictModifications) {
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            languative.dictonaries[langKey.toLowerCase()] = dictModifications;
				        } else {
				            for (var dictKey in dictModifications) {
				                langDict[dictKey] = dictModifications[dictKey];
				            }
				        }
				    }
				    languative.modifyDictionary = modifyDictionary;
				})(languative || (languative = {}));

				if (document.addEventListener)
				    document.addEventListener('DOMContentLoaded', languative.init);

				if (window.addEventListener) {
				    window.addEventListener('load', languative.init, false);
				} else {
				    window.attachEvent('onload', languative.init);
				}
				<!-- sourceMappingURL=languative.js.map -->

				languative.modifyDictionary("html", {
            		githubLink: "Fork me on GitHub"
        		});
languative.modifyDictionary("pl", {
english: "English",
polish: "Polski",
selectLanguage: "Wybierz język:",
rmpd100: "RMPD_100 - REJESTRACJA PRZEWOZU PRZEZ PRZEWOŹNIKA",
rmpd101: "RMPD_101 - EDYCJA ZGŁOSZENIA PRZEWOZU PRZEZ PRZEWOŹNIKA",
rmpd104: "RMPD_104 - ANULOWANIE ZGŁOSZENIA PRZEWOZU",
rmpdAdditionalInfo: "Informacje dodatkowe",
rmpdAdress: "Adres:",
rmpdAdresses: "Kanały komunikacji zwrotnej",
rmpdAuthenticationKey: "Odcisk palca certyfikatu:",
rmpdCancelOfTransport: "Informacja o anulowaniu zgłoszenia przewozu",
rmpdCancelComments: "Powód anulowania zgłoszenia:",
rmpdCarrierKey: "Klucz przewoźnika:",
rmpdComments: "Uwagi do zgłoszenia:",
rmpdCountryLoadCode: "Informacje o państwie załadunku towaru:",
rmpdCountryUnloadCode: "Informacje o państwie rozładunku:",
rmpdEmail: "Adresy e-mail:",
rmpdEndInsidePL: "Miejsce zakończenia przejazdu",
rmpdEndTransportDate: "Data zakończenia przewozu towaru:",
rmpdEntranceToPoland: "Miejsce wjazdu na terytorium Polski",
rmpdExitFromPoland: "Miejsce wyjazdu poza terytorium Polski",
rmpdFailoverCarrierEmail: "E-mail przewoźnika:",
rmpdFailoverGeoLocatorNumber: "Numer zapasowego lokalizatora GPS:",
rmpdGoodsCarrierInfo: "Informacje o przewoźniku",
rmpdGoodsRecipientInfo: "Informacje o odbiorcy",
rmpdGoodsSenderInfo: "Informacje o nadawcy",
rmpdIdSisc: "Identyfikator idSISC:",
rmpdLoaded: "Informacja o ładunku:",
rmpdLoadedNo: "Bez ładunku",
rmpdLoadedYes: "Z ładunkiem",
rmpdJourneyDirection: "Kierunek przejazdu:",
rmpdJourneyDirection1: "Pierwszy przejazd zgodnie ze wzorem zezwolenia",
rmpdJourneyDirection2: "Przejazd powrotny zgodnie ze wzorem zezwolenia",
rmpdLatitude: "Szerokość geograficzna:",
rmpdLatitudeLongitude: "Szerokość i długość geograficzna:",
rmpdLocatorNumber: "Numer urządzenia/lokalizatora GPS:",
rmpdLongitude: "Długość geograficzna:",
rmpdNotificationSMSPhone: "Telefon do powiadomień SMS:",
rmpdNotObligedLegalBase: "Podstawa zwolnienia z obowiązku posiadania zezwolenia:",
rmpdNumberOfTransportDocument: "Numer dokumentu przewozu:",
rmpdOtherPlace: "Inne miejsce:",
rmpdPassword: "Hasło:",
rmpdPermissionCountry: "Kraj zezwolenia:",
rmpdPermissionHeader: "Dane zezwolenia",
rmpdPermissionInfo: "Informacje o transporcie towarów",
rmpdPermissionNumber: "Numer zezwolenia:",
rmpdPreviousRmpdNumber: "Poprzedni RmpdNumber:",
rmpdProvince: "Województwo:",
rmpdRouteNumber: "Numer drogi:",
rmpdRoutePlace: "Miejsce przekroczenia granicy:",
rmpdSimcId: "Identyfikator miejscowości:",
rmpdSourceDocumentID: "Numer własny zgłoszenia:",
rmpdStartEndPlaceJourney: "Miejsce rozpoczęcia i zakończenia przejazdu",
rmpdStartInsidePL: "Miejsce rozpoczęcia przejazdu",
rmpdStartTransportDate: "Data rozpoczęcia przewozu towaru:",
rmpdStatements: "Oświadczenia",
rmpdStatements1: "Oświadczam, że posiadam upoważnienie do złożenia niniejszego zgłoszenia w imieniu i na rzecz podmiotu zobowiązanego",
rmpdStatementsFullName: "Imię i nazwisko:",
rmpdStatus0: "Zarejestrowane",
rmpdStatus1: "Niekompletne",
rmpdStatus2: "Kompletne",
rmpdStatus3: "Zamknięte",
rmpdStatus4: "Anulowane",
rmpdStatus5: "Zamknięte automatycznie",
rmpdStatusNo: "Nie",
rmpdStatusYes: "Tak",
rmpdTercId: "Identyfikator terytorialny:",
rmpdTraderIdentityNumber: "Numer identyfikatora:",
rmpdTraderIdentityType: "Rodzaj identyfikatora:",
rmpdTraderName: "Pełna nazwa:",
rmpdTrailerCountry: "Kraj naczepy/przyczepy:",
rmpdTrailerNumber: "Numer rejestracyjny naczepy:",
rmpdTransportMean: "Informacje o środku transportu",
rmpdTruckCountry: "Kraj pojazdu:",
rmpdTruckNumber: "Numer rejestracyjny ciągnika:",
rmpdTruckNumber: "Numer rejestracyjny pojazdu:",
rmpdTypeOfPermission: "Wybór typu zezwolenia lub zwolnienia z obowiązku posiadania zezwolenia:",
rmpdTypeOfPermission1: "Blankiet jednorazowy",
rmpdTypeOfPermission2: "Zezwolenie EKMT",
rmpdTypeOfPermission3: "Kabotażowe",
rmpdTypeOfPermission4: "Zwolnienie z obowiązku posiadania zezwolenia",
rmpdTypeOfRoadTransport: "Typ realizowanego przejazdu:",
rmpdTypeOfRoadTransport1: "Transport bilateralny",
rmpdTypeOfRoadTransport2: "Transport tranzytowy",
rmpdTypeOfRoadTransport3: "Transport kraje trzecie",
rmpdTypeOfRoadTransport4: "Kabotaż",
rmpdTypeOfTransportDocument: "Typ dokumentu przewozu:",
rmpdUlicId: "Identyfikator ulic:",
rmpdURL: "Adres URL:",
rmpdUserName: "Nazwa użytkownika:",
rmpdValidFrom: "Ważne od:",
rmpdValidTo: "Ważne do:",
rmpdWebservice: "Kanał Web service:",
rmpdWS: "Adres Web service zapisany w usłudze e-Klient:"
});

languative.modifyDictionary("en", {
english: "English",
polish: "Polski",
selectLanguage: "Select language:",
rmpd100: "RMPD_100 - REGISTRATION OF THE NOTIFICATION OF THE CARRIAGE OF GOODS",
rmpd101: "RMPD_101 - UPDATE OF THE NOTIFICATION OF THE CARRIAGE",
rmpd104: "RMPD_104 - CANCELATION OF THE NOTIFICATION OF THE CARRIAGE",
rmpdAdditionalInfo: "Additional information",
rmpdAdress: "Address:",
rmpdAdresses: "Feedback communication channel",
rmpdAuthenticationKey: "Fingerprint of certificate:",
rmpdCancelOfTransport: "Information on cancelling the notification of the carriage",
rmpdCancelComments: "Reason for cancellation the notification:",
rmpdCarrierKey: "Carrier Key:",
rmpdComments: "Comments to the notification:",
rmpdCountryLoadCode: "Information on the load country:",
rmpdCountryUnloadCode: "Information on the unload country:",
rmpdEmail: "E-mail addresses:",
rmpdEndInsidePL: "Place of end of the journey",
rmpdEndTransportDate: "End date of the carriage of goods:",
rmpdEntranceToPoland: "Place of entrance to Poland",
rmpdExitFromPoland: "Place of exit from Poland",
rmpdFailoverCarrierEmail: "The carrier's e-mail",
rmpdFailoverGeoLocatorNumber: "Backup GPS device number",
rmpdGoodsCarrierInfo: "Information on the carrier",
rmpdGoodsRecipientInfo: "Information on the recipient",
rmpdGoodsSenderInfo: "Information on the sender",
rmpdIdSisc: "idSISC identification number:",
rmpdLoaded: "Information about transported goods:",
rmpdLoadedNo: "Without goods",
rmpdLoadedYes: "With goods",
rmpdJourneyDirection: "Journey direction:",
rmpdJourneyDirection1: "First journey in accordance with the permit template",
rmpdJourneyDirection2: "Return journey in accordance with the permit template",
rmpdLatitude: "Latitude:",
rmpdLatitudeLongitude: "Latitude and Longitude:",
rmpdLocatorNumber: "GPS locator number:",
rmpdLongitude: "Longitude:",
rmpdNotificationSMSPhone: "SMS notification phone number:",
rmpdNotObligedLegalBase: "Basis for exemption from the obligation to have a permit:",
rmpdNumberOfTransportDocument: "Transport document number:",
rmpdOtherPlace: "Other place:",
rmpdPassword: "Password:",
rmpdPermissionCountry: "Permission Country:",
rmpdPermissionHeader: "Permission info",
rmpdPermissionInfo: "Information on the transport of goods",
rmpdPermissionNumber: "Permission Number:",
rmpdPreviousRmpdNumber: "Previous RmpdNumber:",
rmpdProvince: "Province:",
rmpdRouteNumber: "Route number:",
rmpdRoutePlace: "Place of border crossing:",
rmpdSimcId: "City identifier of territorial division:",
rmpdSourceDocumentID: "Own number of the notification:",
rmpdStartEndPlaceJourney: "Place of start and end of the journey",
rmpdStartInsidePL: "Place of start of the journey",
rmpdStartTransportDate: "Start date of the carriage of goods:",
rmpdStatements: "Declarations",
rmpdStatements1: "I declare that I am authorized to submit this notification for and on behalf of the obligated entity",
rmpdStatementsFullName: "Full Name:",
rmpdStatus0: "Registered",
rmpdStatus1: "Incomplete",
rmpdStatus2: "Complete",
rmpdStatus3: "Closed",
rmpdStatus4: "Canceled",
rmpdStatus5: "Closed automatically",
rmpdStatusNo: "No",
rmpdStatusYes: "Yes",
rmpdTercId: "Identifier of territorial division:",
rmpdTraderIdentityNumber: "Identification number:",
rmpdTraderIdentityType: "Identification type:",
rmpdTraderName: "Full name:",
rmpdTrailerCountry: "Trailer country:",
rmpdTrailerNumber: "Trailer registration number:",
rmpdTransportMean: "Information on the means of transport",
rmpdTruckCountry: "Vehicle country:",
rmpdTruckNumber: "Vehicle registration number:",
rmpdTruckNumber: "Vehicle registration number:",
rmpdTypeOfPermission: "Selecting the type of permit or exemption from the obligation to have a permit:",
rmpdTypeOfPermission1: "Disposable permit",
rmpdTypeOfPermission2: "EKMT permit",
rmpdTypeOfPermission3: "Cabotage",
rmpdTypeOfPermission4: "Exemption from the obligation to have a permit",
rmpdTypeOfRoadTransport: "Type of transport performed:",
rmpdTypeOfRoadTransport1: "Bilateral transport",
rmpdTypeOfRoadTransport2: "Transit transport",
rmpdTypeOfRoadTransport3: "3rd country transport",
rmpdTypeOfRoadTransport4: "Cabotage",
rmpdTypeOfTransportDocument: "Transport document type:",
rmpdUlicId: "Street identifier of territorial division:",
rmpdURL: "URL address:",
rmpdUserName: "User Name:",
rmpdValidFrom: "Valid from:",
rmpdValidTo: "Valid to:",
rmpdWebservice: "Web service channel:",
rmpdWS: "Web service address which is indicated in the e-Client service:"
});

function loadHtmlDictionary() {
document.getElementById("htmlDictionary").innerText = JSON.stringify(languative.dictonaries.html, null, "  ");
}

function loadActiveDictionary() {
document.getElementById("activeDictionary").innerText = JSON.stringify(languative.getDictionaryFromHtml(), null, "  ");
}

//]]>
        </script>
        <style>
          * {
          -webkit-print-color-adjust: exact !important;
          color-adjust: exact !important;
          }

          @media print {
          body {-webkit-print-color-adjust: exact;}
          }

          body {
          font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
          margin: 0 auto;
          padding: 0 auto;
          }

          .rmpd-xslt h1 {
          padding: 6px 4px 4px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#E1E5E7;
          font-weight: bold;
          font-size: 14px;
          margin-bottom: 0;
          border-bottom: 1px solid #dbddde;
          }

          .rmpd-xslt {
          border-collapse: initial;
          }

          .rmpd-xslt .s1 {
          max-width: 1220px;
          border: 1px solid #c8c9ca;
          }

          .rmpd-xslt .t1 {
          position: relative;
          display: table;
          width: 100%;
          }

          .rmpd-xslt .header {
          font-size: 12px;
          margin: 0 !important;
          text-transform: uppercase;
          font-weight: normal;
          display:block;
          color: #000000;
          background-color:#EBEDEF;
          padding:6px 5px 5px 10px;
          border-top: 1px solid #dbddde;
          }

          .rmpd-xslt .header2 {
          font-size: 12px;
          margin: 0;
          font-weight: normal;
          display:block;
          background-color:#f6f6f6;
          padding:3px 3px 3px 10px;
          border-top: 1px solid #dbddde;
          }

          .rmpd-xslt .sent {
          font-size: 22px;
          text-transform: uppercase;
          font-weight: bold;
          display:block;
          padding: 5px 3px 5px 10px;
          }

          .rmpd-xslt .element-1 {
          font-size: 12px;
          font-weight: normal;
          }

          .rmpd-xslt .element-2 {
          font-size: 12px;
          font-weight: normal;
          text-decoration: underline;
          }

          .rmpd-xslt .grupInfo p {
          margin: 3px 0 3px 10px;
          font-weight: bold;
          font-size: 12px;
          }

          .rmpd-xslt .grupInfo {
          border-top: 1px solid #dbddde;
          }

          .rmpd-xslt .info {
          width: 100%;
          float: left;
          display: table-cell;
          padding: 4px 0px;
          }

          .rmpd-xslt .info1 {
          width: 50%;
          float: left;
          display: table-cell;
          padding: 4px 0px;
          }

          .rmpd-xslt .info3 {
          width: 33%;
          float: left;
          display: table-cell;
          }

          .rmpd-xslt .lang ul {
          margin: 0 auto;
          padding: 0;
          }

          .rmpd-xslt .lang ul li {
          display: inline;
          margin-left: 10px;
          }
        </style>
      </head>
      <body>
        <div class="rmpd-xslt">
          <section class="rmpd-xslt s1">
            <div class="rmpd-xslt lang">
              <ul>
                <li>
                  <span class="rmpd-xslt element-1" data-phrase-id="selectLanguage"/>
                </li>
                <li>
                  <span class="rmpd-xslt element-1">
                    <a href="#" onclick="languative.changeLanguage('en');">
                      <img
                        src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAB6ElEQVQoz2OYNHPfjqtvqqcfS2kGosOJjQdu3n27NrlxTUIdkOGZvc0jbYdtzIaoxp1zAvOr5x5lWLLi1P+Nq/79+3/74ZdFG27PX38HyP4/ped/XyuQMWnh5d65F06eePyvq+bf358TNl1gSGo5uOfku/9Ll/8/uPf///9t064Cyf+pmf8TEoF0Sd+lL4vWfO/uBrLnrbokaTIDpGHhhrt1E68+3Hf/T1P9fwiIifkfHgFi5Gb+f/Hiwp23jp7Li5qOCOpOZAA6FOQGNBAa+t/PD00MqOzMtZcMaxJr/0/u+J+S8j8+/n9k5P+QEJBSH59/rq6/7O1/Wlp+NzH5qqf3VVv7Z7Bbq7wVDhtsbf+YWUDMBeK/f//++fvn958/J6++YLCP29Qz53xU2o4rV9//f/vmZ3I8SJWRyW99Q7CGv0+dHPfP3CohPSskYT2DcDaDedi6xetBIfO5se5DV1dMyTEg+4+27i9NbaCrreyX/Pz//8usuS8SYpqmnmMQTGeYvPnyv39/v7dXHD1wu7DhYF7DYaAL/4Z4/A5y/vf3b3jattC41dsP3/r758frBN/soiUMVfMOTHFJds5cJKgzh0djMofqhPPXXrRKW7SIm5y+8pJBvJhBtIBBOFfEsK53z3VX0zwAPExoqi63l4YAAAAASUVORK5CYII='/>
                    </a>
                  </span>
                </li>
                <li>
                  <span class="rmpd-xslt element-1">
                    <a href="#" onclick="languative.changeLanguage('pl');">
                      <img
                        src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAMAAABBPP0LAAAAhFBMVEXDAADKAADVAQHX19faAADd3d3jDQ3k5eXlExPmGRnnLi7oHx/oMjLoNjbpJCTqKirq6urrLi7sLy/sOzrsRETtNDTtS0vuUFDu7u7vi4vvmZnwVlfwj4/xlJTy8vL0m5v19fX29vb39/f4+Pj5+fn6+vr7+/v8/Pz9/f39/f7+/v7///9BfFeGAAAAXUlEQVQIHQXB0W1CMRRAMecRpI7BZ/dfiRWQqBC5p/Z6wPDhz5t1+xWVqp4bq1FVLRuWqioucKuqNPu8AKNjtb3AdU5nuncB1zmdSTa4vtOZxrT94Hsf+TQstkEQ/8uqTs/uhVeSAAAAAElFTkSuQmCC'/>
                    </a>
                  </span>
                </li>
              </ul>
            </div>
            <h1 data-phrase-id="rmpd104"/>
            <div class="rmpd-xslt t1">
              <div class="rmpd-xslt sent">
                <div class="rmpd-xslt info1">
                  <xsl:value-of select="p:RmpdNumber"/>
                </div>
                <div class="rmpd-xslt info1">
                  <xsl:if test="p:CarrierKey != ''">
                    <span class="rmpd-xslt element-1" data-phrase-id="rmpdCarrierKey"/>
                    <xsl:value-of select="p:CarrierKey"/>
                  </xsl:if>
                </div>
              </div>
            </div>
            <xsl:if test="p:CancelOfTransport/tp:CancelComments != ''">
              <div class="rmpd-xslt t1">
                <p class="rmpd-xslt header" data-phrase-id="rmpdCancelOfTransport"/>
                <xsl:if test="p:DocumentId != ''">
                  <div class="rmpd-xslt t1">
                    <div class="rmpd-xslt grupInfo">
                      <div class="rmpd-xslt info">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdCancelComments"/>
                          <xsl:value-of select="p:CancelOfTransport/tp:CancelComments"/>
                        </p>
                      </div>
                    </div>
                  </div>
                </xsl:if>
              </div>
            </xsl:if>
            <xsl:if test="p:DocumentId != ''">
              <div class="rmpd-xslt t1">
                <p class="rmpd-xslt header" data-phrase-id="rmpdAdditionalInfo"/>
                <xsl:if test="p:DocumentId != ''">
                  <div class="rmpd-xslt t1">
                    <div class="rmpd-xslt grupInfo">
                      <div class="rmpd-xslt info">
                        <p>
                          <span class="rmpd-xslt element-1" data-phrase-id="rmpdSourceDocumentID"/>
                          <xsl:value-of select="p:DocumentId"/>
                        </p>
                      </div>
                    </div>
                  </div>
                </xsl:if>
              </div>
            </xsl:if>
            <xsl:if test="p:ResponseAddress != ''">
              <div class="rmpd-xslt t1">
                <p class="rmpd-xslt header" data-phrase-id="rmpdAdresses"/>
                <div class="rmpd-xslt grupInfo">
                  <div class="rmpd-xslt info1">
                    <p>
                      <span class="rmpd-xslt element-2" data-phrase-id="rmpdEmail"/>
                    </p>
                    <xsl:if test="p:ResponseAddress/tp:EmailChannel/tp:EmailAddress1 != ''">
                      <p>
                        <xsl:value-of select="p:ResponseAddress/tp:EmailChannel/tp:EmailAddress1"/>
                      </p>
                    </xsl:if>
                    <xsl:if test="p:ResponseAddress/tp:EmailChannel/tp:EmailAddress2 != ''">
                      <p>
                        <xsl:value-of select="p:ResponseAddress/tp:EmailChannel/tp:EmailAddress2"/>
                      </p>
                    </xsl:if>
                    <xsl:if test="p:ResponseAddress/tp:EmailChannel/tp:EmailAddress3 != ''">
                      <p>
                        <xsl:value-of select="p:ResponseAddress/tp:EmailChannel/tp:EmailAddress3"/>
                      </p>
                    </xsl:if>
                  </div>
                  <div class="rmpd-xslt info1">
                    <xsl:if test="p:ResponseAddress/tp:WebServiceChannel != ''">
                      <p>
                        <span class="rmpd-xslt element-2" data-phrase-id="rmpdWebservice"/>
                      </p>
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdWS"/>
                        <span>
                          <xsl:choose>
                            <xsl:when test="p:ResponseAddress/tp:WebServiceChannel/tp:WsFromSISC = 'true'">
                              <span data-phrase-id="rmpdStatusYes"/>
                            </xsl:when>
                            <xsl:when test="p:ResponseAddress/tp:WebServiceChannel/tp:WsFromSISC = 'false'">
                              <span data-phrase-id="rmpdStatusNo"/>
                            </xsl:when>
                          </xsl:choose>
                        </span>
                      </p>
                    </xsl:if>
                    <xsl:if test="p:ResponseAddress/tp:WebServiceChannel/tp:UrlAddress != ''">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdURL"/>
                        <xsl:value-of select="p:ResponseAddress/tp:WebServiceChannel/tp:UrlAddress"/>
                      </p>
                    </xsl:if>
                    <xsl:if test="p:ResponseAddress/tp:WebServiceChannel/tp:Username != ''">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdUserName"/>
                        <xsl:value-of select="p:ResponseAddress/tp:WebServiceChannel/tp:Username"/>
                      </p>
                    </xsl:if>
                    <xsl:if test="p:ResponseAddress/tp:WebServiceChannel/tp:UserPassword != ''">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdPassword"/>
                        <xsl:value-of select="p:ResponseAddress/tp:WebServiceChannel/tp:UserPassword"/>
                      </p>
                    </xsl:if>
                    <xsl:if test="p:ResponseAddress/tp:WebServiceChannel/tp:AuthenticationKey != ''">
                      <p>
                        <span class="rmpd-xslt element-1" data-phrase-id="rmpdAuthenticationKey"/>
                        <xsl:value-of select="p:ResponseAddress/tp:WebServiceChannel/tp:AuthenticationKey"/>
                      </p>
                    </xsl:if>
                  </div>
                </div>
              </div>
            </xsl:if>
            <div class="rmpd-xslt t1">
              <p class="rmpd-xslt header" data-phrase-id="rmpdStatements"/>
              <div class="rmpd-xslt grupInfo">
                <p>
                  <xsl:choose>
                    <xsl:when test="p:Statements/tp:Statement1 = 'true'">
                      <input type="checkbox" onclick="return false;" checked=""/>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdStatements1"/>
                    </xsl:when>
                    <xsl:when test="p:Statements/tp:Statement1 = 'false'">
                      <input type="checkbox" onclick="return false;"/>
                      <span class="rmpd-xslt element-1" data-phrase-id="rmpdStatements1"/>
                    </xsl:when>
                  </xsl:choose>
                </p>
                <p style="padding: 5px">
                  <span class="rmpd-xslt element-1" data-phrase-id="rmpdStatementsFullName"/>
                  <xsl:value-of select="p:Statements/tp:FirstName"/>&#160;<xsl:value-of select="p:Statements/tp:LastName"/>
                </p>
              </div>
            </div>
          </section>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
